/*
 * Decompiled with CFR 0.152.
 */
package jif.ast;

import java.util.LinkedList;
import java.util.List;
import jif.ast.AmbNewArray;
import jif.ast.JifNodeFactory;
import jif.ast.ParamNode;
import jif.types.JifPolyType;
import jif.types.JifTypeSystem;
import jif.types.Param;
import jif.types.ParamInstance;
import jif.types.SemanticDetailedException;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Ext;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.types.ClassType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.ListUtil;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

public class AmbNewArray_c
extends Expr_c
implements AmbNewArray {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected TypeNode baseType;
    protected Object expr;
    protected List<Expr> dims;
    protected int addDims;

    public AmbNewArray_c(Position pos, TypeNode baseType, Object expr, List<Expr> dims, int addDims) {
        this(pos, baseType, expr, dims, addDims, null);
    }

    public AmbNewArray_c(Position pos, TypeNode baseType, Object expr, List<Expr> dims, int addDims, Ext ext) {
        super(pos, ext);
        this.baseType = baseType;
        this.expr = expr;
        if (!(expr instanceof Expr) && !(expr instanceof Id)) {
            throw new InternalCompilerError("wrong type for expr: " + expr.getClass().getName());
        }
        this.dims = ListUtil.copy(dims, (boolean)true);
        this.addDims = addDims;
    }

    public boolean isDisambiguated() {
        return false;
    }

    @Override
    public TypeNode baseType() {
        return this.baseType;
    }

    @Override
    public AmbNewArray baseType(TypeNode baseType) {
        return this.baseType(this, baseType);
    }

    protected <N extends AmbNewArray_c> N baseType(N n, TypeNode baseType) {
        if (n.baseType == baseType) {
            return n;
        }
        n = (AmbNewArray_c)this.copyIfNeeded((Node)n);
        n.baseType = baseType;
        return n;
    }

    @Override
    public Object expr() {
        return this.expr;
    }

    protected <N extends AmbNewArray_c> N expr(N n, Object expr) {
        if (n.expr == expr) {
            return n;
        }
        n = (AmbNewArray_c)this.copyIfNeeded((Node)n);
        n.expr = expr;
        return n;
    }

    @Override
    public List<? extends Expr> dims() {
        return this.dims;
    }

    @Override
    public AmbNewArray dims(List<? extends Expr> dims) {
        return this.dims(this, dims);
    }

    protected <N extends AmbNewArray_c> N dims(N n, List<? extends Expr> dims) {
        if (CollectionUtil.equals(n.dims, dims)) {
            return n;
        }
        n = (AmbNewArray_c)this.copyIfNeeded((Node)n);
        n.dims = ListUtil.copy(dims, (boolean)true);
        return n;
    }

    @Override
    public int additionalDims() {
        return this.addDims;
    }

    @Override
    public AmbNewArray additionalDims(int addDims) {
        AmbNewArray_c n = (AmbNewArray_c)this.copy();
        n.addDims = addDims;
        return n;
    }

    protected <N extends AmbNewArray_c> N reconstruct(N n, TypeNode baseType, Object expr, List<? extends Expr> dims) {
        n = this.baseType(n, baseType);
        n = this.expr(n, expr);
        n = this.dims(n, dims);
        return n;
    }

    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        return succs;
    }

    public Term firstChild() {
        return null;
    }

    public Node visitChildren(NodeVisitor v) {
        TypeNode baseType = (TypeNode)this.visitChild((Node)this.baseType, v);
        List dims = this.visitList(this.dims, v);
        Object expr = this.expr;
        if (expr instanceof Expr) {
            expr = this.visitChild((Node)((Expr)expr), v);
        }
        return this.reconstruct(this, baseType, expr, dims);
    }

    public String toString() {
        return "new " + this.baseType + "[" + this.expr + "]...{amb}";
    }

    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        Expr e;
        if (this.expr instanceof Expr && !ar.isASTDisambiguated((Node)((Expr)this.expr))) {
            ar.job().extensionInfo().scheduler().currentGoal().setUnreachableThisRun();
            return this;
        }
        JifTypeSystem ts = (JifTypeSystem)ar.typeSystem();
        JifNodeFactory nf = (JifNodeFactory)ar.nodeFactory();
        if (this.dims.isEmpty()) {
            throw new InternalCompilerError(this.position(), "Cannot disambiguate ambiguous new array with no dimension expressions.");
        }
        Type t = this.baseType.type();
        if (t instanceof JifPolyType) {
            JifPolyType pt = (JifPolyType)t;
            if (pt.params().size() > 1) {
                throw new SemanticDetailedException("Not enough parameters for parameterized type " + pt + ".", "The type " + pt + " is a parameterized type with " + pt.params().size() + " parameters. So, to instantiate this type, " + "you must supply " + pt.params().size() + "", this.position());
            }
            if (pt.params().size() == 1) {
                ParamInstance pi = pt.params().get(0);
                ParamNode pn = this.expr instanceof Expr ? nf.AmbParam(this.position(), (Expr)this.expr, pi) : nf.AmbParam(this.position(), (Id)this.expr, pi);
                pn = (ParamNode)pn.del().disambiguate(ar);
                LinkedList<Param> l = new LinkedList<Param>();
                if (!pn.isDisambiguated()) {
                    ar.job().extensionInfo().scheduler().currentGoal().setUnreachableThisRun();
                    return this;
                }
                l.add(pn.parameter());
                ClassType base = ts.instantiate(this.baseType.position(), pt.instantiatedFrom(), l);
                return nf.NewArray(this.position(), (TypeNode)nf.CanonicalTypeNode(this.baseType.position(), (Type)base), this.dims, this.addDims);
            }
        }
        if (this.expr instanceof Expr) {
            e = (Expr)((Expr)this.expr).visit((NodeVisitor)ar);
        } else {
            e = nf.AmbExpr(this.position(), (Id)this.expr);
            e = (Expr)e.visit((NodeVisitor)ar);
        }
        LinkedList<Expr> l = new LinkedList<Expr>();
        l.add(e);
        l.addAll(this.dims);
        return nf.NewArray(this.position(), this.baseType, l, this.addDims);
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("new ");
        this.print((Node)this.baseType, w, tr);
        w.write("[");
        if (this.expr instanceof Expr) {
            this.print((Node)((Expr)this.expr), w, tr);
        } else {
            w.write(((Id)this.expr).id());
        }
        w.write("]");
        for (Expr e : this.dims) {
            w.write("[");
            this.printBlock((Node)e, w, tr);
            w.write("]");
        }
    }
}

