/*
 * Decompiled with CFR 0.152.
 */
package jif;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.tools.JavaFileManager;
import jif.ExtensionInfo;
import polyglot.main.OptFlag;
import polyglot.main.Options;
import polyglot.main.Report;
import polyglot.main.UsageError;

public class JifOptions
extends Options {
    public boolean nonRobustness;
    public boolean fatalExceptions;
    public boolean skipLabelChecking;
    public boolean solveGlobally;
    public boolean explainErrors;
    public boolean trustedProviders;
    public final List<File> sigcp = new ArrayList<File>();
    public boolean dependencyGraph;
    protected boolean noWarnings;
    protected boolean authFromProvider;

    public JifOptions(ExtensionInfo extension) {
        super((polyglot.frontend.ExtensionInfo)extension);
    }

    protected void populateFlags(Set<OptFlag<?>> flags) {
        flags.add((OptFlag<?>)new OptFlag.Switch("-globalsolve", "infer label variables globally (default: per class)"));
        flags.add((OptFlag<?>)new OptFlag.Switch(new String[]{"-explain", "-e"}, "provide more detailed explanations of failed label checking"));
        flags.add((OptFlag<?>)new OptFlag.Switch("-nonrobust", "skip robustness checks.", false));
        flags.add((OptFlag<?>)new OptFlag.Switch("-fail-on-exception", "re-throw uncaught and undeclared runtime exceptions as fatal errors."));
        flags.add((OptFlag<?>)new OptFlag.Switch("-robust", "force robustness checks", true, true));
        flags.add((OptFlag<?>)new OptFlag.PathFlag<File>("-sigcp", "<path>", "path for Jif signatures (e.g. for java.lang.Object)"){

            public File handlePathEntry(String entry) {
                File f = new File(entry);
                if (f.exists()) {
                    return f;
                }
                return null;
            }
        });
        flags.add((OptFlag<?>)new OptFlag.PathFlag<File>("-addsigcp", "<path>", "append <path> to Jif signature path"){

            public File handlePathEntry(String entry) {
                File f = new File(entry);
                if (f.exists()) {
                    return f;
                }
                return null;
            }
        });
        flags.add((OptFlag<?>)new OptFlag.IntFlag("-debug", "<num>", "set debug level to n. Prints more information about labels"));
        flags.add((OptFlag<?>)new OptFlag.Switch("-untrusted-providers", "set the providers of the sources being compiled to be untrusted"));
        flags.add((OptFlag<?>)new OptFlag.Switch("-auth-from-provider", "Use the provider label to determine authority."));
        flags.add((OptFlag<?>)new OptFlag.Switch("-no-warnings", "suppress compile-time warnings"));
        flags.add((OptFlag<?>)new OptFlag.Switch("-skip-label-checks", "Skip label checking."));
        super.populateFlags(flags);
    }

    protected void handleArg(OptFlag.Arg<?> arg) throws UsageError {
        if (arg.flag().ids().contains("-globalsolve")) {
            if (((Boolean)arg.value()).booleanValue()) {
                System.err.println("Will use a single solver to infer labels");
            }
            this.solveGlobally = (Boolean)arg.value();
        } else if (arg.flag().ids().contains("-explain") || arg.flag().ids().contains("-e")) {
            this.explainErrors = (Boolean)arg.value();
        } else if (arg.flag().ids().contains("-skip-label-checks")) {
            this.skipLabelChecking = (Boolean)arg.value();
        } else if (arg.flag().ids().contains("-nonrobust")) {
            this.nonRobustness = (Boolean)arg.value() == false;
        } else if (arg.flag().ids().contains("-fail-on-exception")) {
            this.fatalExceptions = (Boolean)arg.value();
        } else if (arg.flag().ids().contains("-robust")) {
            this.nonRobustness = (Boolean)arg.value() == false;
        } else if (arg.flag().ids().contains("-sigcp")) {
            this.sigcp.clear();
            this.sigcp.addAll((List)arg.value());
        } else if (arg.flag().ids().contains("-addsigcp")) {
            this.sigcp.addAll((List)arg.value());
        } else if (arg.flag().ids().contains("-debug")) {
            Report.addTopic((String)"debug", (int)((Integer)arg.value()));
        } else if (arg.flag().ids().contains("-untrusted-providers")) {
            this.trustedProviders = (Boolean)arg.value() == false;
        } else if (arg.flag().ids().contains("-auth-from-provider")) {
            this.authFromProvider = (Boolean)arg.value();
        } else if (arg.flag().ids().contains("-no-warnings")) {
            this.noWarnings = (Boolean)arg.value();
        } else {
            super.handleArg(arg);
        }
    }

    public boolean noWarnings() {
        return this.noWarnings;
    }

    public boolean authFromProvider() {
        return this.authFromProvider;
    }

    public static enum JifLocations implements JavaFileManager.Location
    {
        SIGNATURE_PATH(false);

        private final boolean isOutput;

        private JifLocations(boolean isOutput) {
            this.isOutput = isOutput;
        }

        @Override
        public boolean isOutputLocation() {
            return this.isOutput;
        }

        @Override
        public String getName() {
            return this.name();
        }
    }
}

