/*
 * Decompiled with CFR 0.152.
 */
package ppg.lex;

import java.io.IOException;
import java.io.OutputStream;
import java_cup.runtime.ComplexSymbolFactory;
import java_cup.runtime.Symbol;
import ppg.lex.LexerResult;

public class Token
implements LexerResult {
    private static ComplexSymbolFactory csf = new ComplexSymbolFactory();
    private Symbol symbol;
    private String filename;
    private int lineno;
    private Object value;
    static int lastID;

    public Token(String filename, int lineno, Object value) {
        this(-1, filename, lineno, -1, -1, value);
    }

    public Token(int id, String filename, int lineno, int left, int right, Object value) {
        this.symbol = csf.newSymbol(value.toString(), id, new ComplexSymbolFactory.Location(filename, lineno, left), new ComplexSymbolFactory.Location(filename, lineno, right), (Object)this);
        lastID = id;
        this.filename = filename;
        this.lineno = lineno;
        this.value = value;
    }

    public int getCode() {
        return this.symbol.sym;
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public Object getValue() {
        return this.value;
    }

    public String getID() {
        return Token.toString(this.symbol.sym);
    }

    public static String toString(int type) {
        switch (type) {
            case 2: {
                return "INCLUDE";
            }
            case 44: {
                return "EXTEND";
            }
            case 4: {
                return "DROP";
            }
            case 45: {
                return "OVERRIDE";
            }
            case 5: {
                return "TRANSFER";
            }
            case 27: {
                return "IMPORT";
            }
            case 12: {
                return "CCEQ";
            }
            case 10: {
                return "SEMI";
            }
            case 9: {
                return "COMMA";
            }
            case 17: {
                return "DOT";
            }
            case 11: {
                return "COLON";
            }
            case 6: {
                return "LBRACE";
            }
            case 7: {
                return "RBRACE";
            }
            case 18: {
                return "LBRACK";
            }
            case 19: {
                return "RBRACK";
            }
            case 20: {
                return "LT";
            }
            case 21: {
                return "GT";
            }
            case 42: {
                return "ID";
            }
            case 43: {
                return "CODE_STR";
            }
            case 41: {
                return "STRING_CONST";
            }
            case 34: {
                return "WITH";
            }
            case 30: {
                return "PARSER";
            }
            case 32: {
                return "INIT";
            }
            case 36: {
                return "STAR";
            }
            case 13: {
                return "BAR";
            }
            case 33: {
                return "SCAN";
            }
            case 31: {
                return "NON";
            }
            case 28: {
                return "CODE";
            }
            case 38: {
                return "LEFT";
            }
            case 35: {
                return "START";
            }
            case 15: {
                return "NONTERMINAL";
            }
            case 29: {
                return "ACTION";
            }
            case 3: {
                return "TO";
            }
            case 26: {
                return "PACKAGE";
            }
            case 40: {
                return "NONASSOC";
            }
            case 37: {
                return "PRECEDENCE";
            }
            case 16: {
                return "PRECEDENCE";
            }
            case 14: {
                return "TERMINAL";
            }
            case 39: {
                return "RIGHT";
            }
            case 0: {
                return "EOF";
            }
            case 1: {
                return "ERROR";
            }
        }
        return "<undefined>";
    }

    public String toString() {
        return (String)this.value;
    }

    @Override
    public void unparse(OutputStream o) {
        if (this.value != null) {
            try {
                o.write((this.filename + ":" + this.lineno + ": " + this.getID() + ": \"" + this.value + "\"").getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getFilename() {
        return this.filename;
    }

    @Override
    public int lineNumber() {
        return this.lineno;
    }

    public int getLineno() {
        return this.lineno;
    }

    public void setLineno(int i) {
        this.lineno = i;
    }
}

