/*
 * Decompiled with CFR 0.152.
 */
package ppg.atoms;

import java.util.Vector;
import ppg.atoms.GrammarPart;
import ppg.atoms.Nonterminal;
import ppg.atoms.SemanticAction;
import ppg.parse.Unparse;
import ppg.util.CodeWriter;

public class Production
implements Unparse {
    private Nonterminal lhs;
    private Vector<Vector<GrammarPart>> rhs;
    private static String HEADER = "ppg [nterm]: ";

    public Production(Nonterminal lhs, Vector<Vector<GrammarPart>> rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public Nonterminal getLHS() {
        return this.lhs;
    }

    public void setLHS(Nonterminal nt) {
        this.lhs = nt;
    }

    public Vector<Vector<GrammarPart>> getRHS() {
        return this.rhs;
    }

    public Object clone() {
        return new Production((Nonterminal)this.lhs.clone(), (Vector)this.rhs.clone());
    }

    public void drop(Production prod) {
        Vector<Vector<GrammarPart>> toDrop = prod.getRHS();
        block0: for (int i = 0; i < toDrop.size(); ++i) {
            Vector<GrammarPart> target = toDrop.elementAt(i);
            for (int j = 0; j < this.rhs.size(); ++j) {
                Vector<GrammarPart> source = this.rhs.elementAt(j);
                if (Production.isSameProduction(target, source)) {
                    this.rhs.removeElementAt(j);
                    continue block0;
                }
                if (j != this.rhs.size() - 1) continue;
                System.err.println(HEADER + "no match found for production:");
                System.err.print(prod.getLHS() + " ::= ");
                for (int k = 0; k < target.size(); ++k) {
                    System.err.print(target.elementAt(k) + " ");
                }
                System.exit(1);
            }
        }
    }

    public static boolean isSameProduction(Vector<GrammarPart> u, Vector<GrammarPart> v) {
        int uIdx = 0;
        int vIdx = 0;
        GrammarPart ug = null;
        GrammarPart vg = null;
        while (uIdx < u.size() && vIdx < v.size()) {
            ug = u.elementAt(uIdx);
            if (ug instanceof SemanticAction) {
                ++uIdx;
                continue;
            }
            vg = v.elementAt(vIdx);
            if (vg instanceof SemanticAction) {
                ++vIdx;
                continue;
            }
            if (!ug.equals(vg)) {
                return false;
            }
            ++uIdx;
            ++vIdx;
        }
        if (uIdx == u.size() && vIdx == v.size()) {
            return true;
        }
        if (uIdx < u.size()) {
            while (uIdx < u.size()) {
                ug = u.elementAt(uIdx);
                if (!(ug instanceof SemanticAction)) {
                    return false;
                }
                ++uIdx;
            }
            return true;
        }
        while (vIdx < v.size()) {
            vg = v.elementAt(vIdx);
            if (!(vg instanceof SemanticAction)) {
                return false;
            }
            ++vIdx;
        }
        return true;
    }

    public void union(Production prod) {
        Vector<Vector<GrammarPart>> additional = prod.getRHS();
        this.union(additional);
    }

    public void union(Vector<Vector<GrammarPart>> prodList) {
        for (int i = 0; i < prodList.size(); ++i) {
            Vector<GrammarPart> current;
            Vector<GrammarPart> toAdd = prodList.elementAt(i);
            for (int j = 0; j < this.rhs.size() && !Production.isSameProduction(toAdd, current = this.rhs.elementAt(i)); ++j) {
                if (j != this.rhs.size() - 1) continue;
                this.rhs.addElement(toAdd);
            }
        }
    }

    public void add(Production prod) {
        Vector<Vector<GrammarPart>> additional = prod.getRHS();
        for (int i = 0; i < additional.size(); ++i) {
            this.rhs.addElement(additional.elementAt(i));
        }
    }

    public void addToRHS(Vector<GrammarPart> rhsPart) {
        this.rhs.addElement(rhsPart);
    }

    @Override
    public void unparse(CodeWriter cw) {
        cw.begin(0);
        cw.write(this.lhs.toString() + " ::=");
        cw.allowBreak(3);
        for (int i = 0; i < this.rhs.size(); ++i) {
            Vector<GrammarPart> rhs_part = this.rhs.elementAt(i);
            for (int j = 0; j < rhs_part.size(); ++j) {
                cw.write(" ");
                rhs_part.elementAt(j).unparse(cw);
            }
            if (i >= this.rhs.size() - 1) continue;
            cw.allowBreak(0);
            cw.write(" | ");
        }
        cw.write(";");
        cw.newline();
        cw.newline();
        cw.end();
    }

    public String toString() {
        String result = this.lhs.toString();
        result = result + " ::=";
        for (int i = 0; i < this.rhs.size(); ++i) {
            Vector<GrammarPart> rhs_part = this.rhs.elementAt(i);
            for (int j = 0; j < rhs_part.size(); ++j) {
                result = result + " " + rhs_part.elementAt(j).toString();
            }
            if (i >= this.rhs.size() - 1) continue;
            result = result + " | ";
        }
        return result + ";";
    }
}

