/*
 * Decompiled with CFR 0.152.
 */
package ppg;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import ppg.PPGError;
import ppg.lex.Lexer;
import ppg.parse.Parser;
import ppg.spec.CUPSpec;
import ppg.spec.Spec;
import ppg.util.CodeWriter;

public class PPG {
    public static final String HEADER = "ppg: ";
    public static final String DEBUG_HEADER = "ppg [debug]: ";
    public static boolean debug = false;
    public static String SYMBOL_CLASS_NAME = "sym";
    public static String OUTPUT_FILE = null;

    public static void DEBUG(String s) {
        if (debug) {
            System.err.println(DEBUG_HEADER + s);
        }
    }

    public static void main(String[] args) {
        String filename = null;
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].charAt(0) == '-') {
                    if (args[i].equals("-symbols")) {
                        if (args.length > i) {
                            SYMBOL_CLASS_NAME = args[++i];
                            continue;
                        }
                        throw new Exception("No filename specified after -symbols");
                    }
                    if (args[i].equals("-o")) {
                        if (args.length > i) {
                            OUTPUT_FILE = args[++i];
                            continue;
                        }
                        throw new Exception("No filename specified after -o");
                    }
                    throw new Exception("Invalid switch: " + args[i]);
                }
                if (filename == null) {
                    filename = args[i];
                    continue;
                }
                throw new Exception("Error: multiple source files specified.");
            }
        }
        catch (Exception e) {
            System.err.println(HEADER + e.getMessage());
            PPG.usage();
        }
        if (filename == null) {
            System.err.println("Error: no filename specified.");
            PPG.usage();
        }
        try (FileReader fileReader = new FileReader(filename);){
            Lexer lex = new Lexer(fileReader, filename);
            Parser parser = new Parser(filename, lex);
            try {
                parser.parse();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                System.err.println("ppg: Exception: " + e.getMessage());
                System.exit(1);
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Error: " + filename + " is not found.");
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("ppg: Exception: " + e.getMessage());
            System.exit(1);
        }
        Spec spec = (Spec)Parser.getProgramNode();
        File file = new File(filename);
        String parent = file.getParent();
        spec.parseChain(parent == null ? "" : parent);
        PrintStream out = System.out;
        try {
            if (OUTPUT_FILE != null) {
                out = new PrintStream(new FileOutputStream(OUTPUT_FILE));
            }
            CUPSpec combined = spec.coalesce();
            CodeWriter cw = new CodeWriter(out, 80);
            combined.unparse(cw);
            cw.flush();
        }
        catch (PPGError e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("ppg: Exception: " + e.getMessage());
            System.exit(1);
        }
    }

    public static void usage() {
        System.err.println("Usage: ppg [-symbols ConstClass] <input file>\nwhere:\n\t-c <Class>\tclass prepended to token names to pass to <func>\n\t<input>\ta PPG or CUP source file\n");
        System.exit(1);
    }
}

