/*
 * Decompiled with CFR 0.152.
 */
package jif.runtime;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jif.lang.ActsForProof;
import jif.lang.Closure;
import jif.lang.DelegatesProof;
import jif.lang.Label;
import jif.lang.Principal;
import jif.lang.PrincipalUtil;
import jif.lang.TransitiveProof;

public class NativePrincipal
implements Principal {
    private static final ConcurrentMap<String, NativePrincipal> allNatives = new ConcurrentHashMap<String, NativePrincipal>();
    private static NativePrincipal UNKNOWN_NATIVE_PRINCIPAL = new NativePrincipal("unknown-principal"){};
    private final String name;
    protected final Set<Principal> superiors = new LinkedHashSet<Principal>();

    static NativePrincipal getInstance(String name) {
        NativePrincipal newp;
        if (name == null) {
            return UNKNOWN_NATIVE_PRINCIPAL;
        }
        NativePrincipal p = (NativePrincipal)allNatives.get(name);
        if (p == null && (p = allNatives.putIfAbsent(name, newp = new NativePrincipal(name))) == null) {
            p = newp;
        }
        return p;
    }

    private NativePrincipal(String name) {
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    public Set<Principal> superiors() {
        return this.superiors;
    }

    @Override
    public boolean delegatesTo(Principal p) {
        return this.superiors.contains(p);
    }

    @Override
    public boolean isAuthorized(Object authorizationProof, Closure closure, Label lb, boolean executeNow) {
        return false;
    }

    @Override
    public ActsForProof findProofDownto(Principal q, Object searchState) {
        return null;
    }

    @Override
    public ActsForProof findProofUpto(Principal p, Object searchState) {
        for (Principal s : this.superiors) {
            ActsForProof prf = PrincipalUtil.findActsForProof(p, s, searchState);
            if (prf == null) continue;
            return new TransitiveProof(prf, s, new DelegatesProof(s, this));
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Principal) {
            return this.equals((Principal)o);
        }
        return false;
    }

    @Override
    public boolean equals(Principal p) {
        return p != null && (this.name == p.name() || this.name != null && this.name.equals(p.name())) && this.getClass() == p.getClass();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    protected static Principal[] addToChainBottom(Principal[] chain, Principal principal) {
        if (chain == null) {
            Principal[] newChain = new Principal[]{principal};
            return newChain;
        }
        Principal[] newChain = new Principal[chain.length + 1];
        for (int i = 0; i < chain.length; ++i) {
            newChain[i] = chain[i];
        }
        newChain[chain.length] = principal;
        return newChain;
    }

    protected static Principal[] addToChainTop(Principal principal, Principal[] chain) {
        if (chain == null) {
            Principal[] newChain = new Principal[]{principal};
            return newChain;
        }
        Principal[] newChain = new Principal[chain.length + 1];
        newChain[0] = principal;
        for (int i = 0; i < chain.length; ++i) {
            newChain[i + 1] = chain[i];
        }
        return newChain;
    }
}

