/*
 * Decompiled with CFR 0.152.
 */
package jif.runtime;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import jif.lang.Label;
import jif.lang.LabelUtil;
import jif.lang.Principal;
import jif.runtime.NativePrincipal;
import jif.runtime.Runtime;

public class FileSystem {
    public static Label labelOf(String file) throws FileNotFoundException {
        File f = new File(file);
        if (!f.exists()) {
            throw new FileNotFoundException("File " + file + " not found");
        }
        String[] readers = FileSystem.readers(file);
        String owner = FileSystem.owner(file);
        LinkedList<Principal> readerList = new LinkedList<Principal>();
        for (int i = 0; readers != null && i < readers.length; ++i) {
            readerList.add(NativePrincipal.getInstance(readers[i]));
        }
        NativePrincipal op = NativePrincipal.getInstance(owner);
        return LabelUtil.singleton().readerPolicyLabel((Principal)op, readerList);
    }

    public static Set<Principal> groups(NativePrincipal p) {
        LinkedHashSet<Principal> grps = new LinkedHashSet<Principal>();
        LinkedHashSet<Principal> supers = new LinkedHashSet<Principal>(p.superiors());
        while (!supers.isEmpty()) {
            Principal one = (Principal)supers.iterator().next();
            if (one instanceof NativePrincipal) {
                supers.addAll(((NativePrincipal)one).superiors());
                grps.add(one);
            }
            supers.remove(one);
        }
        return grps;
    }

    private static native void setPolicy(String var0, String var1, String[] var2);

    private static native String[] readers(String var0);

    private static native String owner(String var0);

    static {
        Runtime.loadRuntimeLibrary();
    }
}

