/*
 * Decompiled with CFR 0.152.
 */
package jif.net;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import jif.lang.Label;
import jif.net.SocketAcceptor;

public class SocketUtil {
    private static boolean DEBUG = false;

    private SocketUtil() {
    }

    public static void acceptConnections(Label lbl, ServerSocket ss, SocketAcceptor a) {
        if (ss == null || a == null) {
            return;
        }
        while (true) {
            try {
                while (true) {
                    if (DEBUG) {
                        System.out.println("Listening on port " + ss.getLocalPort());
                    }
                    Socket s = ss.accept();
                    if (DEBUG) {
                        System.out.println("Got socket: " + s.getPort());
                    }
                    new Thread(new SocketAcceptorRunner(a, s)).start();
                }
            }
            catch (Exception e) {
                if (!DEBUG) continue;
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private static class SocketAcceptorRunner
    implements Runnable {
        private final SocketAcceptor a;
        private final Socket s;

        SocketAcceptorRunner(SocketAcceptor a, Socket s) {
            this.a = a;
            this.s = s;
        }

        @Override
        public void run() {
            try {
                if (DEBUG) {
                    System.out.println("Calling accept for socket #" + this.s.getPort());
                }
                this.a.accept(this.s.getInputStream(), this.s.getOutputStream());
                if (DEBUG) {
                    System.out.println("Finished accept for socket #" + this.s.getPort());
                }
            }
            catch (Exception e) {
                if (DEBUG) {
                    e.printStackTrace();
                }
            }
            finally {
                block15: {
                    try {
                        this.s.close();
                    }
                    catch (IOException e) {
                        if (!DEBUG) break block15;
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

