/*
 * Decompiled with CFR 0.152.
 */
package jif.lang;

import java.util.HashSet;
import java.util.Set;
import jif.lang.AbstractPolicy;
import jif.lang.ActsForProof;
import jif.lang.IntegPolicy;
import jif.lang.JoinIntegPolicy;
import jif.lang.JoinPolicy;
import jif.lang.LabelUtil;
import jif.lang.MeetIntegPolicy;
import jif.lang.MeetPolicy;
import jif.lang.Policy;
import jif.lang.Principal;
import jif.lang.PrincipalUtil;

public class WriterPolicy
extends AbstractPolicy
implements IntegPolicy {
    private final Principal owner;
    private final Principal writer;

    public WriterPolicy(LabelUtil labelUtil, Principal owner, Principal writer) {
        super(labelUtil);
        this.owner = owner;
        this.writer = writer;
    }

    public Principal owner() {
        return this.owner;
    }

    public Principal writer() {
        return this.writer;
    }

    @Override
    public boolean relabelsTo(Policy p, Set<PrincipalUtil.DelegationPair> s) {
        if (this == p || this.equals(p)) {
            return true;
        }
        if (p instanceof JoinIntegPolicy) {
            JoinPolicy jp = (JoinPolicy)p;
            for (Policy pi : jp.joinComponents()) {
                if (!this.labelUtil.relabelsTo(this, pi, s)) continue;
                return true;
            }
            return false;
        }
        if (p instanceof MeetIntegPolicy) {
            MeetPolicy mp = (MeetPolicy)p;
            HashSet<PrincipalUtil.DelegationPair> temp = new HashSet<PrincipalUtil.DelegationPair>();
            for (Policy pi : mp.meetComponents()) {
                if (this.labelUtil.relabelsTo(this, pi, temp)) continue;
                return false;
            }
            s.addAll(temp);
            return true;
        }
        if (!(p instanceof WriterPolicy)) {
            return false;
        }
        WriterPolicy pp = (WriterPolicy)p;
        ActsForProof ownersProof = PrincipalUtil.actsForProof(this.owner, pp.owner);
        if (ownersProof == null) {
            return false;
        }
        ActsForProof writerWriterProof = PrincipalUtil.actsForProof(this.writer, pp.writer);
        if (writerWriterProof != null) {
            ownersProof.gatherDelegationDependencies(s);
            writerWriterProof.gatherDelegationDependencies(s);
            return true;
        }
        ActsForProof writerOwnerProof = PrincipalUtil.actsForProof(this.writer, pp.owner);
        if (writerOwnerProof != null) {
            ownersProof.gatherDelegationDependencies(s);
            writerOwnerProof.gatherDelegationDependencies(s);
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return (this.owner == null ? 0 : this.owner.hashCode()) ^ (this.writer == null ? 0 : this.writer.hashCode()) ^ 0xFFFE17CE;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WriterPolicy)) {
            return false;
        }
        WriterPolicy policy = (WriterPolicy)o;
        if (this.owner == policy.owner || this.owner != null && this.owner.equals(policy.owner) && policy.owner != null && policy.owner.equals(this.owner)) {
            return this.writer == policy.writer || this.writer != null && this.writer.equals(policy.writer) && policy.writer != null && policy.writer.equals(this.writer);
        }
        return false;
    }

    public String toString() {
        String str = PrincipalUtil.toString(this.owner) + "<-";
        if (!PrincipalUtil.isTopPrincipal(this.writer)) {
            str = str + PrincipalUtil.toString(this.writer);
        }
        return str;
    }

    @Override
    public IntegPolicy join(IntegPolicy p, Set<PrincipalUtil.DelegationPair> s) {
        return this.join(p, s, true);
    }

    @Override
    public IntegPolicy meet(IntegPolicy p, Set<PrincipalUtil.DelegationPair> s) {
        return this.meet(p, s, true);
    }

    @Override
    public IntegPolicy join(IntegPolicy p) {
        return this.join(p, true);
    }

    @Override
    public IntegPolicy meet(IntegPolicy p) {
        return this.meet(p, true);
    }

    @Override
    public IntegPolicy join(IntegPolicy p, boolean simplify) {
        return this.labelUtil.join(this, p, simplify);
    }

    @Override
    public IntegPolicy meet(IntegPolicy p, boolean simplify) {
        return this.labelUtil.meet(this, p, simplify);
    }

    @Override
    public IntegPolicy join(IntegPolicy p, Set<PrincipalUtil.DelegationPair> s, boolean simplify) {
        return this.labelUtil.join(this, p, s, simplify);
    }

    @Override
    public IntegPolicy meet(IntegPolicy p, Set<PrincipalUtil.DelegationPair> s, boolean simplify) {
        return this.labelUtil.meet(this, p, s, simplify);
    }
}

