/*
 * Decompiled with CFR 0.152.
 */
package jif.lang;

import java.util.HashSet;
import java.util.Set;
import jif.lang.AbstractPolicy;
import jif.lang.ActsForProof;
import jif.lang.ConfPolicy;
import jif.lang.JoinConfPolicy;
import jif.lang.JoinPolicy;
import jif.lang.LabelUtil;
import jif.lang.MeetConfPolicy;
import jif.lang.MeetPolicy;
import jif.lang.Policy;
import jif.lang.Principal;
import jif.lang.PrincipalUtil;

public class ReaderPolicy
extends AbstractPolicy
implements ConfPolicy {
    private final Principal owner;
    private final Principal reader;

    public ReaderPolicy(LabelUtil labelUtil, Principal owner, Principal reader) {
        super(labelUtil);
        this.owner = owner;
        this.reader = reader;
    }

    public Principal owner() {
        return this.owner;
    }

    public Principal reader() {
        return this.reader;
    }

    @Override
    public boolean relabelsTo(Policy p, Set<PrincipalUtil.DelegationPair> s) {
        if (this == p || this.equals(p)) {
            return true;
        }
        if (p instanceof JoinConfPolicy) {
            JoinPolicy jp = (JoinPolicy)p;
            for (Policy pi : jp.joinComponents()) {
                if (!this.labelUtil.relabelsTo(this, pi, s)) continue;
                return true;
            }
            return false;
        }
        if (p instanceof MeetConfPolicy) {
            MeetPolicy mp = (MeetPolicy)p;
            HashSet<PrincipalUtil.DelegationPair> temp = new HashSet<PrincipalUtil.DelegationPair>();
            for (Policy pi : mp.meetComponents()) {
                if (this.labelUtil.relabelsTo(this, pi, temp)) continue;
                return false;
            }
            s.addAll(temp);
            return true;
        }
        if (!(p instanceof ReaderPolicy)) {
            return false;
        }
        ReaderPolicy pp = (ReaderPolicy)p;
        ActsForProof ownersProof = PrincipalUtil.actsForProof(pp.owner, this.owner);
        if (ownersProof == null) {
            return false;
        }
        ActsForProof readerReaderProof = PrincipalUtil.actsForProof(pp.reader, this.reader);
        if (readerReaderProof != null) {
            ownersProof.gatherDelegationDependencies(s);
            readerReaderProof.gatherDelegationDependencies(s);
            return true;
        }
        ActsForProof readerOwnerProof = PrincipalUtil.actsForProof(pp.reader, this.owner);
        if (readerOwnerProof != null) {
            ownersProof.gatherDelegationDependencies(s);
            readerOwnerProof.gatherDelegationDependencies(s);
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return (this.owner == null ? 0 : this.owner.hashCode()) ^ (this.reader == null ? 0 : this.reader.hashCode()) ^ 0x108E;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReaderPolicy)) {
            return false;
        }
        ReaderPolicy policy = (ReaderPolicy)o;
        if (this.owner == policy.owner || this.owner != null && this.owner.equals(policy.owner) && policy.owner != null && policy.owner.equals(this.owner)) {
            return this.reader == policy.reader || this.reader != null && this.reader.equals(policy.reader) && policy.reader != null && policy.reader.equals(this.reader);
        }
        return false;
    }

    public String toString() {
        String str = PrincipalUtil.toString(this.owner) + "->";
        if (!PrincipalUtil.isTopPrincipal(this.reader)) {
            str = str + PrincipalUtil.toString(this.reader);
        }
        return str;
    }

    @Override
    public ConfPolicy join(ConfPolicy p, Set<PrincipalUtil.DelegationPair> s) {
        return this.join(p, s, true);
    }

    @Override
    public ConfPolicy meet(ConfPolicy p, Set<PrincipalUtil.DelegationPair> s) {
        return this.meet(p, s, true);
    }

    @Override
    public ConfPolicy join(ConfPolicy p) {
        return this.join(p, true);
    }

    @Override
    public ConfPolicy meet(ConfPolicy p) {
        return this.meet(p, true);
    }

    @Override
    public ConfPolicy join(ConfPolicy p, boolean simplify) {
        return this.labelUtil.join(this, p, simplify);
    }

    @Override
    public ConfPolicy meet(ConfPolicy p, boolean simplify) {
        return this.labelUtil.meet(this, p, simplify);
    }

    @Override
    public ConfPolicy join(ConfPolicy p, Set<PrincipalUtil.DelegationPair> s, boolean simplify) {
        return this.labelUtil.join(this, p, s, simplify);
    }

    @Override
    public ConfPolicy meet(ConfPolicy p, Set<PrincipalUtil.DelegationPair> s, boolean simplify) {
        return this.labelUtil.meet(this, p, s, simplify);
    }
}

