/*
 * Decompiled with CFR 0.152.
 */
package jif.lang;

import java.util.HashSet;
import java.util.Set;
import jif.lang.ConfPolicy;
import jif.lang.IntegPolicy;
import jif.lang.Label;
import jif.lang.LabelUtil;
import jif.lang.PrincipalUtil;

public final class PairLabel
implements Label {
    private final ConfPolicy confPol;
    private final IntegPolicy integPol;
    private Integer hashCode = null;
    private LabelUtil labelUtil;

    public PairLabel(LabelUtil labelUtil, ConfPolicy confPol, IntegPolicy integPol) {
        this.labelUtil = labelUtil;
        this.confPol = confPol;
        this.integPol = integPol;
        if (confPol == null || integPol == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public boolean relabelsTo(Label l, Set<PrincipalUtil.DelegationPair> s) {
        if (l instanceof PairLabel) {
            PairLabel that = (PairLabel)l;
            if (this == that || this.equals(that)) {
                return true;
            }
            HashSet<PrincipalUtil.DelegationPair> temp = new HashSet<PrincipalUtil.DelegationPair>();
            if (this.labelUtil.relabelsTo(this.confPol, that.confPol, temp) && this.labelUtil.relabelsTo(this.integPol, that.integPol, temp)) {
                s.addAll(temp);
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = new Integer(this.confPol.hashCode() ^ this.integPol.hashCode());
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof PairLabel) {
            PairLabel that = (PairLabel)o;
            return this == that || this.hashCode() == that.hashCode() && this.confPol.equals(that.confPol) && this.integPol.equals(that.integPol);
        }
        return false;
    }

    public final String toString() {
        String c = this.confPol.toString();
        String i = this.integPol.toString();
        if (c.length() > 0 && i.length() > 0) {
            return "{" + c + "; " + i + "}";
        }
        return "{" + c + i + "}";
    }

    @Override
    public final Label join(Label l) {
        return this.join(l, true);
    }

    @Override
    public final Label join(Label l, boolean simplify) {
        return this.labelUtil.join(this, l, simplify);
    }

    @Override
    public Label meet(Label l) {
        return this.meet(l, true);
    }

    @Override
    public Label meet(Label l, boolean simplify) {
        return this.labelUtil.meet(this, l, simplify);
    }

    @Override
    public ConfPolicy confPolicy() {
        return this.confPol;
    }

    @Override
    public IntegPolicy integPolicy() {
        return this.integPol;
    }
}

