/*
 * Decompiled with CFR 0.152.
 */
package jif.lang;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jif.lang.ConfPolicy;
import jif.lang.IntegPolicy;
import jif.lang.JoinConfPolicy;
import jif.lang.JoinIntegPolicy;
import jif.lang.Label;
import jif.lang.MeetConfPolicy;
import jif.lang.MeetIntegPolicy;
import jif.lang.PairLabel;
import jif.lang.Policy;
import jif.lang.Principal;
import jif.lang.PrincipalSet;
import jif.lang.PrincipalUtil;
import jif.lang.ReaderPolicy;
import jif.lang.WriterPolicy;

public class LabelUtil {
    protected static LabelUtil singleton = new LabelUtil();
    private ThreadLocal<Stats> statsPerThread = new ThreadLocal<Stats>(){

        @Override
        protected Stats initialValue() {
            return new Stats();
        }
    };
    public static final boolean COUNT_TIME = false;
    public static final boolean USE_CACHING = true;
    private Map<Pair, Pair> cacheTrueLabelRelabels = new ConcurrentHashMap<Pair, Pair>();
    private Map<Pair, Pair> cacheFalseLabelRelabels = new ConcurrentHashMap<Pair, Pair>();
    private Map<PrincipalUtil.DelegationPair, Set<Pair>> cacheTrueLabelRelabelsDependencies = new ConcurrentHashMap<PrincipalUtil.DelegationPair, Set<Pair>>();
    private Map<Pair, Set<PrincipalUtil.DelegationPair>> cacheTruePolicyRelabels = new ConcurrentHashMap<Pair, Set<PrincipalUtil.DelegationPair>>();
    private Map<Pair, Pair> cacheFalsePolicyRelabels = new ConcurrentHashMap<Pair, Pair>();
    private Map<PrincipalUtil.DelegationPair, Set<Pair>> cacheTruePolicyRelabelsDependencies = new ConcurrentHashMap<PrincipalUtil.DelegationPair, Set<Pair>>();
    private Map<Pair, Label> cacheLabelJoins = new ConcurrentHashMap<Pair, Label>();
    private Map<Pair, Label> cacheLabelMeets = new ConcurrentHashMap<Pair, Label>();
    private Map<PrincipalUtil.DelegationPair, Set<Pair>> cacheLabelJoinDependencies = new ConcurrentHashMap<PrincipalUtil.DelegationPair, Set<Pair>>();
    private Map<PrincipalUtil.DelegationPair, Set<Pair>> cacheLabelMeetDependencies = new ConcurrentHashMap<PrincipalUtil.DelegationPair, Set<Pair>>();
    private final ConfPolicy BOTTOM_CONF = this.readerPolicy(null, (Principal)null);
    private final ConfPolicy TOP_CONF = this.readerPolicy(PrincipalUtil.topPrincipal(), PrincipalUtil.topPrincipal());
    private final IntegPolicy TOP_INTEG = this.writerPolicy(null, (Principal)null);
    private final Label NO_COMPONENTS = this.toLabel(this.BOTTOM_CONF, this.TOP_INTEG);

    protected LabelUtil() {
    }

    public static LabelUtil singleton() {
        return singleton;
    }

    void enterTiming() {
    }

    void exitTiming() {
    }

    public long getAndClearTime() {
        long r = -1L;
        return r;
    }

    public int getAndClearCount() {
        int r = -1;
        return r;
    }

    public int getAndClearTopCount() {
        int r = -1;
        return r;
    }

    public Label noComponents() {
        return this.NO_COMPONENTS;
    }

    public ConfPolicy bottomConf() {
        return this.BOTTOM_CONF;
    }

    public ConfPolicy topConf() {
        return this.TOP_CONF;
    }

    public IntegPolicy topInteg() {
        return this.TOP_INTEG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfPolicy readerPolicy(Principal owner, Principal reader) {
        try {
            this.enterTiming();
            ReaderPolicy readerPolicy = new ReaderPolicy(this, owner, reader);
            return readerPolicy;
        }
        finally {
            this.exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfPolicy readerPolicy(Principal owner, Collection<Principal> readers) {
        try {
            this.enterTiming();
            ConfPolicy confPolicy = this.readerPolicy(owner, PrincipalUtil.disjunction(readers));
            return confPolicy;
        }
        finally {
            this.exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfPolicy readerPolicy(Label lbl, Principal owner, Principal[] readers) {
        try {
            this.enterTiming();
            if (readers == null) {
                ConfPolicy confPolicy = this.readerPolicy(owner, Collections.emptySet());
                return confPolicy;
            }
            ConfPolicy confPolicy = this.readerPolicy(owner, Arrays.asList(readers));
            return confPolicy;
        }
        finally {
            this.exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfPolicy readerPolicy(Principal owner, PrincipalSet writers) {
        try {
            this.enterTiming();
            ConfPolicy confPolicy = this.readerPolicy(owner, writers.getSet());
            return confPolicy;
        }
        finally {
            this.exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Label readerPolicyLabel(Principal owner, Principal reader) {
        try {
            this.enterTiming();
            Label label = this.toLabel(this.readerPolicy(owner, reader));
            return label;
        }
        finally {
            this.exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Label readerPolicyLabel(Principal owner, Collection<Principal> readers) {
        try {
            Label l;
            this.enterTiming();
            Label label = l = this.toLabel(this.readerPolicy(owner, PrincipalUtil.disjunction(readers)));
            return label;
        }
        finally {
            this.exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Label readerPolicyLabel(Label lbl, Principal owner, Principal[] readers) {
        try {
            this.enterTiming();
            if (readers == null) {
                Label label = this.readerPolicyLabel(owner, Collections.emptySet());
                return label;
            }
            Label label = this.readerPolicyLabel(owner, Arrays.asList(readers));
            return label;
        }
        finally {
            this.exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Label readerPolicyLabel(Principal owner, PrincipalSet readers) {
        try {
            this.enterTiming();
            Label label = this.readerPolicyLabel(owner, PrincipalUtil.disjunction(readers.getSet()));
            return label;
        }
        finally {
            this.exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntegPolicy writerPolicy(Principal owner, Principal writer) {
        try {
            this.enterTiming();
            WriterPolicy writerPolicy = new WriterPolicy(this, owner, writer);
            return writerPolicy;
        }
        finally {
            this.exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntegPolicy writerPolicy(Principal owner, Collection<Principal> writers) {
        try {
            this.enterTiming();
            IntegPolicy integPolicy = this.writerPolicy(owner, PrincipalUtil.disjunction(writers));
            return integPolicy;
        }
        finally {
            this.exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Label writerPolicyLabel(Principal owner, Principal writer) {
        try {
            this.enterTiming();
            Label label = this.toLabel(this.writerPolicy(owner, writer));
            return label;
        }
        finally {
            this.exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Label writerPolicyLabel(Principal owner, Collection<Principal> writers) {
        try {
            this.enterTiming();
            Label label = this.toLabel(this.writerPolicy(owner, PrincipalUtil.disjunction(writers)));
            return label;
        }
        finally {
            this.exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Label writerPolicyLabel(Label lbl, Principal owner, Principal[] writers) {
        try {
            this.enterTiming();
            if (writers == null) {
                Label label = this.writerPolicyLabel(owner, Collections.emptySet());
                return label;
            }
            Label label = this.writerPolicyLabel(owner, Arrays.asList(writers));
            return label;
        }
        finally {
            this.exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntegPolicy writerPolicy(Label lbl, Principal owner, Principal[] writers) {
        try {
            this.enterTiming();
            if (writers == null) {
                IntegPolicy integPolicy = this.writerPolicy(owner, Collections.emptySet());
                return integPolicy;
            }
            IntegPolicy integPolicy = this.writerPolicy(owner, Arrays.asList(writers));
            return integPolicy;
        }
        finally {
            this.exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntegPolicy writerPolicy(Principal owner, PrincipalSet writers) {
        try {
            this.enterTiming();
            IntegPolicy integPolicy = this.writerPolicy(owner, writers.getSet());
            return integPolicy;
        }
        finally {
            this.exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Label toLabel(ConfPolicy cPolicy, IntegPolicy iPolicy) {
        try {
            this.enterTiming();
            if (cPolicy == null || iPolicy == null) {
                throw new NullPointerException();
            }
            PairLabel pairLabel = new PairLabel(this, cPolicy, iPolicy);
            return pairLabel;
        }
        finally {
            this.exitTiming();
        }
    }

    public Label toLabel(ConfPolicy policy) {
        try {
            this.enterTiming();
            PairLabel pairLabel = new PairLabel(this, policy, this.TOP_INTEG);
            return pairLabel;
        }
        finally {
            this.exitTiming();
        }
    }

    public Label toLabel(IntegPolicy policy) {
        try {
            this.enterTiming();
            PairLabel pairLabel = new PairLabel(this, this.BOTTOM_CONF, policy);
            return pairLabel;
        }
        finally {
            this.exitTiming();
        }
    }

    public Label join(Label l1, Label l2) {
        return this.join(l1, l2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Label join(Label l1, Label l2, boolean simplify) {
        try {
            this.enterTiming();
            if (l1 == null) {
                Label label = l2;
                return label;
            }
            if (l2 == null) {
                Label label = l1;
                return label;
            }
            if (l1 instanceof PairLabel && l2 instanceof PairLabel) {
                Label result = null;
                Pair pair = new Pair(l1, l2);
                result = this.cacheLabelJoins.get(pair);
                if (result == null) {
                    PairLabel pl1 = (PairLabel)l1;
                    PairLabel pl2 = (PairLabel)l2;
                    HashSet<PrincipalUtil.DelegationPair> dependencies = new HashSet<PrincipalUtil.DelegationPair>();
                    result = new PairLabel(this, pl1.confPolicy().join(pl2.confPolicy(), dependencies), pl1.integPolicy().join(pl2.integPolicy(), dependencies));
                    for (PrincipalUtil.DelegationPair del : dependencies) {
                        Set<Pair> deps = this.cacheLabelJoinDependencies.get(del);
                        if (deps == null) {
                            deps = new HashSet<Pair>();
                            this.cacheLabelJoinDependencies.put(del, deps);
                        }
                        deps.add(pair);
                    }
                    this.cacheLabelJoins.put(pair, result);
                }
                Label label = result;
                return label;
            }
            Label label = null;
            return label;
        }
        finally {
            this.exitTiming();
        }
    }

    public Label meet(Label l1, Label l2) {
        return this.meet(l1, l2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Label meet(Label l1, Label l2, boolean simplify) {
        try {
            this.enterTiming();
            if (l1 == null) {
                Label label = l2;
                return label;
            }
            if (l2 == null) {
                Label label = l1;
                return label;
            }
            if (l1 instanceof PairLabel && l2 instanceof PairLabel) {
                Label result = null;
                Pair pair = new Pair(l1, l2);
                result = this.cacheLabelMeets.get(pair);
                if (result == null) {
                    PairLabel pl1 = (PairLabel)l1;
                    PairLabel pl2 = (PairLabel)l2;
                    HashSet<PrincipalUtil.DelegationPair> dependencies = new HashSet<PrincipalUtil.DelegationPair>();
                    result = new PairLabel(this, pl1.confPolicy().meet(pl2.confPolicy(), dependencies), pl1.integPolicy().meet(pl2.integPolicy(), dependencies));
                    for (PrincipalUtil.DelegationPair del : dependencies) {
                        Set<Pair> deps = this.cacheLabelMeetDependencies.get(del);
                        if (deps == null) {
                            deps = new HashSet<Pair>();
                            this.cacheLabelMeetDependencies.put(del, deps);
                        }
                        deps.add(pair);
                    }
                    this.cacheLabelMeets.put(pair, result);
                }
                Label label = result;
                return label;
            }
            Label label = null;
            return label;
        }
        finally {
            this.exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfPolicy join(ConfPolicy p1, ConfPolicy p2, boolean simplify) {
        try {
            this.enterTiming();
            ConfPolicy confPolicy = this.join(p1, p2, new HashSet<PrincipalUtil.DelegationPair>(), simplify);
            return confPolicy;
        }
        finally {
            this.exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConfPolicy join(ConfPolicy p1, ConfPolicy p2, Set<PrincipalUtil.DelegationPair> s, boolean simplify) {
        try {
            this.enterTiming();
            Set<Policy> comps = new LinkedHashSet<Policy>();
            if (p1 instanceof JoinConfPolicy) {
                comps.addAll(((JoinConfPolicy)p1).joinComponents());
            } else {
                comps.add(p1);
            }
            if (p2 instanceof JoinConfPolicy) {
                comps.addAll(((JoinConfPolicy)p2).joinComponents());
            } else {
                comps.add(p2);
            }
            comps = this.simplifyJoin(comps, s);
            if (comps.size() == 1) {
                ConfPolicy confPolicy = (ConfPolicy)comps.iterator().next();
                return confPolicy;
            }
            JoinConfPolicy joinConfPolicy = new JoinConfPolicy(this, comps);
            return joinConfPolicy;
        }
        finally {
            this.exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntegPolicy join(IntegPolicy p1, IntegPolicy p2, boolean simplify) {
        try {
            this.enterTiming();
            IntegPolicy integPolicy = this.join(p1, p2, new HashSet<PrincipalUtil.DelegationPair>(), simplify);
            return integPolicy;
        }
        finally {
            this.exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IntegPolicy join(IntegPolicy p1, IntegPolicy p2, Set<PrincipalUtil.DelegationPair> s, boolean simplify) {
        try {
            this.enterTiming();
            Set<Policy> comps = new LinkedHashSet<Policy>();
            if (p1 instanceof JoinIntegPolicy) {
                comps.addAll(((JoinIntegPolicy)p1).joinComponents());
            } else {
                comps.add(p1);
            }
            if (p2 instanceof JoinIntegPolicy) {
                comps.addAll(((JoinIntegPolicy)p2).joinComponents());
            } else {
                comps.add(p2);
            }
            comps = this.simplifyJoin(comps, s);
            if (comps.size() == 1) {
                IntegPolicy integPolicy = (IntegPolicy)comps.iterator().next();
                return integPolicy;
            }
            JoinIntegPolicy joinIntegPolicy = new JoinIntegPolicy(this, comps);
            return joinIntegPolicy;
        }
        finally {
            this.exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfPolicy meet(ConfPolicy p1, ConfPolicy p2, boolean simplify) {
        try {
            this.enterTiming();
            ConfPolicy confPolicy = this.meet(p1, p2, new HashSet<PrincipalUtil.DelegationPair>(), simplify);
            return confPolicy;
        }
        finally {
            this.exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConfPolicy meet(ConfPolicy p1, ConfPolicy p2, Set<PrincipalUtil.DelegationPair> s, boolean simplify) {
        try {
            this.enterTiming();
            Set<Policy> comps = new LinkedHashSet<Policy>();
            if (p1 instanceof MeetConfPolicy) {
                comps.addAll(((MeetConfPolicy)p1).meetComponents());
            } else {
                comps.add(p1);
            }
            if (p2 instanceof MeetConfPolicy) {
                comps.addAll(((MeetConfPolicy)p2).meetComponents());
            } else {
                comps.add(p2);
            }
            comps = this.simplifyMeet(comps, s);
            if (comps.size() == 1) {
                ConfPolicy confPolicy = (ConfPolicy)comps.iterator().next();
                return confPolicy;
            }
            MeetConfPolicy meetConfPolicy = new MeetConfPolicy(this, comps);
            return meetConfPolicy;
        }
        finally {
            this.exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntegPolicy meet(IntegPolicy p1, IntegPolicy p2, boolean simplify) {
        try {
            this.enterTiming();
            IntegPolicy integPolicy = this.meet(p1, p2, new HashSet<PrincipalUtil.DelegationPair>(), simplify);
            return integPolicy;
        }
        finally {
            this.exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IntegPolicy meet(IntegPolicy p1, IntegPolicy p2, Set<PrincipalUtil.DelegationPair> s, boolean simplify) {
        try {
            this.enterTiming();
            Set<Policy> comps = new LinkedHashSet<Policy>();
            if (p1 instanceof MeetIntegPolicy) {
                comps.addAll(((MeetIntegPolicy)p1).meetComponents());
            } else {
                comps.add(p1);
            }
            if (p2 instanceof MeetIntegPolicy) {
                comps.addAll(((MeetIntegPolicy)p2).meetComponents());
            } else {
                comps.add(p2);
            }
            comps = this.simplifyMeet(comps, s);
            if (comps.size() == 1) {
                IntegPolicy integPolicy = (IntegPolicy)comps.iterator().next();
                return integPolicy;
            }
            MeetIntegPolicy meetIntegPolicy = new MeetIntegPolicy(this, comps);
            return meetIntegPolicy;
        }
        finally {
            this.exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equivalentTo(Label l1, Label l2) {
        try {
            this.enterTiming();
            if (l1 == l2 || l1 != null && l1.equals(l2)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.relabelsTo(l1, l2) && this.relabelsTo(l2, l1);
            return bl;
        }
        finally {
            this.exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReadableBy(Label lbl, Principal p) {
        try {
            this.enterTiming();
            Label L = this.toLabel(PrincipalUtil.readableByPrinPolicy(p));
            boolean bl = this.relabelsTo(lbl, L);
            return bl;
        }
        finally {
            this.exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWritableBy(Label lbl, Principal p) {
        try {
            this.enterTiming();
            Label L = this.toLabel(PrincipalUtil.writableByPrinPolicy(p));
            boolean bl = this.relabelsTo(L, lbl);
            return bl;
        }
        finally {
            this.exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean relabelsTo(Label from, Label to) {
        try {
            boolean result;
            this.enterTiming();
            if (from == null || to == null) {
                boolean bl = false;
                return bl;
            }
            if (from == to || from.equals(to)) {
                boolean bl = true;
                return bl;
            }
            Pair pair = new Pair(from, to);
            if (this.cacheTrueLabelRelabels.containsKey(pair)) {
                boolean bl = true;
                return bl;
            }
            if (this.cacheFalseLabelRelabels.containsKey(pair)) {
                boolean bl = false;
                return bl;
            }
            HashSet<PrincipalUtil.DelegationPair> dependencies = new HashSet<PrincipalUtil.DelegationPair>();
            boolean bl = result = from != null && from.relabelsTo(to, dependencies);
            if (!result) {
                this.cacheFalseLabelRelabels.put(pair, pair);
            } else {
                this.cacheTrueLabelRelabels.put(pair, pair);
                for (PrincipalUtil.DelegationPair del : dependencies) {
                    Set<Pair> deps = this.cacheTrueLabelRelabelsDependencies.get(del);
                    if (deps == null) {
                        deps = new HashSet<Pair>();
                        this.cacheTrueLabelRelabelsDependencies.put(del, deps);
                    }
                    deps.add(pair);
                }
            }
            boolean bl2 = result;
            return bl2;
        }
        finally {
            this.exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acts_for(Label actor, Principal granter) {
        try {
            this.enterTiming();
            boolean bl = this.actsFor(actor, granter);
            return bl;
        }
        finally {
            this.exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean actsFor(Label actor, Principal granter) {
        try {
            this.enterTiming();
            Label L = this.toLabel(this.TOP_CONF, this.writerPolicy(granter, granter));
            boolean bl = this.relabelsTo(actor, L);
            return bl;
        }
        finally {
            this.exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean relabelsTo(Policy from, Policy to) {
        try {
            this.enterTiming();
            boolean bl = this.relabelsTo(from, to, new HashSet<PrincipalUtil.DelegationPair>());
            return bl;
        }
        finally {
            this.exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean relabelsTo(Policy from, Policy to, Set<PrincipalUtil.DelegationPair> s) {
        try {
            this.enterTiming();
            if (from == null || to == null) {
                boolean bl = false;
                return bl;
            }
            if (from == to || from.equals(to)) {
                boolean bl = true;
                return bl;
            }
            Pair pair = new Pair(from, to);
            if (this.cacheTruePolicyRelabels.containsKey(pair)) {
                s.addAll((Collection<PrincipalUtil.DelegationPair>)this.cacheTruePolicyRelabels.get(pair));
                boolean bl = true;
                return bl;
            }
            if (this.cacheFalsePolicyRelabels.containsKey(pair)) {
                boolean bl = false;
                return bl;
            }
            HashSet<PrincipalUtil.DelegationPair> dependencies = new HashSet<PrincipalUtil.DelegationPair>();
            boolean result = from.relabelsTo(to, dependencies);
            if (!result) {
                this.cacheFalsePolicyRelabels.put(pair, pair);
            } else {
                this.cacheTruePolicyRelabels.put(pair, dependencies);
                for (PrincipalUtil.DelegationPair del : dependencies) {
                    Set<Pair> deps = this.cacheTruePolicyRelabelsDependencies.get(del);
                    if (deps == null) {
                        deps = new HashSet<Pair>();
                        this.cacheTruePolicyRelabelsDependencies.put(del, deps);
                    }
                    deps.add(pair);
                }
                s.addAll(dependencies);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.exitTiming();
        }
    }

    public String stringValue(Label lb) {
        try {
            this.enterTiming();
            if (lb == null) {
                String string = "<null>";
                return string;
            }
            String string = lb.toString();
            return string;
        }
        finally {
            this.exitTiming();
        }
    }

    public String toString(Label lb) {
        try {
            this.enterTiming();
            String string = this.stringValue(lb);
            return string;
        }
        finally {
            this.exitTiming();
        }
    }

    public int hashCode(Label lb) {
        try {
            this.enterTiming();
            if (lb == null) {
                int n = 0;
                return n;
            }
            int n = lb.hashCode();
            return n;
        }
        finally {
            this.exitTiming();
        }
    }

    private Set<Policy> simplifyJoin(Set<Policy> policies, Set<PrincipalUtil.DelegationPair> dependencies) {
        LinkedHashSet<Policy> needed = new LinkedHashSet<Policy>();
        for (Policy ci : policies) {
            boolean subsumed = ci == null;
            Iterator j = needed.iterator();
            while (!subsumed && j.hasNext()) {
                Policy cj = (Policy)j.next();
                if (this.relabelsTo(ci, cj, dependencies)) {
                    subsumed = true;
                    break;
                }
                if (!this.relabelsTo(cj, ci, dependencies)) continue;
                j.remove();
            }
            if (subsumed) continue;
            needed.add(ci);
        }
        return needed;
    }

    private Set<Policy> simplifyMeet(Set<Policy> policies, Set<PrincipalUtil.DelegationPair> dependencies) {
        LinkedHashSet<Policy> needed = new LinkedHashSet<Policy>();
        for (Policy ci : policies) {
            boolean subsumed = ci == null;
            Iterator j = needed.iterator();
            while (!subsumed && j.hasNext()) {
                Policy cj = (Policy)j.next();
                if (this.relabelsTo(cj, ci, dependencies)) {
                    subsumed = true;
                    break;
                }
                if (!this.relabelsTo(ci, cj, dependencies)) continue;
                j.remove();
            }
            if (subsumed) continue;
            needed.add(ci);
        }
        return needed;
    }

    void notifyNewDelegation(Principal granter, Principal superior) {
        try {
            this.enterTiming();
            this.cacheFalseLabelRelabels.clear();
            this.cacheFalsePolicyRelabels.clear();
            this.cacheLabelJoins.clear();
            this.cacheLabelMeets.clear();
            this.cacheLabelJoinDependencies.clear();
            this.cacheLabelMeetDependencies.clear();
        }
        finally {
            this.exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyRevokeDelegation(Principal granter, Principal superior) {
        try {
            this.enterTiming();
            PrincipalUtil.DelegationPair del = new PrincipalUtil.DelegationPair(superior, granter);
            Set<Pair> deps = this.cacheTrueLabelRelabelsDependencies.remove(del);
            if (deps != null) {
                for (Pair afp : deps) {
                    this.cacheTrueLabelRelabels.remove(afp);
                }
            }
            if ((deps = this.cacheTruePolicyRelabelsDependencies.remove(del)) != null) {
                for (Pair afp : deps) {
                    this.cacheTruePolicyRelabels.remove(afp);
                }
            }
            if ((deps = this.cacheLabelJoinDependencies.remove(del)) != null) {
                for (Pair afp : deps) {
                    this.cacheLabelJoins.remove(afp);
                }
            }
            if ((deps = this.cacheLabelMeetDependencies.remove(del)) != null) {
                for (Pair afp : deps) {
                    this.cacheLabelMeets.remove(afp);
                }
            }
        }
        finally {
            this.exitTiming();
        }
    }

    private class Pair {
        final Object left;
        final Object right;

        public Pair(Object left, Object right) {
            this.left = left;
            this.right = right;
        }

        public int hashCode() {
            return this.left.hashCode() ^ this.right.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof Pair) {
                Pair that = (Pair)o;
                return !(this.left != that.left && !this.left.equals(that.left) || this.right != that.right && !this.right.equals(that.right));
            }
            return false;
        }

        public String toString() {
            return this.left + "-" + this.right;
        }
    }

    private static class Stats {
        private long totalTime = 0L;
        private long enterStartTime = 0L;
        private int callStackCount = 0;
        private int callCount = 0;
        private int topCallCount = 0;

        private Stats() {
        }
    }
}

