/*
 * Decompiled with CFR 0.152.
 */
package jif.lang;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import jif.lang.AbstractPolicy;
import jif.lang.LabelUtil;
import jif.lang.MeetPolicy;
import jif.lang.Policy;
import jif.lang.PrincipalUtil;

public abstract class JoinPolicy
extends AbstractPolicy
implements Policy {
    private Set<Policy> components;

    JoinPolicy(LabelUtil labelUtil, Set<Policy> policies) {
        super(labelUtil);
        this.components = Collections.unmodifiableSet(policies);
    }

    public Set<Policy> joinComponents() {
        return this.components;
    }

    @Override
    public boolean relabelsTo(Policy pol, Set<PrincipalUtil.DelegationPair> s) {
        if (this == pol || this.equals(pol)) {
            return true;
        }
        HashSet<PrincipalUtil.DelegationPair> temp = new HashSet<PrincipalUtil.DelegationPair>();
        boolean sat = true;
        for (Policy Ci : this.components) {
            if (this.labelUtil.relabelsTo(Ci, pol, temp)) continue;
            sat = false;
            break;
        }
        if (sat) {
            s.addAll(temp);
            return true;
        }
        temp.clear();
        if (pol instanceof MeetPolicy) {
            MeetPolicy mp = (MeetPolicy)pol;
            sat = true;
            for (Policy Di : mp.meetComponents()) {
                if (this.labelUtil.relabelsTo(this, Di, temp)) continue;
                sat = false;
                break;
            }
            if (sat) {
                s.addAll(temp);
                return true;
            }
        }
        if (pol instanceof JoinPolicy) {
            JoinPolicy jp = (JoinPolicy)pol;
            for (Policy Di : jp.joinComponents()) {
                temp.clear();
                if (!this.labelUtil.relabelsTo(this, Di, temp)) continue;
                s.addAll(temp);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof JoinPolicy) {
            JoinPolicy that = (JoinPolicy)o;
            return this == that || this.joinComponents().equals(that.joinComponents());
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return this.components.hashCode();
    }

    public final String toString() {
        String str = "";
        Iterator<Policy> iter = this.components.iterator();
        while (iter.hasNext()) {
            str = str + iter.next().toString();
            if (!iter.hasNext()) continue;
            str = str + "; ";
        }
        return str;
    }
}

