/*
 * Decompiled with CFR 0.152.
 */
package jif.lang;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import jif.lang.ActsForProof;
import jif.lang.Closure;
import jif.lang.DelegatesProof;
import jif.lang.FromDisjunctProof;
import jif.lang.Label;
import jif.lang.Principal;
import jif.lang.PrincipalUtil;
import jif.lang.TransitiveProof;

public final class DisjunctivePrincipal
implements Principal {
    final Set<Principal> disjuncts;
    private Integer hashCode = null;

    DisjunctivePrincipal(Set<Principal> disjuncts) {
        this.disjuncts = disjuncts;
    }

    @Override
    public String name() {
        StringBuffer sb = new StringBuffer();
        Iterator<Principal> iter = this.disjuncts.iterator();
        while (iter.hasNext()) {
            Principal p = iter.next();
            sb.append(PrincipalUtil.toString(p));
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    @Override
    public boolean delegatesTo(Principal p) {
        if (p instanceof DisjunctivePrincipal) {
            DisjunctivePrincipal dp = (DisjunctivePrincipal)p;
            return this.disjuncts.containsAll(dp.disjuncts);
        }
        for (Principal q : this.disjuncts) {
            if (!PrincipalUtil.equals(q, p)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = new Integer(this.disjuncts.hashCode());
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Principal p) {
        if (p instanceof DisjunctivePrincipal) {
            DisjunctivePrincipal that = (DisjunctivePrincipal)p;
            return this.hashCode() == that.hashCode() && this.disjuncts.equals(that.disjuncts) && that.disjuncts.equals(this.disjuncts);
        }
        return false;
    }

    @Override
    public boolean isAuthorized(Object authPrf, Closure closure, Label lb, boolean executeNow) {
        for (Principal p : this.disjuncts) {
            if (!p.isAuthorized(authPrf, closure, lb, executeNow)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ActsForProof findProofUpto(Principal p, Object searchState) {
        if (this.delegatesTo(p)) {
            return new DelegatesProof(p, this);
        }
        for (Principal witness : this.disjuncts) {
            ActsForProof prf = PrincipalUtil.findActsForProof(p, witness, searchState);
            if (prf == null) continue;
            DelegatesProof step = new DelegatesProof(witness, this);
            return new TransitiveProof(prf, witness, step);
        }
        return null;
    }

    @Override
    public ActsForProof findProofDownto(Principal q, Object searchState) {
        HashMap<Principal, ActsForProof> proofs = new HashMap<Principal, ActsForProof>();
        for (Principal p : this.disjuncts) {
            ActsForProof prf = PrincipalUtil.findActsForProof(p, q, searchState);
            if (prf == null) {
                return null;
            }
            proofs.put(p, prf);
        }
        return new FromDisjunctProof(this, q, proofs);
    }
}

