/*
 * Decompiled with CFR 0.152.
 */
package jif.lang;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jif.lang.ActsForProof;
import jif.lang.Closure;
import jif.lang.DelegatesProof;
import jif.lang.Label;
import jif.lang.Principal;
import jif.lang.PrincipalUtil;
import jif.lang.TransitiveProof;

public abstract class AbstractPrincipal
implements Principal {
    private String name;
    private static Principal NULL_PRINCIPAL = new AbstractPrincipal("NULL PRINCIPAL"){

        @Override
        public boolean equals(Object o) {
            return this == o;
        }
    };
    private Map<Principal, Principal> superiors = new ConcurrentHashMap<Principal, Principal>();

    public AbstractPrincipal() {
    }

    private void jif$init() {
    }

    protected AbstractPrincipal jif$lang$AbstractPrincipal$(String name) {
        this.jif$init();
        this.name = name;
        return this;
    }

    protected AbstractPrincipal jif$lang$AbstractPrincipal$(String name, Principal superior) {
        this.jif$init();
        this.name = name;
        this.addDelegatesTo(superior);
        return this;
    }

    protected AbstractPrincipal(String name) {
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean delegatesTo(Principal p) {
        return this.superiorsContains(p);
    }

    public void addDelegatesTo(Principal p) {
        if (p == null) {
            p = NULL_PRINCIPAL;
        }
        if (this.superiors.put(p, this) == null) {
            PrincipalUtil.notifyNewDelegation(this, p);
        }
    }

    public void removeDelegatesTo(Principal p) {
        if (p == null) {
            p = NULL_PRINCIPAL;
        }
        if (this.superiors.remove(p) != null) {
            PrincipalUtil.notifyRevokeDelegation(this, p);
        }
    }

    protected boolean superiorsContains(Principal p) {
        if (p == null) {
            p = NULL_PRINCIPAL;
        }
        return this.superiors.containsKey(p);
    }

    @Override
    public boolean isAuthorized(Object authPrf, Closure closure, Label lb, boolean executeNow) {
        return false;
    }

    @Override
    public ActsForProof findProofDownto(Principal q, Object searchState) {
        return null;
    }

    @Override
    public ActsForProof findProofUpto(Principal p, Object searchState) {
        for (Principal s : this.superiors.keySet()) {
            ActsForProof prf = PrincipalUtil.findActsForProof(p, s, searchState);
            if (prf == null || !PrincipalUtil.actsFor(s, this)) continue;
            return new TransitiveProof(prf, s, new DelegatesProof(s, this));
        }
        return null;
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Principal) {
            Principal p = (Principal)o;
            return (this.name == p.name() || this.name != null && this.name.equals(p.name())) && this.getClass() == p.getClass();
        }
        return false;
    }

    @Override
    public boolean equals(Principal p) {
        if (p == null) {
            return false;
        }
        return (this.name == p.name() || this.name != null && this.name.equals(p.name())) && this.getClass() == p.getClass();
    }
}

