/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.tools.JavaFileObject;
import polyglot.ast.Import;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.PackageNode;
import polyglot.ast.SourceCollection;
import polyglot.ast.SourceFile;
import polyglot.ast.TopLevelDecl;
import polyglot.frontend.Job;
import polyglot.frontend.TargetFactory;
import polyglot.types.Context;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Copy;
import polyglot.util.InternalCompilerError;
import polyglot.visit.PrettyPrinter;

public class Translator
extends PrettyPrinter
implements Copy<Translator> {
    protected Job job;
    protected NodeFactory nf;
    protected TargetFactory tf;
    protected TypeSystem ts;
    protected Context context;

    public Translator(Job job, TypeSystem ts, NodeFactory nf, TargetFactory tf) {
        super(nf.lang());
        this.job = job;
        this.nf = nf;
        this.tf = tf;
        this.ts = ts;
        this.context = ts.createContext();
    }

    public Job job() {
        return this.job;
    }

    @Override
    public Translator copy() {
        try {
            return (Translator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalCompilerError("Java clone() weirdness.");
        }
    }

    public TypeSystem typeSystem() {
        return this.ts;
    }

    public NodeFactory nodeFactory() {
        return this.nf;
    }

    public Context context() {
        return this.context;
    }

    public Translator context(Context c) {
        if (c == this.context) {
            return this;
        }
        Translator tr = this.copy();
        tr.context = c;
        return tr;
    }

    @Override
    public void print(Node parent, Node child, CodeWriter w) {
        Translator tr = this;
        if (this.context != null) {
            if (child.isDisambiguated() && child.isTypeChecked()) {
                if (parent == null) {
                    Context c = this.lang().enterScope(child, this.context);
                    tr = this.context(c);
                } else if (parent.isDisambiguated() && parent.isTypeChecked()) {
                    Context c = this.lang().enterChildScope(parent, child, this.context);
                    tr = this.context(c);
                } else {
                    tr = this.context(null);
                }
            } else {
                tr = this.context(null);
            }
        }
        this.lang().translate(child, w, tr);
        if (this.context != null && child.isDisambiguated() && child.isTypeChecked()) {
            this.lang().addDecls(child, this.context);
        }
    }

    public boolean translate(Node ast) {
        if (ast instanceof SourceFile) {
            SourceFile sfn = (SourceFile)ast;
            return this.translateSource(sfn);
        }
        if (ast instanceof SourceCollection) {
            SourceCollection sc = (SourceCollection)ast;
            boolean okay = true;
            for (SourceFile sfn : sc.sources()) {
                okay &= this.translateSource(sfn);
            }
            return okay;
        }
        throw new InternalCompilerError("AST root must be a SourceFile; found a " + ast.getClass().getName());
    }

    protected boolean translateSource(SourceFile sf) {
        TargetFactory tf = this.tf;
        int outputWidth = this.job.compiler().outputWidth();
        Collection<JavaFileObject> outputFiles = this.job.compiler().outputFiles();
        PackageNode pkgNode = sf.package_();
        String pkg = pkgNode != null ? pkgNode.package_().fullName() : "";
        for (Map.Entry<String, List<TopLevelDecl>> fileEntry : this.filenames(sf).entrySet()) {
            String filename = fileEntry.getKey();
            List<TopLevelDecl> decls = fileEntry.getValue();
            JavaFileObject of = filename == null ? tf.outputFileObject(pkg, sf.source()) : tf.outputFileObject(pkg, filename, sf.source());
            String opfPath = of.getName();
            if (!opfPath.endsWith("$")) {
                outputFiles.add(of);
            }
            try {
                CodeWriter w = tf.outputCodeWriter(of, outputWidth);
                Throwable throwable = null;
                try {
                    this.writeHeader(sf, w);
                    Iterator<TopLevelDecl> i = decls.iterator();
                    while (i.hasNext()) {
                        TopLevelDecl decl = i.next();
                        this.translateTopLevelDecl(w, sf, decl);
                        if (!i.hasNext()) continue;
                        w.newline(0);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (w == null) continue;
                    if (throwable != null) {
                        try {
                            w.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    w.close();
                }
            }
            catch (IOException e) {
                this.job.compiler().errorQueue().enqueue(2, "I/O error while translating: " + e.getMessage());
                return false;
            }
        }
        return true;
    }

    protected void translateTopLevelDecl(CodeWriter w, SourceFile source, TopLevelDecl decl) {
        Translator tr;
        if (source.isDisambiguated() && source.isTypeChecked()) {
            Context c = this.lang().enterScope(source, this.context);
            tr = this.context(c);
        } else {
            tr = this.context(null);
        }
        this.lang().translate(decl, w, tr);
    }

    protected void writeHeader(SourceFile sfn, CodeWriter w) {
        if (sfn.package_() != null) {
            w.write("package ");
            this.lang().translate(sfn.package_(), w, this);
            w.write(";");
            w.newline(0);
            w.newline(0);
        }
        boolean newline = false;
        for (Import imp : sfn.imports()) {
            this.lang().translate(imp, w, this);
            newline = true;
        }
        if (newline) {
            w.newline(0);
        }
    }

    protected Map<String, List<TopLevelDecl>> filenames(SourceFile sf) {
        LinkedHashMap<String, List<TopLevelDecl>> filenameMap = new LinkedHashMap<String, List<TopLevelDecl>>();
        LinkedList<TopLevelDecl> files = new LinkedList<TopLevelDecl>();
        for (TopLevelDecl decl : sf.decls()) {
            files.add(decl);
            if (!decl.flags().isPublic()) continue;
            if (!filenameMap.isEmpty()) {
                files = new LinkedList();
            }
            filenameMap.put(decl.name(), files);
        }
        if (filenameMap.isEmpty()) {
            filenameMap.put(null, files);
        }
        return filenameMap;
    }

    public String toString() {
        return "Translator";
    }
}

