/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Random;
import polyglot.ast.Block;
import polyglot.ast.Catch;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassMember;
import polyglot.ast.Expr;
import polyglot.ast.Formal;
import polyglot.ast.Import;
import polyglot.ast.JLang;
import polyglot.ast.LocalDecl;
import polyglot.ast.Node;
import polyglot.ast.SourceFile;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.frontend.Compiler;
import polyglot.util.CodeWriter;
import polyglot.visit.NodeVisitor;

public class NodeScrambler
extends NodeVisitor {
    public FirstPass fp;
    protected HashMap<Node, LinkedList<Node>> pairs;
    protected LinkedList<Node> nodes;
    protected LinkedList<Node> currentParents;
    protected long seed;
    protected Random ran;
    protected boolean scrambled = false;
    protected CodeWriter cw;

    public NodeScrambler(JLang lang) {
        this(lang, new Random().nextLong());
    }

    public NodeScrambler(JLang lang, long seed) {
        super(lang);
        this.fp = new FirstPass(lang);
        this.pairs = new HashMap();
        this.nodes = new LinkedList();
        this.currentParents = new LinkedList();
        this.cw = Compiler.createCodeWriter(System.err, 72);
        this.seed = seed;
        this.ran = new Random(seed);
    }

    public long getSeed() {
        return this.seed;
    }

    @Override
    public Node override(Node n) {
        if (this.coinFlip()) {
            Node m = this.potentialScramble(n);
            if (m == null) {
                return null;
            }
            this.scrambled = true;
            try {
                System.err.println("Replacing:");
                this.lang().dump(n, this.lang(), System.err);
                System.err.println("With:");
                this.lang().dump(n, this.lang(), System.err);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            return m;
        }
        return null;
    }

    protected boolean coinFlip() {
        if (this.scrambled) {
            return false;
        }
        return this.ran.nextDouble() > 0.9;
    }

    protected Node potentialScramble(Node n) {
        Class<Node> required = Node.class;
        if (n instanceof SourceFile) {
            return null;
        }
        if (n instanceof Import) {
            required = Import.class;
        } else if (n instanceof TypeNode) {
            required = TypeNode.class;
        } else if (n instanceof ClassDecl) {
            required = ClassDecl.class;
        } else if (n instanceof ClassMember) {
            required = ClassMember.class;
        } else if (n instanceof Formal) {
            required = Formal.class;
        } else if (n instanceof Expr) {
            required = Expr.class;
        } else if (n instanceof Block) {
            required = Block.class;
        } else if (n instanceof Catch) {
            required = Catch.class;
        } else if (n instanceof LocalDecl) {
            required = LocalDecl.class;
        } else if (n instanceof Stmt) {
            required = Stmt.class;
        }
        LinkedList<Node> parents = this.pairs.get(n);
        for (Node m : this.nodes) {
            if (!required.isAssignableFrom(m.getClass())) continue;
            boolean isParent = false;
            for (Node m2 : parents) {
                if (m != m2) continue;
                isParent = true;
            }
            if (isParent || m == n) continue;
            return m;
        }
        return null;
    }

    public class FirstPass
    extends NodeVisitor {
        public FirstPass(JLang lang) {
            super(lang);
        }

        @Override
        public NodeVisitor enter(Node n) {
            LinkedList<Node> clone = new LinkedList<Node>(NodeScrambler.this.currentParents);
            NodeScrambler.this.pairs.put(n, clone);
            NodeScrambler.this.nodes.add(n);
            NodeScrambler.this.currentParents.add(n);
            return this;
        }

        @Override
        public Node leave(Node old, Node n, NodeVisitor v) {
            NodeScrambler.this.currentParents.remove(n);
            return n;
        }
    }
}

