/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import polyglot.ast.Assign;
import polyglot.ast.Block;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassMember;
import polyglot.ast.ConstructorCall;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.Field;
import polyglot.ast.FieldAssign;
import polyglot.ast.FieldDecl;
import polyglot.ast.Formal;
import polyglot.ast.Id;
import polyglot.ast.Lang;
import polyglot.ast.Local;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Receiver;
import polyglot.ast.Special;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.frontend.Job;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.LocalInstance;
import polyglot.types.ParsedClassType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.Position;
import polyglot.visit.InnerClassAbstractRemover;
import polyglot.visit.NodeVisitor;

public class InnerClassRewriter
extends InnerClassAbstractRemover {
    public InnerClassRewriter(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
    }

    FieldInstance localToField(ParsedClassType ct, ClassType outer) {
        FieldInstance fi = this.ts.fieldInstance(Position.compilerGenerated(), ct, Flags.FINAL.Protected(), outer, this.mangleClassName(outer));
        return fi;
    }

    FieldDecl createFieldDecl(FieldInstance fi) {
        Id id = this.nf.Id(Position.compilerGenerated(), fi.name());
        FieldDecl fd = this.nf.FieldDecl(fi.position(), fi.flags(), (TypeNode)this.nf.CanonicalTypeNode(fi.position(), fi.type()), id);
        fd = fd.fieldInstance(fi);
        return fd;
    }

    void addEnvToCI(ConstructorInstance ci, List<ClassType> env) {
        ArrayList<? extends Type> formals = new ArrayList<Type>(ci.formalTypes());
        formals.addAll(this.envAsFormalTypes(env));
        ci.setFormalTypes(formals);
    }

    ConstructorDecl translateConstructorDecl(ParsedClassType ct, ConstructorDecl cd, Map<ClassType, FieldInstance> m) {
        Object s;
        List<ClassType> env = this.env(ct, true);
        this.addEnvToCI(cd.constructorInstance(), env);
        cd = (ConstructorDecl)cd.name(ct.name());
        ArrayList<Formal> newFormals = new ArrayList<Formal>();
        newFormals.addAll(cd.formals());
        newFormals.addAll(this.envAsFormals(env));
        cd = (ConstructorDecl)cd.formals(newFormals);
        if (cd.body() == null) {
            return cd;
        }
        List<Stmt> oldStmts = cd.body().statements();
        ArrayList<Stmt> newStmts = new ArrayList<Stmt>();
        ConstructorCall cc = null;
        if (oldStmts.size() >= 1 && (s = oldStmts.get(0)) instanceof ConstructorCall) {
            cc = (ConstructorCall)s;
        }
        if (cc != null) {
            newStmts.add(cc);
        }
        if (cc == null || cc.kind() == ConstructorCall.SUPER) {
            for (Formal f : this.envAsFormals(env)) {
                LocalInstance li = f.localInstance();
                FieldInstance fi = m.get(li.type());
                if (fi == null) continue;
                Special this_ = this.nf.Special(Position.compilerGenerated(), Special.THIS);
                this_ = (Special)this_.type(ct);
                Id targetId = this.nf.Id(Position.compilerGenerated(), fi.name());
                Field target = this.nf.Field(Position.compilerGenerated(), (Receiver)this_, targetId);
                target = target.fieldInstance(fi);
                target = (Field)target.type(fi.type());
                Id sourceId = this.nf.Id(Position.compilerGenerated(), li.name());
                Local source = this.nf.Local(Position.compilerGenerated(), sourceId);
                source = source.localInstance(li);
                source = (Local)source.type(li.type());
                FieldAssign assign = this.nf.FieldAssign(Position.compilerGenerated(), target, Assign.ASSIGN, source);
                assign = (FieldAssign)assign.type(target.type());
                newStmts.add(this.nf.Eval(Position.compilerGenerated(), assign));
            }
        }
        if (cc != null) {
            for (int i = 1; i < oldStmts.size(); ++i) {
                newStmts.add(oldStmts.get(i));
            }
        } else {
            newStmts.addAll(oldStmts);
        }
        Block b = cd.body().statements(newStmts);
        cd = (ConstructorDecl)cd.body(b);
        return cd;
    }

    @Override
    protected Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        if (n instanceof ClassDecl) {
            ClassDecl cd = (ClassDecl)n;
            ParsedClassType ct = cd.type();
            List<ClassType> env = this.env(ct, true);
            if (!env.isEmpty()) {
                Context innerContext = this.lang().enterChildScope(cd, cd.body(), this.context);
                cd = cd.body(this.translateClassBody(ct, cd.body(), innerContext));
            }
            n = cd;
        }
        n = super.leaveCall(old, n, v);
        return n;
    }

    protected ClassBody translateClassBody(ParsedClassType ct, ClassBody body, Context context) {
        ArrayList<ClassMember> members = new ArrayList<ClassMember>();
        List<ClassType> env = this.env(ct, false);
        HashMap<ClassType, FieldInstance> fieldMap = new HashMap<ClassType, FieldInstance>();
        for (ClassType outer : env) {
            FieldInstance fi = this.localToField(ct, outer);
            fieldMap.put(outer, fi);
            ct.addField(fi);
            members.add(this.createFieldDecl(fi));
        }
        ArrayList<ConstructorDecl> ctors = new ArrayList<ConstructorDecl>();
        ArrayList<ClassMember> others = new ArrayList<ClassMember>();
        for (ClassMember cm : body.members()) {
            if (cm instanceof ConstructorDecl) {
                ctors.add((ConstructorDecl)cm);
                continue;
            }
            others.add(cm);
        }
        members.addAll(ctors);
        members.addAll(others);
        body = body.members(members);
        ClassBodyTranslator v = new ClassBodyTranslator(this.lang(), ct, fieldMap, context);
        v = (ClassBodyTranslator)v.begin();
        body = (ClassBody)body.visit(v);
        return body;
    }

    class ClassBodyTranslator
    extends NodeVisitor {
        ParsedClassType ct;
        Map<ClassType, FieldInstance> fieldMap;
        Context outerContext;

        ClassBodyTranslator(Lang lang, ParsedClassType ct, Map<ClassType, FieldInstance> fieldMap, Context context) {
            super(lang);
            this.ct = ct;
            this.fieldMap = fieldMap;
            this.outerContext = context;
        }

        @Override
        public Node leave(Node old, Node n, NodeVisitor v) {
            FieldInstance fi;
            Special s;
            if (n instanceof Special && (s = (Special)n).qualifier() != null && (fi = this.fieldMap.get(s.qualifier().type())) != null) {
                Special this_ = InnerClassRewriter.this.nf.Special(s.position(), Special.THIS);
                this_ = (Special)this_.type(this.ct);
                Id id = InnerClassRewriter.this.nf.Id(Position.compilerGenerated(), fi.name());
                Field f = InnerClassRewriter.this.nf.Field(s.position(), (Receiver)this_, id);
                f = f.fieldInstance(fi);
                f = (Field)f.type(fi.type());
                n = f;
            }
            if (n instanceof ConstructorDecl) {
                ConstructorDecl ctd = (ConstructorDecl)n;
                ClassType ct2 = (ClassType)ctd.constructorInstance().container();
                if (ct2.equals(this.ct)) {
                    ctd = InnerClassRewriter.this.translateConstructorDecl(this.ct, ctd, this.fieldMap);
                }
                n = ctd;
            }
            return super.leave(old, n, v);
        }
    }
}

