/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import polyglot.ast.Assign;
import polyglot.ast.Block;
import polyglot.ast.Call;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassMember;
import polyglot.ast.ConstructorCall;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.Eval;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.FieldDecl;
import polyglot.ast.Formal;
import polyglot.ast.Local;
import polyglot.ast.New;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.ProcedureCall;
import polyglot.ast.Receiver;
import polyglot.ast.SourceFile;
import polyglot.ast.Special;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.frontend.Job;
import polyglot.main.Report;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.LocalInstance;
import polyglot.types.ParsedClassType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;
import polyglot.visit.LocalClassRemover;
import polyglot.visit.NodeVisitor;

public class InnerClassRemover
extends ContextVisitor {
    private static final String OUTER_FIELD_NAME = "out$";
    Map<ParsedClassType, FieldInstance> outerFieldInstance = new HashMap<ParsedClassType, FieldInstance>();

    public InnerClassRemover(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
    }

    Expr getContainer(Position pos, Expr this_, ClassType currentClass, ClassType containerClass) {
        if (containerClass == currentClass) {
            return this_;
        }
        FieldInstance fi = this.boxThis(currentClass, currentClass.outer());
        Field f = this.nf.Field(pos, (Receiver)this_, this.nf.Id(pos, OUTER_FIELD_NAME));
        f = f.fieldInstance(fi);
        f = (Field)f.type(fi.type());
        f = f.targetImplicit(false);
        return this.getContainer(pos, f, currentClass.outer(), containerClass);
    }

    protected ContextVisitor localClassRemover() {
        LocalClassRemover lcv = new LocalClassRemover(this.job, this.ts, this.nf);
        return lcv;
    }

    @Override
    public Node override(Node parent, Node n) {
        if (n instanceof SourceFile) {
            ContextVisitor lcv = this.localClassRemover();
            lcv = (ContextVisitor)lcv.begin();
            lcv = lcv.context(this.context);
            if (Report.should_report("innerremover", 1)) {
                System.out.println(">>> output ----------------------");
                this.lang().prettyPrint(n, this.lang(), System.out);
                System.out.println("<<< output ----------------------");
            }
            n = n.visit(lcv);
            if (Report.should_report("innerremover", 1)) {
                System.out.println(">>> locals removed ----------------------");
                this.lang().prettyPrint(n, this.lang(), System.out);
                System.out.println("<<< locals removed ----------------------");
            }
            n = this.visitEdgeNoOverride(parent, n);
            if (Report.should_report("innerremover", 1)) {
                System.out.println(">>> inners removed ----------------------");
                this.lang().prettyPrint(n, this.lang(), System.out);
                System.out.println("<<< inners removed ----------------------");
            }
            return n;
        }
        return null;
    }

    @Override
    protected Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        Context context = this.context();
        Position pos = n.position();
        if (n instanceof Special) {
            Special s = (Special)n;
            if (s.qualifier() == null) {
                return s;
            }
            assert (s.qualifier().type().toClass() != null);
            if (s.qualifier().type().toClass().declaration() == context.currentClassScope()) {
                return s;
            }
            Expr ret = this.getContainer(pos, this.nf.This(pos).type(context.currentClass()), context.currentClass(), s.qualifier().type().toClass());
            return ret;
        }
        if (n instanceof New) {
            New neu = (New)n;
            Expr q = neu.qualifier();
            if (q != null) {
                ArrayList<Expr> args;
                neu = neu.qualifier(null);
                ConstructorInstance ci = (neu = neu.qualifierImplicit(true)).constructorInstance();
                if (ci != ci.declaration()) {
                    args = new ArrayList<Expr>();
                    args.add((Expr)((Object)ci.container()));
                    args.addAll(ci.formalTypes());
                    ci = ci.formalTypes(args);
                    neu = neu.constructorInstance(ci);
                }
                args = new ArrayList();
                args.add(q);
                args.addAll(neu.arguments());
                neu = neu.arguments(args);
            }
            return neu;
        }
        if (n instanceof ConstructorCall) {
            ArrayList<Expr> args;
            boolean fixCI;
            ConstructorCall cc = (ConstructorCall)n;
            if (cc.kind() != ConstructorCall.SUPER) {
                return cc;
            }
            ConstructorInstance ci = cc.constructorInstance();
            if (cc.qualifier() == null) {
                return cc;
            }
            Expr q = cc.qualifier();
            cc = cc.qualifier(null);
            ConstructorInstance cidecl = (ConstructorInstance)ci.declaration();
            boolean bl = fixCI = cc.arguments().size() + 1 != ci.formalTypes().size();
            if (ci != cidecl && fixCI) {
                args = new ArrayList();
                args.add((Expr)((Object)ci.container()));
                args.addAll(ci.formalTypes());
                ci = ci.formalTypes(args);
                cc = cc.constructorInstance(ci);
            }
            args = new ArrayList<Expr>();
            args.add(q);
            args.addAll(cc.arguments());
            cc = (ConstructorCall)cc.arguments(args);
            return cc;
        }
        if (n instanceof ClassDecl) {
            ClassDecl cd = (ClassDecl)n;
            if (cd.type().isMember() && !cd.type().flags().isStatic()) {
                cd.type().flags(cd.type().flags().Static());
                cd = cd.flags(cd.type().flags());
                ClassType ct = (ClassType)cd.type().container();
                FieldInstance fi = this.boxThis(cd.type(), ct);
                cd = InnerClassRemover.addFieldsToClass(cd, Collections.singletonList(fi), this.ts, this.nf, true);
                cd = this.fixQualifiers(cd);
            }
            return cd;
        }
        if (n instanceof Field) {
            Field f = (Field)n;
            if (f.isTargetImplicit() && f.target() instanceof Field) {
                f = f.targetImplicit(false);
            }
            return f;
        }
        if (n instanceof Call) {
            Call c = (Call)n;
            if (c.isTargetImplicit() && c.target() instanceof Field) {
                c = c.targetImplicit(false);
            }
            return c;
        }
        return n;
    }

    public ClassDecl fixQualifiers(ClassDecl cd) {
        return (ClassDecl)this.lang().visitChildren(cd, new NodeVisitor(this.lang()){
            LocalInstance li;

            @Override
            public Node override(Node parent, Node n) {
                if (n instanceof ClassBody) {
                    return null;
                }
                if (n instanceof ConstructorDecl) {
                    return null;
                }
                if (parent instanceof ConstructorDecl && n instanceof Formal) {
                    Formal f = (Formal)n;
                    LocalInstance li = f.localInstance();
                    if (li.name().equals(InnerClassRemover.OUTER_FIELD_NAME)) {
                        this.li = li;
                    }
                    return n;
                }
                if (parent instanceof ConstructorDecl && n instanceof Block) {
                    return null;
                }
                if (parent instanceof Block && n instanceof ConstructorCall) {
                    return null;
                }
                if (parent instanceof ConstructorCall) {
                    return null;
                }
                return n;
            }

            @Override
            public Node leave(Node parent, Node old, Node n, NodeVisitor v) {
                if (parent instanceof ConstructorCall && this.li != null && n instanceof Expr) {
                    return InnerClassRemover.this.fixQualifier((Expr)n, this.li);
                }
                return n;
            }
        });
    }

    public Expr fixQualifier(Expr e, final LocalInstance li) {
        return (Expr)e.visit(new NodeVisitor(this.lang()){

            @Override
            public Node leave(Node old, Node n, NodeVisitor v) {
                Special s;
                Field f;
                if (n instanceof Field && (f = (Field)n).target() instanceof Special && (s = (Special)f.target()).kind() == Special.THIS && f.name().equals(InnerClassRemover.OUTER_FIELD_NAME)) {
                    Local l = InnerClassRemover.this.nf.Local(n.position(), f.id());
                    l = l.localInstance(li);
                    l = (Local)l.type(li.type());
                    return l;
                }
                return n;
            }
        });
    }

    public static ClassDecl addFieldsToClass(ClassDecl cd, List<FieldInstance> newFields, TypeSystem ts, NodeFactory nf, boolean rewriteMembers) {
        if (newFields.isEmpty()) {
            return cd;
        }
        ClassBody b = cd.body();
        ArrayList<ClassMember> newMembers = new ArrayList<ClassMember>();
        for (FieldInstance fi : newFields) {
            Position pos = fi.position();
            FieldDecl fd = nf.FieldDecl(pos, fi.flags(), (TypeNode)nf.CanonicalTypeNode(pos, fi.type()), nf.Id(pos, fi.name()));
            fd = fd.fieldInstance(fi);
            newMembers.add(fd);
        }
        for (ClassMember m : b.members()) {
            if (m instanceof ConstructorDecl) {
                ConstructorDecl td = (ConstructorDecl)m;
                m = InnerClassRemover.rewriteConstructorDeclForNewFields(td, newFields, ts, nf);
            }
            newMembers.add(m);
        }
        b = b.members(newMembers);
        return cd.body(b);
    }

    private static ConstructorDecl rewriteConstructorDeclForNewFields(ConstructorDecl cd, List<FieldInstance> newFields, TypeSystem ts, NodeFactory nf) {
        Stmt s0;
        ArrayList<Formal> formals = new ArrayList<Formal>();
        ArrayList<LocalInstance> localInstances = new ArrayList<LocalInstance>();
        ArrayList<Local> localVars = new ArrayList<Local>();
        for (FieldInstance fi : newFields) {
            Position pos = fi.position();
            LocalInstance li = ts.localInstance(pos, Flags.FINAL, fi.type(), fi.name());
            li.setNotConstant();
            Formal formal = nf.Formal(pos, li.flags(), (TypeNode)nf.CanonicalTypeNode(pos, li.type()), nf.Id(pos, li.name()));
            formal = formal.localInstance(li);
            formals.add(formal);
            localInstances.add(li);
            Local l = nf.Local(pos, nf.Id(pos, li.name()));
            l = (Local)l.type(li.type());
            l = l.localInstance(li);
            localVars.add(l);
        }
        ArrayList<Formal> newFormals = new ArrayList<Formal>();
        newFormals.addAll(formals);
        newFormals.addAll(cd.formals());
        cd = (ConstructorDecl)cd.formals(newFormals);
        Block block = cd.body();
        ConstructorCall constructorCall = null;
        boolean performFieldAssignments = true;
        ArrayList<Stmt> remainingStatements = new ArrayList<Stmt>();
        if (block.statements().size() > 0 && (s0 = block.statements().get(0)) instanceof ConstructorCall) {
            remainingStatements.addAll(block.statements().subList(1, block.statements().size()));
            constructorCall = (ConstructorCall)s0;
            ConstructorInstance ci = constructorCall.constructorInstance();
            if (constructorCall.kind() == ConstructorCall.THIS) {
                ArrayList<Expr> arguments = new ArrayList<Expr>(localVars);
                if (ci != ci.declaration()) {
                    ArrayList<? extends Type> newFormalTypes = new ArrayList<Type>();
                    for (int j = 0; j < newFields.size(); ++j) {
                        FieldInstance fi = newFields.get(j);
                        newFormalTypes.add(fi.type());
                    }
                    newFormalTypes.addAll(ci.formalTypes());
                    ci.setFormalTypes(newFormalTypes);
                }
                arguments.addAll(constructorCall.arguments());
                constructorCall = (ConstructorCall)constructorCall.arguments(arguments);
                performFieldAssignments = false;
            }
        }
        ArrayList<Stmt> statements = new ArrayList<Stmt>();
        if (constructorCall != null) {
            statements.add(constructorCall);
        }
        if (performFieldAssignments) {
            for (int j = 0; j < newFields.size(); ++j) {
                FieldInstance fi = newFields.get(j);
                LocalInstance li = ((Formal)formals.get(j)).localInstance();
                Local l = (Local)localVars.get(j);
                Position pos = fi.position();
                Field f = nf.Field(pos, (Receiver)nf.This(pos).type(fi.container()), nf.Id(pos, fi.name()));
                f = (Field)f.type(fi.type());
                f = f.fieldInstance(fi);
                f = f.targetImplicit(false);
                Assign a = nf.FieldAssign(pos, f, Assign.ASSIGN, l);
                a = (Assign)a.type(li.type());
                Eval e = nf.Eval(pos, a);
                statements.add(e);
            }
        }
        statements.addAll(remainingStatements);
        block = block.statements(statements);
        cd = (ConstructorDecl)cd.body(block);
        ArrayList<Type> newFormalTypes = new ArrayList<Type>();
        for (Formal f : newFormals) {
            newFormalTypes.add(f.declType());
        }
        ConstructorInstance ci = cd.constructorInstance();
        assert (ci.declaration() == ci);
        ci.setFormalTypes(newFormalTypes);
        return cd;
    }

    List<Expr> addArgs(ProcedureCall n, ConstructorInstance nci, Expr q) {
        if (nci == null || q == null) {
            return n.arguments();
        }
        ArrayList<Expr> args = new ArrayList<Expr>();
        args.add(q);
        args.addAll(n.arguments());
        assert (args.size() == nci.formalTypes().size());
        return args;
    }

    private FieldInstance boxThis(ClassType currClass, ClassType outerClass) {
        FieldInstance fi = this.outerFieldInstance.get(currClass);
        if (fi != null) {
            return fi;
        }
        Position pos = outerClass.position();
        fi = this.ts.fieldInstance(pos, currClass, Flags.FINAL.Private(), outerClass, OUTER_FIELD_NAME);
        fi.setNotConstant();
        ParsedClassType currDecl = (ParsedClassType)currClass.declaration();
        currDecl.addField(fi);
        this.outerFieldInstance.put(currDecl, fi);
        return fi;
    }

    public static <K, V> V hashGet(Map<K, V> map, K k, V v) {
        return LocalClassRemover.hashGet(map, k, v);
    }
}

