/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import polyglot.ast.JLang;
import polyglot.ast.Node;
import polyglot.util.InternalCompilerError;
import polyglot.visit.NodeVisitor;

public class FindSharedASTVisitor
extends NodeVisitor {
    private Map<Node, NodeStack> seenNodes = new HashMap<Node, NodeStack>();
    private NodeStack currentStack;

    public FindSharedASTVisitor(JLang lang) {
        super(lang);
    }

    @Override
    public NodeVisitor enter(Node n) {
        this.currentStack = new NodeStack(n, this.currentStack);
        if (this.seenNodes.containsKey(n)) {
            this.alreadySeenNode(n, this.seenNodes.get(n), this.currentStack);
        } else {
            this.seenNodes.put(n, this.currentStack);
        }
        return this;
    }

    protected void alreadySeenNode(Node n, NodeStack stack1, NodeStack stack2) {
        Node m = this.findCommonParent(stack1, stack2);
        if (m != null) {
            this.lang().prettyPrint(m, this.lang(), System.err);
        }
        throw new InternalCompilerError("Already seen node " + n + " (" + n.getClass().getSimpleName() + ") at " + stack1 + " and at " + stack2, n.position());
    }

    protected Node findCommonParent(NodeStack stack1, NodeStack stack2) {
        ArrayList<Node> list1 = new ArrayList<Node>();
        while (stack1 != null) {
            list1.add(stack1.n);
            stack1 = stack1.rest;
        }
        ArrayList<Node> list2 = new ArrayList<Node>();
        while (stack2 != null) {
            list2.add(stack2.n);
            stack2 = stack2.rest;
        }
        int i = list1.size();
        int j = list2.size();
        while (i > 0 && j > 0) {
            if (list1.get(--i) == list2.get(--j)) continue;
            return (Node)list1.get(i + 1);
        }
        if (i > 0) {
            return (Node)list1.get(i - 1);
        }
        if (j > 0) {
            return (Node)list2.get(j - 1);
        }
        return null;
    }

    @Override
    public Node leave(Node old, Node n, NodeVisitor v) {
        if (this.currentStack != null) {
            this.currentStack = this.currentStack.rest;
        }
        return n;
    }

    public class NodeStack {
        final Node n;
        final NodeStack rest;

        NodeStack(Node n, NodeStack rest) {
            this.n = n;
            this.rest = rest;
        }

        NodeStack(Node n) {
            this.n = n;
            this.rest = null;
        }

        public String toString() {
            if (this.rest == null) {
                return "";
            }
            return this.rest.toString() + "\n :: " + this.n + "(" + this.n.position() + "; " + this.n.getClass().getSimpleName() + ")";
        }
    }
}

