/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import polyglot.ast.Binary;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassMember;
import polyglot.ast.CodeNode;
import polyglot.ast.Conditional;
import polyglot.ast.ConstructorCall;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.FieldAssign;
import polyglot.ast.FieldDecl;
import polyglot.ast.Formal;
import polyglot.ast.Initializer;
import polyglot.ast.Local;
import polyglot.ast.LocalAssign;
import polyglot.ast.LocalDecl;
import polyglot.ast.New;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Special;
import polyglot.ast.Term;
import polyglot.ast.Unary;
import polyglot.frontend.Job;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.FieldInstance;
import polyglot.types.LocalInstance;
import polyglot.types.ParsedClassType;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.types.VarInstance;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.CFGBuilder;
import polyglot.visit.DataFlow;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;

public class DefiniteAssignmentChecker
extends DataFlow<FlowItem> {
    protected ClassBodyInfo currCBI = null;
    protected static final FlowItem BOTTOM = new FlowItem(Collections.emptyMap());

    public DefiniteAssignmentChecker(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf, true, false);
    }

    @Override
    protected FlowGraph<FlowItem> initGraph(CodeNode code, Term root) {
        this.currCBI.currCodeDecl = code;
        return new FlowGraph<FlowItem>(root, this.forward);
    }

    @Override
    protected NodeVisitor enterCall(Node parent, Node n) throws SemanticException {
        if (n instanceof ClassBody) {
            ParsedClassType ct = null;
            if (parent instanceof ClassDecl) {
                ct = ((ClassDecl)parent).type();
            } else if (parent instanceof New) {
                ct = ((New)parent).anonType();
            }
            if (ct == null) {
                throw new InternalCompilerError("ClassBody found but cannot find the class.", n.position());
            }
            this.setupClassBody(ct, (ClassBody)n);
        }
        return super.enterCall(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        if (n instanceof ConstructorDecl) {
            this.currCBI.allConstructors.add((ConstructorDecl)n);
            return n;
        }
        if (n instanceof ClassBody) {
            try {
                for (ConstructorDecl cd : this.currCBI.allConstructors) {
                    this.dataflow(cd);
                }
                this.checkStaticFinalFieldsInit((ClassBody)n);
                this.checkNonStaticFinalFieldsInit((ClassBody)n);
                if (this.currCBI.outer != null) {
                    this.currCBI.outer.localsUsedInClassBodies.put((ClassBody)n, this.currCBI.outerLocalsUsed);
                }
            }
            finally {
                this.currCBI = this.currCBI.outer;
            }
        }
        return super.leaveCall(old, n, v);
    }

    protected void setupClassBody(ClassType ct, ClassBody n) throws SemanticException {
        ClassBodyInfo newCDI = new ClassBodyInfo();
        newCDI.outer = this.currCBI;
        newCDI.currClass = ct;
        this.currCBI = newCDI;
        for (ClassMember cm : n.members()) {
            AssignmentStatus assStatus;
            FieldDecl fd;
            if (!(cm instanceof FieldDecl) || !(fd = (FieldDecl)cm).flags().isFinal()) continue;
            if (fd.init() != null) {
                assStatus = AssignmentStatus.ASS;
                if (this.currCBI.outer != null) {
                    this.dataflow(fd.init());
                }
            } else {
                assStatus = AssignmentStatus.UNASS;
            }
            newCDI.currClassFinalFieldAssStatuses.put(fd.fieldInstance().orig(), assStatus);
        }
    }

    protected void checkStaticFinalFieldsInit(ClassBody cb) throws SemanticException {
        for (Map.Entry<FieldInstance, AssignmentStatus> e : this.currCBI.currClassFinalFieldAssStatuses.entrySet()) {
            FieldInstance fi = e.getKey();
            if (!fi.flags().isStatic() || !fi.flags().isFinal()) continue;
            AssignmentStatus defAss = e.getValue();
            if (defAss.definitelyAssigned) continue;
            throw new SemanticException("Final field \"" + fi.name() + "\" might not have been initialized", cb.position());
        }
    }

    protected void checkNonStaticFinalFieldsInit(ClassBody cb) throws SemanticException {
        for (FieldInstance fi : this.currCBI.currClassFinalFieldAssStatuses.keySet()) {
            if (!fi.flags().isFinal() || fi.flags().isStatic()) continue;
            boolean fieldInitializedBeforeConstructors = false;
            AssignmentStatus ic = this.currCBI.currClassFinalFieldAssStatuses.get(fi.orig());
            if (ic != null && ic.definitelyAssigned) {
                fieldInitializedBeforeConstructors = true;
            }
            for (ConstructorDecl cd : this.currCBI.allConstructors) {
                ConstructorInstance ciStart;
                ConstructorInstance ci = ciStart = cd.constructorInstance();
                boolean isInitialized = fieldInitializedBeforeConstructors;
                while (ci != null) {
                    Set<FieldInstance> s = this.currCBI.fieldsConstructorInitializes.get(ci.orig());
                    if (s != null && s.contains(fi)) {
                        if (isInitialized) {
                            throw new SemanticException("Final field \"" + fi.name() + "\" might have already been initialized", cd.position());
                        }
                        isInitialized = true;
                    }
                    ci = this.currCBI.constructorCalls.get(ci.orig());
                }
                if (isInitialized || this.currCBI.constructorsCannotTerminateNormally.contains(cd)) continue;
                throw new SemanticException("Final field \"" + fi.name() + "\" might not have been initialized", ciStart.position());
            }
        }
    }

    protected void dataflow(Expr root) throws SemanticException {
        FlowGraph<FlowItem> g = new FlowGraph<FlowItem>(root, this.forward);
        CFGBuilder<FlowItem> v = this.createCFGBuilder(this.ts, g);
        v.visitGraph();
        this.dataflow(g);
        this.post(g, root);
    }

    @Override
    public FlowItem createInitialItem(FlowGraph<FlowItem> graph, Term node, boolean entry) {
        if (node == graph.root() && entry) {
            return this.createInitDFI();
        }
        return BOTTOM;
    }

    private FlowItem createInitDFI() {
        return new FlowItem(new HashMap<VarInstance, AssignmentStatus>(this.currCBI.currClassFinalFieldAssStatuses));
    }

    @Override
    protected CFGBuilder<FlowItem> createCFGBuilder(TypeSystem ts, FlowGraph<FlowItem> g) {
        CFGBuilder<FlowItem> v = new CFGBuilder<FlowItem>(this.lang(), ts, g, this);
        return v;
    }

    @Override
    protected FlowItem confluence(List<FlowItem> items, List<FlowGraph.EdgeKey> itemKeys, FlowGraph.Peer<FlowItem> peer, FlowGraph<FlowItem> graph) {
        Term node = peer.node();
        if (node instanceof Initializer || node instanceof ConstructorDecl) {
            List<FlowItem> filtered = this.filterItemsNonException(items, itemKeys);
            if (filtered.isEmpty()) {
                return new FlowItem(new HashMap<VarInstance, AssignmentStatus>(this.currCBI.currClassFinalFieldAssStatuses), false);
            }
            if (filtered.size() == 1) {
                return filtered.get(0);
            }
            return this.confluence((List)filtered, (FlowGraph.Peer)peer, (FlowGraph)graph);
        }
        return this.confluence((List)items, (FlowGraph.Peer)peer, (FlowGraph)graph);
    }

    @Override
    public FlowItem confluence(List<FlowItem> inItems, FlowGraph.Peer<FlowItem> peer, FlowGraph<FlowItem> graph) {
        HashMap<VarInstance, AssignmentStatus> m = null;
        for (FlowItem itm : inItems) {
            if (itm == BOTTOM) continue;
            if (m == null) {
                m = new HashMap<VarInstance, AssignmentStatus>(itm.assignmentStatus);
                continue;
            }
            Map<VarInstance, AssignmentStatus> n = itm.assignmentStatus;
            for (Map.Entry<VarInstance, AssignmentStatus> e : n.entrySet()) {
                VarInstance v = e.getKey();
                AssignmentStatus as1 = (AssignmentStatus)m.get(v);
                AssignmentStatus as2 = e.getValue();
                m.put(v, AssignmentStatus.join(as1, as2));
            }
        }
        if (m == null) {
            return BOTTOM;
        }
        return new FlowItem(m);
    }

    @Override
    protected Map<FlowGraph.EdgeKey, FlowItem> flow(List<FlowItem> inItems, List<FlowGraph.EdgeKey> inItemKeys, FlowGraph<FlowItem> graph, FlowGraph.Peer<FlowItem> peer) {
        return this.flowToBooleanFlow(inItems, inItemKeys, graph, peer);
    }

    @Override
    public Map<FlowGraph.EdgeKey, FlowItem> flow(FlowItem trueItem, FlowItem falseItem, FlowItem otherItem, FlowGraph<FlowItem> graph, FlowGraph.Peer<FlowItem> peer) {
        FlowItem inItem = this.safeConfluence(trueItem, FlowGraph.EDGE_KEY_TRUE, falseItem, FlowGraph.EDGE_KEY_FALSE, otherItem, FlowGraph.EDGE_KEY_OTHER, peer, graph);
        Term n = peer.node();
        if (peer.isEntry()) {
            LocalDecl ld;
            if (n instanceof LocalDecl && inItem.assignmentStatus.containsKey((ld = (LocalDecl)n).localInstance())) {
                HashMap<VarInstance, AssignmentStatus> newAssStatus = new HashMap<VarInstance, AssignmentStatus>(inItem.assignmentStatus);
                newAssStatus.remove(ld.localInstance());
                inItem = new FlowItem(newAssStatus);
            }
            return DefiniteAssignmentChecker.itemToMap(inItem, peer.succEdgeKeys());
        }
        if (inItem == BOTTOM) {
            return DefiniteAssignmentChecker.itemToMap(BOTTOM, peer.succEdgeKeys());
        }
        FlowItem inDFItem = inItem;
        Map<FlowGraph.EdgeKey, FlowItem> ret = null;
        if (n instanceof Formal) {
            ret = this.flowFormal(inDFItem, graph, (Formal)n, peer.succEdgeKeys());
        } else if (n instanceof LocalDecl) {
            ret = this.flowLocalDecl(inDFItem, graph, (LocalDecl)n, peer.succEdgeKeys());
        } else if (n instanceof LocalAssign) {
            ret = this.flowLocalAssign(inDFItem, graph, (LocalAssign)n, peer.succEdgeKeys());
        } else if (n instanceof FieldAssign) {
            ret = this.flowFieldAssign(inDFItem, graph, (FieldAssign)n, peer.succEdgeKeys());
        } else if (n instanceof ConstructorCall) {
            ret = this.flowConstructorCall(inDFItem, graph, (ConstructorCall)n, peer.succEdgeKeys());
        } else if (n instanceof Expr && ((Expr)n).type().isBoolean() && (n instanceof Binary || n instanceof Conditional || n instanceof Unary)) {
            if (trueItem == null) {
                trueItem = inDFItem;
            }
            if (falseItem == null) {
                falseItem = inDFItem;
            }
            ret = this.flowBooleanConditions(trueItem, falseItem, inDFItem, graph, peer);
        } else {
            ret = this.flowOther(inDFItem, graph, n, peer.succEdgeKeys());
        }
        if (ret == null) {
            ret = DefiniteAssignmentChecker.itemToMap(inItem, peer.succEdgeKeys());
        }
        if (n instanceof Expr) {
            Expr e = (Expr)n;
            if (this.lang().isConstant(e, this.lang()) && e.type().isBoolean()) {
                ret = Boolean.TRUE.equals(this.lang().constantValue(e, this.lang())) ? DefiniteAssignmentChecker.remap(ret, FlowGraph.EDGE_KEY_FALSE, AssignmentStatus.ASS_UNASS) : DefiniteAssignmentChecker.remap(ret, FlowGraph.EDGE_KEY_TRUE, AssignmentStatus.ASS_UNASS);
            }
        }
        return ret;
    }

    private static Map<FlowGraph.EdgeKey, FlowItem> remap(Map<FlowGraph.EdgeKey, FlowItem> m, FlowGraph.EdgeKey ek, AssignmentStatus assStatus) {
        FlowItem fi = m.get(ek);
        if (fi == null) {
            return m;
        }
        HashMap<VarInstance, AssignmentStatus> assignmentStatus = new HashMap<VarInstance, AssignmentStatus>();
        for (VarInstance vi : fi.assignmentStatus.keySet()) {
            assignmentStatus.put(vi, assStatus);
        }
        FlowItem newFI = new FlowItem(assignmentStatus, fi.normalTermination);
        HashMap<FlowGraph.EdgeKey, FlowItem> newM = new HashMap<FlowGraph.EdgeKey, FlowItem>(m);
        newM.put(ek, newFI);
        return newM;
    }

    protected Map<FlowGraph.EdgeKey, FlowItem> flowFormal(FlowItem inItem, FlowGraph<FlowItem> graph, Formal f, Set<FlowGraph.EdgeKey> succEdgeKeys) {
        HashMap<VarInstance, AssignmentStatus> m = new HashMap<VarInstance, AssignmentStatus>(inItem.assignmentStatus);
        m.put(f.localInstance().orig(), AssignmentStatus.ASS);
        this.currCBI.localDeclarations.add(f.localInstance().orig());
        return DataFlow.itemToMap(new FlowItem(m), succEdgeKeys);
    }

    protected Map<FlowGraph.EdgeKey, FlowItem> flowLocalDecl(FlowItem inItem, FlowGraph<FlowItem> graph, LocalDecl ld, Set<FlowGraph.EdgeKey> succEdgeKeys) {
        HashMap<VarInstance, AssignmentStatus> m = new HashMap<VarInstance, AssignmentStatus>(inItem.assignmentStatus);
        AssignmentStatus assStatus = (AssignmentStatus)m.get(ld.localInstance().orig());
        assStatus = ld.init() != null ? AssignmentStatus.ASS : AssignmentStatus.UNASS;
        m.put(ld.localInstance().orig(), assStatus);
        this.currCBI.localDeclarations.add(ld.localInstance());
        return DataFlow.itemToMap(new FlowItem(m), succEdgeKeys);
    }

    protected Map<FlowGraph.EdgeKey, FlowItem> flowLocalAssign(FlowItem inItem, FlowGraph<FlowItem> graph, LocalAssign a, Set<FlowGraph.EdgeKey> succEdgeKeys) {
        Local l = a.left();
        HashMap<VarInstance, AssignmentStatus> m = new HashMap<VarInstance, AssignmentStatus>(inItem.assignmentStatus);
        AssignmentStatus initCount = (AssignmentStatus)m.get(l.localInstance().orig());
        initCount = AssignmentStatus.ASS;
        m.put(l.localInstance().orig(), initCount);
        return DataFlow.itemToMap(new FlowItem(m), succEdgeKeys);
    }

    protected Map<FlowGraph.EdgeKey, FlowItem> flowFieldAssign(FlowItem inItem, FlowGraph<FlowItem> graph, FieldAssign a, Set<FlowGraph.EdgeKey> succEdgeKeys) {
        HashMap<VarInstance, AssignmentStatus> m;
        Field f = a.left();
        FieldInstance fi = f.fieldInstance();
        if (fi.flags().isFinal() && this.isFieldsTargetAppropriate(f) && (m = new HashMap<VarInstance, AssignmentStatus>(inItem.assignmentStatus)).get(fi.orig()) != null) {
            m.put(fi.orig(), AssignmentStatus.ASS);
            return DataFlow.itemToMap(new FlowItem(m), succEdgeKeys);
        }
        return null;
    }

    protected Map<FlowGraph.EdgeKey, FlowItem> flowConstructorCall(FlowItem inItem, FlowGraph<FlowItem> graph, ConstructorCall cc, Set<FlowGraph.EdgeKey> succEdgeKeys) {
        if (ConstructorCall.THIS.equals(cc.kind())) {
            this.currCBI.constructorCalls.put(((ConstructorDecl)this.currCBI.currCodeDecl).constructorInstance().orig(), cc.constructorInstance().orig());
        }
        return null;
    }

    protected Map<FlowGraph.EdgeKey, FlowItem> flowOther(FlowItem inItem, FlowGraph<FlowItem> graph, Node n, Set<FlowGraph.EdgeKey> succEdgeKeys) {
        return null;
    }

    protected boolean isFieldsTargetAppropriate(Field f) {
        Special s;
        ClassType containingClass = this.currCBI.currClass;
        if (f.fieldInstance().flags().isStatic()) {
            return containingClass.equals(f.fieldInstance().orig().container());
        }
        if (f.target() instanceof Special && Special.THIS.equals((s = (Special)f.target()).kind())) {
            return s.qualifier() == null || containingClass.equals(s.qualifier().type());
        }
        return false;
    }

    @Override
    public void check(FlowGraph<FlowItem> graph, Term n, boolean entry, FlowItem inItem, Map<FlowGraph.EdgeKey, FlowItem> outItems) throws SemanticException {
        FlowItem dfIn = inItem;
        if (dfIn == null) {
            dfIn = this.createInitDFI();
        }
        FlowItem dfOut = null;
        if (!entry && outItems != null && !outItems.isEmpty()) {
            dfOut = outItems.values().iterator().next();
            if (n instanceof Field) {
                this.checkField(graph, (Field)n, dfIn);
            } else if (n instanceof Local) {
                this.checkLocal(graph, (Local)n, dfIn);
            } else if (n instanceof LocalAssign) {
                this.checkLocalAssign(graph, ((LocalAssign)n).left().localInstance(), n.position(), dfIn);
            } else if (n instanceof LocalDecl) {
                this.checkLocalAssign(graph, ((LocalDecl)n).localInstance(), n.position(), dfIn);
            } else if (n instanceof FieldAssign) {
                this.checkFieldAssign(graph, (FieldAssign)n, dfIn);
            } else if (n instanceof ClassBody) {
                this.checkClassBody(graph, (ClassBody)n, dfIn, dfOut);
            } else {
                this.checkOther(graph, n, dfIn);
            }
        }
        if (n == graph.root() && !entry) {
            if (this.currCBI.currCodeDecl instanceof FieldDecl) {
                this.finishFieldDecl(graph, (FieldDecl)this.currCBI.currCodeDecl, dfIn, dfOut);
            }
            if (this.currCBI.currCodeDecl instanceof ConstructorDecl) {
                this.finishConstructorDecl(graph, (ConstructorDecl)this.currCBI.currCodeDecl, dfIn, dfOut);
            }
            if (this.currCBI.currCodeDecl instanceof Initializer) {
                this.finishInitializer(graph, (Initializer)this.currCBI.currCodeDecl, dfIn, dfOut);
            }
        }
    }

    protected void finishFieldDecl(FlowGraph<FlowItem> graph, FieldDecl fd, FlowItem dfIn, FlowItem dfOut) {
        for (Map.Entry<VarInstance, AssignmentStatus> e : dfOut.assignmentStatus.entrySet()) {
            FieldInstance fi;
            if (!(e.getKey() instanceof FieldInstance) || !(fi = (FieldInstance)e.getKey()).flags().isFinal()) continue;
            this.currCBI.currClassFinalFieldAssStatuses.put(fi.orig(), e.getValue());
        }
    }

    protected void finishConstructorDecl(FlowGraph<FlowItem> graph, ConstructorDecl cd, FlowItem dfIn, FlowItem dfOut) {
        ConstructorInstance ci = cd.constructorInstance();
        HashSet<FieldInstance> s = new HashSet<FieldInstance>();
        for (Map.Entry<VarInstance, AssignmentStatus> e : dfOut.assignmentStatus.entrySet()) {
            if (!(e.getKey() instanceof FieldInstance) || !((FieldInstance)e.getKey()).flags().isFinal() || ((FieldInstance)e.getKey()).flags().isStatic()) continue;
            FieldInstance fi = (FieldInstance)e.getKey();
            AssignmentStatus initCount = e.getValue();
            AssignmentStatus origInitCount = this.currCBI.currClassFinalFieldAssStatuses.get(fi);
            if (!initCount.definitelyAssigned || origInitCount.definitelyAssigned) continue;
            s.add(fi);
        }
        if (!s.isEmpty()) {
            this.currCBI.fieldsConstructorInitializes.put(ci.orig(), s);
        }
        if (!dfIn.normalTermination) {
            this.currCBI.constructorsCannotTerminateNormally.add(cd);
        }
    }

    protected void finishInitializer(FlowGraph<FlowItem> graph, Initializer initializer, FlowItem dfIn, FlowItem dfOut) {
        for (Map.Entry<VarInstance, AssignmentStatus> e : dfOut.assignmentStatus.entrySet()) {
            FieldInstance fi;
            if (!(e.getKey() instanceof FieldInstance) || !(fi = (FieldInstance)e.getKey()).flags().isFinal()) continue;
            this.currCBI.currClassFinalFieldAssStatuses.put(fi.orig(), e.getValue());
        }
    }

    protected void checkField(FlowGraph<FlowItem> graph, Field f, FlowItem dfIn) throws SemanticException {
        AssignmentStatus initCount;
        FieldInstance fi = f.fieldInstance();
        if (fi.flags().isFinal() && this.ts.typeEquals(this.currCBI.currClass, fi.container()) && (this.currCBI.currCodeDecl instanceof FieldDecl || this.currCBI.currCodeDecl instanceof ConstructorDecl || this.currCBI.currCodeDecl instanceof Initializer) && this.isFieldsTargetAppropriate(f) && ((initCount = dfIn.assignmentStatus.get(fi.orig())) == null || !initCount.definitelyAssigned)) {
            throw new SemanticException("Final field \"" + f.name() + "\" might not have been initialized", f.position());
        }
    }

    protected void checkLocal(FlowGraph<FlowItem> graph, Local l, FlowItem dfIn) throws SemanticException {
        if (!this.currCBI.localDeclarations.contains(l.localInstance().orig())) {
            this.currCBI.outerLocalsUsed.add(l.localInstance().orig());
        } else {
            AssignmentStatus initCount = dfIn.assignmentStatus.get(l.localInstance().orig());
            if ((initCount == null || !initCount.definitelyAssigned) && l.reachable()) {
                throw new SemanticException("Local variable \"" + l.name() + "\" may not have been initialized", l.position());
            }
        }
    }

    protected void checkLocalInstanceInit(LocalInstance li, FlowItem dfIn, Position pos) throws SemanticException {
        AssignmentStatus initCount = dfIn.assignmentStatus.get(li.orig());
        if (initCount != null && !initCount.definitelyAssigned) {
            throw new SemanticException("Local variable \"" + li.name() + "\" may not have been initialized", pos);
        }
    }

    protected void checkLocalAssign(FlowGraph<FlowItem> graph, LocalInstance li, Position pos, FlowItem dfIn) throws SemanticException {
        if (!this.currCBI.localDeclarations.contains(li.orig())) {
            throw new SemanticException("Final local variable \"" + li.name() + "\" cannot be assigned to in an inner class.", pos);
        }
        AssignmentStatus initCount = dfIn.assignmentStatus.get(li.orig());
        if (li.flags().isFinal() && initCount != null && !initCount.definitelyUnassigned) {
            throw new SemanticException("Final variable \"" + li.name() + "\" might already have been initialized", pos);
        }
    }

    protected void checkFieldAssign(FlowGraph<FlowItem> graph, FieldAssign a, FlowItem dfIn) throws SemanticException {
        Field f = a.left();
        FieldInstance fi = f.fieldInstance();
        if (fi.flags().isFinal()) {
            if ((this.currCBI.currCodeDecl instanceof FieldDecl || this.currCBI.currCodeDecl instanceof ConstructorDecl || this.currCBI.currCodeDecl instanceof Initializer) && this.isFieldsTargetAppropriate(f)) {
                AssignmentStatus initCount = dfIn.assignmentStatus.get(fi.orig());
                if (initCount == null) {
                    throw new InternalCompilerError("Dataflow information not found for field \"" + fi.name() + "\".", a.position());
                }
                if (!initCount.definitelyUnassigned) {
                    throw new SemanticException("Final field \"" + fi.name() + "\" might already have been initialized", a.position());
                }
            } else {
                throw new SemanticException("Cannot assign a value to final field \"" + fi.name() + "\" of \"" + fi.orig().container() + "\".", a.position());
            }
        }
    }

    protected void checkClassBody(FlowGraph<FlowItem> graph, ClassBody cb, FlowItem dfIn, FlowItem dfOut) throws SemanticException {
        Set<LocalInstance> localsUsed = this.currCBI.localsUsedInClassBodies.get(cb);
        if (localsUsed != null) {
            this.checkLocalsUsedByInnerClass(graph, cb, localsUsed, dfIn, dfOut);
        }
    }

    protected void checkLocalsUsedByInnerClass(FlowGraph<FlowItem> graph, ClassBody cb, Set<LocalInstance> localsUsed, FlowItem dfIn, FlowItem dfOut) throws SemanticException {
        for (LocalInstance li : localsUsed) {
            AssignmentStatus initCount = dfOut.assignmentStatus.get(li.orig());
            if (!this.currCBI.localDeclarations.contains(li.orig())) {
                this.currCBI.outerLocalsUsed.add(li.orig());
                continue;
            }
            if (initCount != null && initCount.definitelyAssigned) continue;
            throw new SemanticException("Local variable \"" + li.name() + "\" must be initialized before the class " + "declaration.", cb.position());
        }
    }

    protected void checkOther(FlowGraph<FlowItem> graph, Node n, FlowItem dfIn) throws SemanticException {
    }

    protected static class FlowItem
    extends DataFlow.Item {
        public Map<VarInstance, AssignmentStatus> assignmentStatus;
        public final boolean normalTermination;

        FlowItem(Map<VarInstance, AssignmentStatus> m) {
            this.assignmentStatus = Collections.unmodifiableMap(m);
            this.normalTermination = true;
        }

        FlowItem(Map<VarInstance, AssignmentStatus> m, boolean canTerminateNormally) {
            this.assignmentStatus = Collections.unmodifiableMap(m);
            this.normalTermination = canTerminateNormally;
        }

        public String toString() {
            return this.assignmentStatus.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof FlowItem) {
                return this.assignmentStatus.equals(((FlowItem)o).assignmentStatus);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.assignmentStatus.hashCode();
        }
    }

    protected static class AssignmentStatus {
        public static final AssignmentStatus ASS_UNASS = new AssignmentStatus(true, true);
        public static final AssignmentStatus ASS = new AssignmentStatus(true, false);
        public static final AssignmentStatus UNASS = new AssignmentStatus(false, true);
        public static final AssignmentStatus NEITHER = new AssignmentStatus(false, false);
        public final boolean definitelyAssigned;
        public final boolean definitelyUnassigned;

        protected AssignmentStatus(boolean definitelyAssigned, boolean definitelyUnassigned) {
            this.definitelyAssigned = definitelyAssigned;
            this.definitelyUnassigned = definitelyUnassigned;
        }

        public int hashCode() {
            return Boolean.valueOf(this.definitelyAssigned).hashCode() ^ Boolean.valueOf(this.definitelyUnassigned).hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof AssignmentStatus) {
                return this.definitelyAssigned == ((AssignmentStatus)o).definitelyAssigned && this.definitelyUnassigned == ((AssignmentStatus)o).definitelyUnassigned;
            }
            return false;
        }

        public String toString() {
            return "[" + (this.definitelyAssigned ? "definitely assigned " : "") + (this.definitelyUnassigned ? "definitely unassigned " : "") + "]";
        }

        public static AssignmentStatus join(AssignmentStatus as1, AssignmentStatus as2) {
            if (as1 == null) {
                return as2;
            }
            if (as2 == null) {
                return as1;
            }
            boolean defAss = as1.definitelyAssigned && as2.definitelyAssigned;
            boolean defUnass = as1.definitelyUnassigned && as2.definitelyUnassigned;
            return AssignmentStatus.construct(defAss, defUnass);
        }

        private static AssignmentStatus construct(boolean defAss, boolean defUnass) {
            if (defAss && defUnass) {
                return ASS_UNASS;
            }
            if (defAss && !defUnass) {
                return ASS;
            }
            if (!defAss && defUnass) {
                return UNASS;
            }
            return NEITHER;
        }
    }

    protected static class ClassBodyInfo {
        public ClassBodyInfo outer = null;
        public CodeNode currCodeDecl = null;
        public ClassType currClass = null;
        public Map<FieldInstance, AssignmentStatus> currClassFinalFieldAssStatuses = new HashMap<FieldInstance, AssignmentStatus>();
        public List<ConstructorDecl> allConstructors = new ArrayList<ConstructorDecl>();
        public Set<ConstructorDecl> constructorsCannotTerminateNormally = new HashSet<ConstructorDecl>();
        public Map<ConstructorInstance, ConstructorInstance> constructorCalls = new HashMap<ConstructorInstance, ConstructorInstance>();
        public Map<ConstructorInstance, Set<FieldInstance>> fieldsConstructorInitializes = new HashMap<ConstructorInstance, Set<FieldInstance>>();
        public Set<LocalInstance> outerLocalsUsed = new HashSet<LocalInstance>();
        public Map<ClassBody, Set<LocalInstance>> localsUsedInClassBodies = new HashMap<ClassBody, Set<LocalInstance>>();
        public Set<LocalInstance> localDeclarations = new HashSet<LocalInstance>();

        protected ClassBodyInfo() {
        }
    }
}

