/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import polyglot.ast.Binary;
import polyglot.ast.CodeDecl;
import polyglot.ast.CodeNode;
import polyglot.ast.Conditional;
import polyglot.ast.Expr;
import polyglot.ast.JLang;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Term;
import polyglot.ast.Unary;
import polyglot.frontend.Job;
import polyglot.main.Report;
import polyglot.types.MemberInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.IdentityKey;
import polyglot.util.InternalCompilerError;
import polyglot.util.Pair;
import polyglot.util.StringUtil;
import polyglot.visit.CFGBuildError;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ErrorHandlingVisitor;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;

public abstract class DataFlow<FlowItem extends Item>
extends ErrorHandlingVisitor {
    protected final boolean forward;
    protected final boolean detectBackEdges;
    protected final boolean dataflowOnEntry;
    protected LinkedList<FlowGraphSource<FlowItem>> flowgraphStack;
    protected Map<FlowGraph.Peer<FlowItem>, Integer> postordering = null;
    protected static int flowCounter = 0;

    public DataFlow(Job job, TypeSystem ts, NodeFactory nf, boolean forward) {
        this(job, ts, nf, forward, false);
    }

    public DataFlow(Job job, TypeSystem ts, NodeFactory nf, boolean forward, boolean dataflowOnEntry) {
        this(job, ts, nf, forward, dataflowOnEntry, false);
    }

    public DataFlow(Job job, TypeSystem ts, NodeFactory nf, boolean forward, boolean dataflowOnEntry, boolean detectBackEdges) {
        super(job, ts, nf);
        this.forward = forward;
        this.detectBackEdges = detectBackEdges;
        this.dataflowOnEntry = dataflowOnEntry;
        this.flowgraphStack = dataflowOnEntry ? new LinkedList() : null;
    }

    @Override
    public JLang lang() {
        return (JLang)super.lang();
    }

    protected FlowItem createInitialItem(FlowGraph<FlowItem> graph, FlowGraph.Peer<FlowItem> peer) {
        return this.createInitialItem(graph, peer.node, peer.isEntry());
    }

    protected abstract FlowItem createInitialItem(FlowGraph<FlowItem> var1, Term var2, boolean var3);

    protected Map<FlowGraph.EdgeKey, FlowItem> flow(FlowItem in, FlowGraph<FlowItem> graph, FlowGraph.Peer<FlowItem> peer) {
        throw new InternalCompilerError("Unimplemented: should be implemented by subclasses if needed");
    }

    protected Map<FlowGraph.EdgeKey, FlowItem> flow(List<FlowItem> inItems, List<FlowGraph.EdgeKey> inItemKeys, List<FlowGraph.Peer<FlowItem>> inItemPeers, FlowGraph<FlowItem> graph, FlowGraph.Peer<FlowItem> p) {
        if (this.detectBackEdges) {
            ArrayList<Boolean> isBackEdges = new ArrayList<Boolean>(inItemPeers.size());
            int currentPeerOrder = this.postordering.get(p);
            for (FlowGraph.Peer<FlowItem> inPeer : inItemPeers) {
                int inPeerOrder = this.postordering.get(inPeer);
                isBackEdges.add(inPeerOrder < currentPeerOrder);
            }
            return this.flow(inItems, inItemKeys, inItemPeers, isBackEdges, graph, p);
        }
        return this.flow(inItems, inItemKeys, graph, p);
    }

    protected Map<FlowGraph.EdgeKey, FlowItem> flow(List<FlowItem> inItems, List<FlowGraph.EdgeKey> inItemKeys, List<FlowGraph.Peer<FlowItem>> inItemPeers, List<Boolean> isBackEdges, FlowGraph<FlowItem> graph, FlowGraph.Peer<FlowItem> p) {
        throw new InternalCompilerError("Unimplemented. Should be implemented if a subclass wants to detect back edges. The standard thing to do in this method is to merge the inItems by item key, using the widening operator for back edges, and the standard merge operator otherwise.");
    }

    protected Map<FlowGraph.EdgeKey, FlowItem> flow(List<FlowItem> inItems, List<FlowGraph.EdgeKey> inItemKeys, FlowGraph<FlowItem> graph, FlowGraph.Peer<FlowItem> peer) {
        FlowItem inItem = this.safeConfluence(inItems, inItemKeys, peer, graph);
        return this.flow(inItem, graph, peer);
    }

    protected final Map<FlowGraph.EdgeKey, FlowItem> flowToBooleanFlow(List<FlowItem> inItems, List<FlowGraph.EdgeKey> inItemKeys, FlowGraph<FlowItem> graph, FlowGraph.Peer<FlowItem> peer) {
        ArrayList<Item> trueItems = new ArrayList<Item>();
        ArrayList<FlowGraph.EdgeKey> trueItemKeys = new ArrayList<FlowGraph.EdgeKey>();
        ArrayList<Item> falseItems = new ArrayList<Item>();
        ArrayList<FlowGraph.EdgeKey> falseItemKeys = new ArrayList<FlowGraph.EdgeKey>();
        ArrayList<Item> otherItems = new ArrayList<Item>();
        ArrayList<FlowGraph.EdgeKey> otherItemKeys = new ArrayList<FlowGraph.EdgeKey>();
        Iterator<FlowItem> i = inItems.iterator();
        Iterator<FlowGraph.EdgeKey> j = inItemKeys.iterator();
        while (i.hasNext() || j.hasNext()) {
            Item item = (Item)i.next();
            FlowGraph.EdgeKey key = j.next();
            if (FlowGraph.EDGE_KEY_TRUE.equals(key)) {
                trueItems.add(item);
                trueItemKeys.add(key);
                continue;
            }
            if (FlowGraph.EDGE_KEY_FALSE.equals(key)) {
                falseItems.add(item);
                falseItemKeys.add(key);
                continue;
            }
            otherItems.add(item);
            otherItemKeys.add(key);
        }
        FlowItem trueItem = trueItems.isEmpty() ? null : (FlowItem)this.safeConfluence(trueItems, trueItemKeys, peer, graph);
        FlowItem falseItem = falseItems.isEmpty() ? null : (FlowItem)this.safeConfluence(falseItems, falseItemKeys, peer, graph);
        FlowItem otherItem = otherItems.isEmpty() ? null : (FlowItem)this.safeConfluence(otherItems, otherItemKeys, peer, graph);
        return this.flow(trueItem, falseItem, otherItem, graph, peer);
    }

    protected Map<FlowGraph.EdgeKey, FlowItem> flow(FlowItem trueItem, FlowItem falseItem, FlowItem otherItem, FlowGraph<FlowItem> graph, FlowGraph.Peer<FlowItem> peer) {
        throw new InternalCompilerError("Unimplemented: should be implemented by subclasses if needed");
    }

    protected Map<FlowGraph.EdgeKey, FlowItem> flowBooleanConditions(FlowItem trueItem, FlowItem falseItem, FlowItem otherItem, FlowGraph<FlowItem> graph, FlowGraph.Peer<FlowItem> peer) {
        Expr n = (Expr)peer.node();
        Set<FlowGraph.EdgeKey> edgeKeys = peer.succEdgeKeys();
        if (!n.type().isBoolean() || !(n instanceof Binary) && !(n instanceof Conditional) && !(n instanceof Unary)) {
            throw new InternalCompilerError("This method only takes binary, conditional, or unary operators of boolean type");
        }
        if (trueItem == null || falseItem == null) {
            throw new IllegalArgumentException("The trueItem and falseItem for flowBooleanConditions must be non-null.");
        }
        if (n instanceof Unary) {
            Unary u = (Unary)n;
            if (u.operator() == Unary.NOT) {
                return DataFlow.itemsToMap(falseItem, trueItem, otherItem, edgeKeys);
            }
        } else if (n instanceof Binary) {
            Binary b = (Binary)n;
            if (b.operator() == Binary.COND_AND) {
                return DataFlow.itemsToMap(trueItem, falseItem, otherItem, edgeKeys);
            }
            if (b.operator() == Binary.COND_OR) {
                return DataFlow.itemsToMap(trueItem, falseItem, otherItem, edgeKeys);
            }
            if (b.operator() == Binary.BIT_AND) {
                FlowItem bitANDFalse = this.safeConfluence(trueItem, FlowGraph.EDGE_KEY_TRUE, falseItem, FlowGraph.EDGE_KEY_FALSE, peer, graph);
                return DataFlow.itemsToMap(trueItem, bitANDFalse, otherItem, edgeKeys);
            }
            if (b.operator() == Binary.BIT_OR) {
                FlowItem bitORTrue = this.safeConfluence(trueItem, FlowGraph.EDGE_KEY_TRUE, falseItem, FlowGraph.EDGE_KEY_FALSE, peer, graph);
                return DataFlow.itemsToMap(bitORTrue, falseItem, otherItem, edgeKeys);
            }
        } else if (n instanceof Conditional) {
            return DataFlow.itemsToMap(trueItem, falseItem, otherItem, edgeKeys);
        }
        return null;
    }

    protected abstract FlowItem confluence(List<FlowItem> var1, FlowGraph.Peer<FlowItem> var2, FlowGraph<FlowItem> var3);

    protected FlowItem confluence(List<FlowItem> items, List<FlowGraph.EdgeKey> itemKeys, FlowGraph.Peer<FlowItem> peer, FlowGraph<FlowItem> graph) {
        return this.confluence(items, peer, graph);
    }

    protected FlowItem safeConfluence(List<FlowItem> items, List<FlowGraph.EdgeKey> itemKeys, FlowGraph.Peer<FlowItem> peer, FlowGraph<FlowItem> graph) {
        if (items.isEmpty()) {
            return this.createInitialItem(graph, peer);
        }
        if (items.size() == 1) {
            return (FlowItem)((Item)items.get(0));
        }
        return this.confluence(items, itemKeys, peer, graph);
    }

    protected FlowItem safeConfluence(FlowItem item1, FlowGraph.EdgeKey key1, FlowItem item2, FlowGraph.EdgeKey key2, FlowGraph.Peer<FlowItem> peer, FlowGraph<FlowItem> graph) {
        return this.safeConfluence(item1, key1, item2, key2, null, null, peer, graph);
    }

    protected FlowItem safeConfluence(FlowItem item1, FlowGraph.EdgeKey key1, FlowItem item2, FlowGraph.EdgeKey key2, FlowItem item3, FlowGraph.EdgeKey key3, FlowGraph.Peer<FlowItem> peer, FlowGraph<FlowItem> graph) {
        ArrayList<FlowItem> items = new ArrayList<FlowItem>(3);
        ArrayList<FlowGraph.EdgeKey> itemKeys = new ArrayList<FlowGraph.EdgeKey>(3);
        if (item1 != null) {
            items.add(item1);
            itemKeys.add(key1);
        }
        if (item2 != null) {
            items.add(item2);
            itemKeys.add(key2);
        }
        if (item3 != null) {
            items.add(item3);
            itemKeys.add(key3);
        }
        return (FlowItem)this.safeConfluence(items, itemKeys, peer, graph);
    }

    protected abstract void check(FlowGraph<FlowItem> var1, Term var2, boolean var3, FlowItem var4, Map<FlowGraph.EdgeKey, FlowItem> var5) throws SemanticException;

    protected void check(FlowGraph<FlowItem> graph, FlowGraph.Peer<FlowItem> p) throws SemanticException {
        this.check(graph, p.node(), p.isEntry(), p.inItem(), p.outItems);
    }

    protected void dataflow(CodeDecl cd) throws SemanticException {
        this.dataflow((CodeNode)cd);
    }

    protected void dataflow(CodeNode cd) throws SemanticException {
        FlowGraph<FlowItem> g;
        if (cd.codeBody() != null && (g = this.initGraph(cd, (Term)cd)) != null) {
            CFGBuilder<FlowItem> v = this.createCFGBuilder(this.ts, g);
            try {
                v.visitGraph();
            }
            catch (CFGBuildError e) {
                throw new SemanticException(e.message(), e.position());
            }
            this.dataflow(g);
            this.post(g, cd);
            if (this.dataflowOnEntry) {
                this.flowgraphStack.addFirst(new FlowGraphSource<FlowItem>(g, cd));
            }
        }
    }

    protected Frame<FlowItem> createFrame(FlowGraph.Peer<FlowItem> p, boolean forward, FlowGraph<FlowItem> grahp) {
        return new Frame<FlowItem>(p, forward);
    }

    protected Pair<FlowGraph.Peer<FlowItem>[], int[]> findSCCs(FlowGraph<FlowItem> graph) {
        Collection<FlowGraph.Peer<FlowItem>> peers = graph.peers();
        FlowGraph.Peer[] sorted = new FlowGraph.Peer[peers.size()];
        Collection<FlowGraph.Peer<FlowItem>> start = graph.startPeers();
        int n = 0;
        LinkedList stack = new LinkedList();
        HashSet reachable = new HashSet();
        for (FlowGraph.Peer<FlowItem> peer : start) {
            if (reachable.contains(peer)) continue;
            reachable.add(peer);
            stack.addFirst(this.createFrame(peer, true, graph));
            while (stack.size() != 0) {
                Frame top = (Frame)stack.getFirst();
                if (top.edges.hasNext()) {
                    FlowGraph.Edge e = top.edges.next();
                    FlowGraph.Peer q = e.getTarget();
                    if (reachable.contains(q)) continue;
                    reachable.add(q);
                    stack.addFirst(this.createFrame(q, true, graph));
                    continue;
                }
                stack.removeFirst();
                sorted[n++] = top.peer;
            }
        }
        FlowGraph.Peer[] by_scc = new FlowGraph.Peer[n];
        int[] scc_head = new int[n];
        HashSet visited = new HashSet();
        int head = 0;
        for (int i = n - 1; i >= 0; --i) {
            if (visited.contains(sorted[i])) continue;
            HashSet SCC = new HashSet();
            visited.add(sorted[i]);
            stack.add(this.createFrame(sorted[i], false, graph));
            while (stack.size() != 0) {
                Frame top = (Frame)stack.getFirst();
                if (top.edges.hasNext()) {
                    FlowGraph.Edge e = top.edges.next();
                    FlowGraph.Peer q = e.getTarget();
                    if (!reachable.contains(q) || visited.contains(q)) continue;
                    visited.add(q);
                    Frame f = this.createFrame(q, false, graph);
                    stack.addFirst(f);
                    continue;
                }
                stack.removeFirst();
                SCC.add(top.peer);
            }
            stack.add(this.createFrame(sorted[i], true, graph));
            HashSet revisited = new HashSet();
            revisited.add(sorted[i]);
            int scc_size = SCC.size();
            int nsorted = 0;
            while (stack.size() != 0) {
                Frame top = (Frame)stack.getFirst();
                if (top.edges.hasNext()) {
                    FlowGraph.Edge e = top.edges.next();
                    FlowGraph.Peer q = e.getTarget();
                    if (!SCC.contains(q) || revisited.contains(q)) continue;
                    revisited.add(q);
                    Frame f = this.createFrame(q, true, graph);
                    stack.addFirst(f);
                    continue;
                }
                stack.removeFirst();
                int n3 = head + scc_size - nsorted - 1;
                scc_head[n3] = -2;
                by_scc[n3] = top.peer;
                ++nsorted;
            }
            scc_head[head + scc_size - 1] = head;
            scc_head[head] = -1;
            head += scc_size;
        }
        if (Report.should_report("dataflow", 2)) {
            for (int j = 0; j < n; ++j) {
                switch (scc_head[j]) {
                    case -1: {
                        Report.report(2, j + "[HEAD] : " + by_scc[j]);
                        break;
                    }
                    case -2: {
                        Report.report(2, j + "       : " + by_scc[j]);
                        break;
                    }
                    default: {
                        Report.report(2, j + " ->" + scc_head[j] + " : " + by_scc[j]);
                    }
                }
                for (FlowGraph.Edge e : by_scc[j].succs()) {
                    Report.report(3, "     successor: " + e.getTarget());
                }
            }
        }
        return new Pair<FlowGraph.Peer<FlowItem>[], int[]>(by_scc, scc_head);
    }

    private int postorder(FlowGraph.Peer<FlowItem> p, int count, Set<FlowGraph.Peer<FlowItem>> visited) {
        if (visited.contains(p)) {
            return count;
        }
        visited.add(p);
        for (FlowGraph.Edge<FlowItem> e : p.succs()) {
            count = this.postorder(e.getTarget(), count, visited);
        }
        this.postordering.put(p, count++);
        return count;
    }

    protected void dataflow(FlowGraph<FlowItem> graph) {
        if (Report.should_report("dataflow", 1)) {
            Report.report(1, "Finding strongly connected components");
        }
        Pair<FlowGraph.Peer<FlowItem>[], int[]> pair = this.findSCCs(graph);
        FlowGraph.Peer<FlowItem>[] by_scc = pair.part1();
        int[] scc_head = pair.part2();
        int npeers = by_scc.length;
        if (this.detectBackEdges) {
            this.postordering = new HashMap<FlowGraph.Peer<FlowItem>, Integer>();
            int count = 0;
            HashSet<FlowGraph.Peer<FlowItem>> visited = new HashSet<FlowGraph.Peer<FlowItem>>();
            for (FlowGraph.Peer<FlowItem> p : graph.startPeers()) {
                count = this.postorder(p, count, visited);
            }
        }
        if (Report.should_report("dataflow", 1)) {
            Report.report(1, "Iterating dataflow equations");
        }
        int current = 0;
        boolean change = false;
        while (current < npeers) {
            FlowGraph.Peer<FlowItem> p = by_scc[current];
            if (scc_head[current] == -1) {
                change = false;
            }
            ArrayList<Item> inItems = new ArrayList<Item>(p.preds.size());
            ArrayList<FlowGraph.EdgeKey> inItemKeys = new ArrayList<FlowGraph.EdgeKey>(p.preds.size());
            ArrayList inItemPeers = new ArrayList(p.preds.size());
            for (FlowGraph.Edge e : p.preds) {
                FlowGraph.Peer o = e.getTarget();
                if (o.outItems == null) continue;
                if (!o.outItems.keySet().contains(e.getKey())) {
                    throw new InternalCompilerError("There should have an out Item with edge key " + e.getKey() + "; instead there were only " + o.outItems.keySet());
                }
                Item it = (Item)o.outItems.get(e.getKey());
                if (it == null) continue;
                inItems.add(it);
                inItemKeys.add(e.getKey());
                inItemPeers.add(o);
            }
            Map oldOutItems = p.outItems;
            p.inItem = this.safeConfluence(inItems, inItemKeys, p, graph);
            p.outItems = this.flow((FlowItem)inItems, (FlowItem)inItemKeys, (FlowItem)inItemPeers, graph, p);
            if (!p.succEdgeKeys().equals(p.outItems.keySet())) {
                throw new InternalCompilerError("The flow only defined outputs for " + p.outItems.keySet() + "; needs to " + "define outputs for all of: " + p.succEdgeKeys() + " for node " + p.node, p.node.position());
            }
            if (!(oldOutItems == p.outItems || oldOutItems != null && oldOutItems.equals(p.outItems))) {
                change = true;
            }
            if (change && scc_head[current] >= 0) {
                current = scc_head[current];
                continue;
            }
            ++current;
        }
        if (Report.should_report("dataflow", 1)) {
            Report.report(1, "Done.");
        }
    }

    protected FlowGraph<FlowItem> initGraph(CodeNode code, Term root) {
        return new FlowGraph(root, this.forward);
    }

    protected FlowGraph<FlowItem> initGraph(CodeDecl code, Term root) {
        return this.initGraph((CodeNode)code, root);
    }

    protected CFGBuilder<FlowItem> createCFGBuilder(TypeSystem ts, FlowGraph<FlowItem> g) {
        return new CFGBuilder<FlowItem>(this.lang(), ts, g, this);
    }

    @Override
    protected NodeVisitor enterCall(Node n) throws SemanticException {
        if (this.dataflowOnEntry && n instanceof CodeNode) {
            this.dataflow((CodeNode)n);
        }
        return this;
    }

    @Override
    public Node leave(Node parent, Node old, Node n, NodeVisitor v) {
        Map o;
        if (old != n && this.dataflowOnEntry && this.currentFlowGraph() != null && (o = this.currentFlowGraph().peerMap.get(new IdentityKey(old))) != null) {
            this.currentFlowGraph().peerMap.put(new IdentityKey(n), o);
        }
        return super.leave(parent, old, n, v);
    }

    @Override
    protected Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        if (n instanceof CodeNode) {
            FlowGraphSource<FlowItem> fgs;
            if (!this.dataflowOnEntry) {
                this.dataflow((CodeNode)n);
            } else if (this.dataflowOnEntry && !this.flowgraphStack.isEmpty() && (fgs = this.flowgraphStack.getFirst()).source().equals(old)) {
                this.flowgraphStack.removeFirst();
            }
        }
        return n;
    }

    protected void post(FlowGraph<FlowItem> graph, Term root) throws SemanticException {
        if (Report.should_report("cfg", 2)) {
            this.dumpFlowGraph(graph, root);
        }
        HashSet<FlowGraph.Peer<FlowItem>> uncheckedPeers = new HashSet<FlowGraph.Peer<FlowItem>>(graph.peers());
        LinkedList<FlowGraph.Peer<FlowItem>> peersToCheck = new LinkedList<FlowGraph.Peer<FlowItem>>(graph.startPeers());
        while (!peersToCheck.isEmpty()) {
            FlowGraph.Peer<FlowItem> p = peersToCheck.removeFirst();
            uncheckedPeers.remove(p);
            this.check(graph, p);
            for (FlowGraph.Edge e : p.succs) {
                FlowGraph.Peer q = e.getTarget();
                if (!uncheckedPeers.contains(q) || peersToCheck.contains(q)) continue;
                peersToCheck.addLast(q);
            }
            if (!peersToCheck.isEmpty() || uncheckedPeers.isEmpty()) continue;
            Iterator i = uncheckedPeers.iterator();
            peersToCheck.add((FlowGraph.Peer<FlowItem>)i.next());
            i.remove();
        }
    }

    protected FlowGraph<FlowItem> currentFlowGraph() {
        if (!this.dataflowOnEntry) {
            throw new InternalCompilerError("currentFlowGraph() cannot be called when dataflow is not performed on entry");
        }
        if (this.flowgraphStack.isEmpty()) {
            return null;
        }
        return this.flowgraphStack.getFirst().flowGraph();
    }

    public static final <FlowItem> Map<FlowGraph.EdgeKey, FlowItem> itemToMap(FlowItem i, Set<FlowGraph.EdgeKey> edgeKeys) {
        HashMap<FlowGraph.EdgeKey, FlowItem> m = new HashMap<FlowGraph.EdgeKey, FlowItem>();
        for (FlowGraph.EdgeKey k : edgeKeys) {
            m.put(k, i);
        }
        return m;
    }

    protected static final <FlowItem> Map<FlowGraph.EdgeKey, FlowItem> itemsToMap(FlowItem trueItem, FlowItem falseItem, FlowItem remainingItem, Set<FlowGraph.EdgeKey> edgeKeys) {
        HashMap<FlowGraph.EdgeKey, FlowItem> m = new HashMap<FlowGraph.EdgeKey, FlowItem>();
        for (FlowGraph.EdgeKey k : edgeKeys) {
            if (FlowGraph.EDGE_KEY_TRUE.equals(k)) {
                m.put(k, trueItem);
                continue;
            }
            if (FlowGraph.EDGE_KEY_FALSE.equals(k)) {
                m.put(k, falseItem);
                continue;
            }
            m.put(k, remainingItem);
        }
        return m;
    }

    protected final List<FlowItem> filterItemsNonError(List<FlowItem> items, List<FlowGraph.EdgeKey> itemKeys) {
        ArrayList<Item> filtered = new ArrayList<Item>(items.size());
        Iterator<FlowItem> i = items.iterator();
        Iterator<FlowGraph.EdgeKey> j = itemKeys.iterator();
        while (i.hasNext() && j.hasNext()) {
            Item item = (Item)i.next();
            FlowGraph.EdgeKey key = j.next();
            if (key instanceof FlowGraph.ExceptionEdgeKey && ((FlowGraph.ExceptionEdgeKey)key).type().isSubtype(this.ts.Error())) continue;
            filtered.add(item);
        }
        if (i.hasNext() || j.hasNext()) {
            throw new InternalCompilerError("item and item key lists have different sizes.");
        }
        return filtered;
    }

    protected final List<FlowItem> filterItemsNonException(List<FlowItem> items, List<FlowGraph.EdgeKey> itemKeys) {
        ArrayList<Item> filtered = new ArrayList<Item>(items.size());
        Iterator<FlowItem> i = items.iterator();
        Iterator<FlowGraph.EdgeKey> j = itemKeys.iterator();
        while (i.hasNext() && j.hasNext()) {
            Item item = (Item)i.next();
            FlowGraph.EdgeKey key = j.next();
            if (key instanceof FlowGraph.ExceptionEdgeKey) continue;
            filtered.add(item);
        }
        if (i.hasNext() || j.hasNext()) {
            throw new InternalCompilerError("item and item key lists have different sizes.");
        }
        return filtered;
    }

    protected final List<FlowItem> filterItemsExceptionSubclass(List<FlowItem> items, List<FlowGraph.EdgeKey> itemKeys, Type excType) {
        ArrayList<Item> filtered = new ArrayList<Item>(items.size());
        Iterator<FlowItem> i = items.iterator();
        Iterator<FlowGraph.EdgeKey> j = itemKeys.iterator();
        while (i.hasNext() && j.hasNext()) {
            FlowGraph.ExceptionEdgeKey eek;
            Item item = (Item)i.next();
            FlowGraph.EdgeKey key = j.next();
            if (!(key instanceof FlowGraph.ExceptionEdgeKey) || !(eek = (FlowGraph.ExceptionEdgeKey)key).type().isImplicitCastValid(excType)) continue;
            filtered.add(item);
        }
        if (i.hasNext() || j.hasNext()) {
            throw new InternalCompilerError("item and item key lists have different sizes.");
        }
        return filtered;
    }

    protected final List<FlowItem> filterItems(List<FlowItem> items, List<FlowGraph.EdgeKey> itemKeys, FlowGraph.EdgeKey filterEdgeKey) {
        ArrayList<Item> filtered = new ArrayList<Item>(items.size());
        Iterator<FlowItem> i = items.iterator();
        Iterator<FlowGraph.EdgeKey> j = itemKeys.iterator();
        while (i.hasNext() && j.hasNext()) {
            Item item = (Item)i.next();
            FlowGraph.EdgeKey key = j.next();
            if (!filterEdgeKey.equals(key)) continue;
            filtered.add(item);
        }
        if (i.hasNext() || j.hasNext()) {
            throw new InternalCompilerError("item and item key lists have different sizes.");
        }
        return filtered;
    }

    protected static final boolean hasTrueFalseBranches(Set<FlowGraph.EdgeKey> edgeKeys) {
        return edgeKeys.contains(FlowGraph.EDGE_KEY_FALSE) && edgeKeys.contains(FlowGraph.EDGE_KEY_TRUE);
    }

    @Deprecated
    protected static <FlowItem extends Item> Map<FlowGraph.EdgeKey, FlowItem> constructItemsFromCondition(Expr booleanCond, FlowItem startingItem, Set<FlowGraph.EdgeKey> succEdgeKeys, ConditionNavigator<FlowItem> navigator) {
        if (!booleanCond.type().isBoolean()) {
            throw new IllegalArgumentException("booleanCond must be a boolean expression");
        }
        if (!DataFlow.hasTrueFalseBranches(succEdgeKeys)) {
            throw new IllegalArgumentException("succEdgeKeys does not have true and false branches.");
        }
        BoolItem<FlowItem> results = navigator.navigate(booleanCond, startingItem);
        HashMap<FlowGraph.EdgeKey, FlowItem> m = new HashMap<FlowGraph.EdgeKey, FlowItem>();
        m.put(FlowGraph.EDGE_KEY_TRUE, results.trueItem());
        m.put(FlowGraph.EDGE_KEY_FALSE, results.falseItem());
        for (FlowGraph.EdgeKey e : succEdgeKeys) {
            if (FlowGraph.EDGE_KEY_TRUE.equals(e) || FlowGraph.EDGE_KEY_FALSE.equals(e)) continue;
            m.put(e, startingItem);
        }
        return m;
    }

    protected void dumpFlowGraph(FlowGraph<FlowItem> graph, Term root) {
        String name = StringUtil.getShortNameComponent(this.getClass().getName());
        name = name + flowCounter++;
        String rootName = "";
        if (graph.root() instanceof CodeNode) {
            CodeNode cd = (CodeNode)graph.root();
            rootName = cd.codeInstance().toString();
            if (cd.codeInstance() instanceof MemberInstance) {
                rootName = rootName + " in " + ((MemberInstance)((Object)cd.codeInstance())).container().toString();
            }
        }
        Report.report(2, "digraph DataFlow" + name + " {");
        Report.report(2, "  label=\"Dataflow: " + name + "\\n" + rootName + "\"; fontsize=20; center=true; ratio=auto; size = \"8.5,11\";");
        for (FlowGraph.Peer<FlowItem> p : graph.peers()) {
            Report.report(2, p.hashCode() + " [ label = \"" + StringUtil.escape(p.node.toString()) + "\\n(" + StringUtil.escape(StringUtil.getShortNameComponent(p.node.getClass().getName())) + ")" + (p.path_to_finally.isEmpty() ? "" : StringUtil.escape(p.path_to_finally.toString())) + "\" ];");
            for (FlowGraph.Edge q : p.succs) {
                Report.report(2, q.getTarget().hashCode() + " [ label = \"" + StringUtil.escape(q.getTarget().node.toString()) + " (" + StringUtil.escape(StringUtil.getShortNameComponent(q.getTarget().node.getClass().getName())) + ")" + (q.getTarget().path_to_finally.isEmpty() ? "" : StringUtil.escape(q.getTarget().path_to_finally.toString())) + "\" ];");
                String label = q.getKey().toString();
                label = p.outItems != null ? label + "\\n" + p.outItems.get(q.getKey()) : label + "\\n[no dataflow available]";
                Report.report(2, p.hashCode() + " -> " + q.getTarget().hashCode() + " [label=\"" + label + "\"];");
            }
        }
        Report.report(2, "}");
    }

    @Deprecated
    protected static abstract class ConditionNavigator<FlowItem extends Item> {
        protected ConditionNavigator() {
        }

        public BoolItem<FlowItem> navigate(Expr expr, FlowItem startingItem) {
            if (expr.type().isBoolean()) {
                Unary u;
                if (expr instanceof Binary) {
                    Binary b = (Binary)expr;
                    if (Binary.COND_AND.equals(b.operator()) || Binary.BIT_AND.equals(b.operator())) {
                        BoolItem<FlowItem> leftRes = this.navigate(b.left(), startingItem);
                        FlowItem rightResStart = startingItem;
                        if (Binary.COND_AND.equals(b.operator())) {
                            rightResStart = leftRes.trueItem();
                        }
                        BoolItem<FlowItem> rightRes = this.navigate(b.right(), rightResStart);
                        return this.andResults(leftRes, rightRes, startingItem);
                    }
                    if (Binary.COND_OR.equals(b.operator()) || Binary.BIT_OR.equals(b.operator())) {
                        BoolItem<FlowItem> leftRes = this.navigate(b.left(), startingItem);
                        FlowItem rightResStart = startingItem;
                        if (Binary.COND_OR.equals(b.operator())) {
                            rightResStart = leftRes.falseItem();
                        }
                        BoolItem<FlowItem> rightRes = this.navigate(b.right(), rightResStart);
                        return this.orResults(leftRes, rightRes, startingItem);
                    }
                } else if (expr instanceof Unary && Unary.NOT.equals((u = (Unary)expr).operator())) {
                    BoolItem<FlowItem> res = this.navigate(u.expr(), startingItem);
                    return this.notResult(res);
                }
            }
            return this.handleExpression(expr, startingItem);
        }

        public BoolItem<FlowItem> andResults(BoolItem<FlowItem> left, BoolItem<FlowItem> right, FlowItem startingItem) {
            return new BoolItem<FlowItem>(this.combine(left.trueItem(), right.trueItem()), startingItem);
        }

        public BoolItem<FlowItem> orResults(BoolItem<FlowItem> left, BoolItem<FlowItem> right, FlowItem startingItem) {
            return new BoolItem<FlowItem>(startingItem, this.combine(left.falseItem(), right.falseItem()));
        }

        public BoolItem<FlowItem> notResult(BoolItem<FlowItem> results) {
            return new BoolItem<FlowItem>(results.falseItem(), results.trueItem());
        }

        public abstract FlowItem combine(FlowItem var1, FlowItem var2);

        public abstract BoolItem<FlowItem> handleExpression(Expr var1, FlowItem var2);
    }

    @Deprecated
    protected static class BoolItem<FlowItem extends Item> {
        private FlowItem trueItem;
        private FlowItem falseItem;

        public BoolItem(FlowItem trueItem, FlowItem falseItem) {
            this.trueItem = trueItem;
            this.falseItem = falseItem;
        }

        public FlowItem trueItem() {
            return this.trueItem;
        }

        public FlowItem falseItem() {
            return this.falseItem;
        }

        public String toString() {
            return "[ true: " + this.trueItem + "; false: " + this.falseItem + " ]";
        }
    }

    protected static class Frame<FlowItem extends Item> {
        protected FlowGraph.Peer<FlowItem> peer;
        protected Iterator<FlowGraph.Edge<FlowItem>> edges;

        protected Frame() {
        }

        Frame(FlowGraph.Peer<FlowItem> p, boolean forward) {
            this.peer = p;
            this.edges = forward ? p.succs().iterator() : p.preds().iterator();
        }
    }

    public static abstract class Item {
        public abstract boolean equals(Object var1);

        public abstract int hashCode();
    }

    protected static class FlowGraphSource<FlowItem extends Item> {
        private FlowGraph<FlowItem> flowgraph;
        private CodeNode source;

        FlowGraphSource(FlowGraph<FlowItem> g, CodeDecl s) {
            this(g, (CodeNode)s);
        }

        FlowGraphSource(FlowGraph<FlowItem> g, CodeNode s) {
            this.flowgraph = g;
            this.source = s;
        }

        public FlowGraph<FlowItem> flowGraph() {
            return this.flowgraph;
        }

        public CodeNode source() {
            return this.source;
        }
    }
}

