/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import polyglot.ast.Block;
import polyglot.ast.Catch;
import polyglot.ast.Local;
import polyglot.ast.LocalDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.types.LocalInstance;
import polyglot.util.InternalCompilerError;
import polyglot.util.UniqueID;
import polyglot.visit.NodeVisitor;

public class AlphaRenamer
extends NodeVisitor {
    protected NodeFactory nf;
    protected Stack<Set<String>> setStack;
    protected Map<String, String> renamingMap;
    protected Map<String, LocalInstance> localInstanceMemo;
    protected Set<String> freshVars;
    protected boolean renameCatchFormals;
    protected boolean createNewLocalInstances;

    public AlphaRenamer(NodeFactory nf) {
        this(nf, false);
    }

    public AlphaRenamer(NodeFactory nf, boolean renameCatchFormals) {
        this(nf, renameCatchFormals, false);
    }

    public AlphaRenamer(NodeFactory nf, boolean renameCatchFormals, boolean createNewLocalInstances) {
        super(nf.lang());
        this.nf = nf;
        this.setStack = new Stack();
        this.setStack.push(new HashSet());
        this.renamingMap = new HashMap<String, String>();
        this.localInstanceMemo = new HashMap<String, LocalInstance>();
        this.freshVars = new HashSet<String>();
        this.renameCatchFormals = renameCatchFormals;
        this.createNewLocalInstances = createNewLocalInstances;
    }

    @Override
    public NodeVisitor enter(Node n) {
        if (n instanceof Block) {
            this.setStack.push(new HashSet());
        }
        if (this.renameCatchFormals && n instanceof Catch) {
            Catch c = (Catch)n;
            this.addToRenamingMap(c.formal().name());
        }
        if (n instanceof LocalDecl) {
            LocalDecl l = (LocalDecl)n;
            this.addToRenamingMap(l.name());
        }
        return this;
    }

    protected void addToRenamingMap(String name) {
        if (!this.freshVars.contains(name)) {
            String name_ = UniqueID.newID(name);
            this.freshVars.add(name_);
            this.setStack.peek().add(name);
            this.renamingMap.put(name, name_);
        }
    }

    @Override
    public Node leave(Node old, Node n, NodeVisitor v) {
        if (n instanceof Block) {
            Set<String> s = this.setStack.pop();
            this.renamingMap.keySet().removeAll(s);
            this.localInstanceMemo.keySet().removeAll(s);
            return n;
        }
        if (n instanceof Local) {
            Local l = (Local)n;
            String name = l.name();
            if (!this.renamingMap.containsKey(name)) {
                return n;
            }
            String newName = this.renamingMap.get(name);
            LocalInstance li = l.localInstance();
            if (li != null) {
                li = this.getNewLocalInstance(newName, li);
                l = l.localInstance(li);
            }
            return l.name(newName);
        }
        if (n instanceof LocalDecl) {
            LocalDecl l = (LocalDecl)n;
            String name = l.name();
            if (this.freshVars.contains(name)) {
                return n;
            }
            if (!this.renamingMap.containsKey(name)) {
                throw new InternalCompilerError("Unexpected error encountered while alpha-renaming.");
            }
            String newName = this.renamingMap.get(name);
            LocalInstance li = l.localInstance();
            if (li != null) {
                li = this.getNewLocalInstance(newName, li);
                l = l.localInstance(li);
            }
            return l.name(newName);
        }
        if (n instanceof Catch && this.renameCatchFormals) {
            Catch c = (Catch)n;
            String name = c.formal().name();
            if (this.freshVars.contains(name)) {
                return n;
            }
            if (!this.renamingMap.containsKey(name)) {
                throw new InternalCompilerError("Unexpected error encountered while alpha-renaming.");
            }
            String newName = this.renamingMap.get(name);
            LocalInstance li = c.formal().localInstance();
            if (li != null) {
                li = this.getNewLocalInstance(newName, li);
                c = c.formal(c.formal().localInstance(li));
            }
            return c.formal(c.formal().name(newName));
        }
        return n;
    }

    private LocalInstance getNewLocalInstance(String newName, LocalInstance liOld) {
        LocalInstance liNew = this.localInstanceMemo.get(newName);
        if (liNew == null) {
            if (this.createNewLocalInstances) {
                liNew = liOld.name(newName);
            } else {
                liNew = liOld;
                liNew.setName(newName);
            }
            this.localInstanceMemo.put(newName, liNew);
        }
        return liNew;
    }
}

