/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util.typedump;

import java.io.IOException;
import java.util.HashSet;
import polyglot.frontend.Compiler;
import polyglot.frontend.ExtensionInfo;
import polyglot.main.Options;
import polyglot.main.UsageError;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.OptimalCodeWriter;
import polyglot.util.StdErrorQueue;
import polyglot.util.typedump.TypeDumper;

public class Main {
    public static void main(String[] args) throws IllegalArgumentException, SemanticException {
        String extension = "jl";
        if (args.length == 3 && args[0].equals("-ext")) {
            extension = args[1];
        }
        if (extension == null && args.length != 1 || extension != null && args.length != 3) {
            System.err.println("Usage: polyglot.util.typedump.Main [-ext <extension>] <classname>");
            System.exit(1);
        }
        String className = extension == null ? args[0] : args[2];
        ExtensionInfo extInfo = null;
        String extClassName = "polyglot.ext." + extension + ".ExtensionInfo";
        Class<?> extClass = null;
        try {
            extClass = Class.forName(extClassName);
        }
        catch (ClassNotFoundException e) {
            try {
                extClass = Class.forName(extension);
            }
            catch (ClassNotFoundException e2) {
                System.err.println("Extension " + extension + " not found: could not find class " + extClassName + ".");
                System.err.println(e2.getMessage());
                System.exit(1);
            }
        }
        try {
            extInfo = (ExtensionInfo)extClass.newInstance();
        }
        catch (Exception e) {
            System.err.println("Extension " + extension + " could not be loaded: " + "could not instantiate " + extClassName + ".");
            System.exit(1);
        }
        try {
            Options options;
            Options.global = options = extInfo.getOptions();
            Main.configureOptions(options);
            StdErrorQueue eq = new StdErrorQueue(System.err, 100, extInfo.compilerName());
            new Compiler(extInfo, eq);
            TypeSystem ts = extInfo.typeSystem();
            TypeDumper t = TypeDumper.load(className, ts, extInfo.version());
            OptimalCodeWriter cw = new OptimalCodeWriter(System.out, 100);
            t.dump(cw);
            cw.newline(0);
            try {
                ((CodeWriter)cw).flush();
            }
            catch (IOException exn) {
                System.err.println(exn.getMessage());
            }
        }
        catch (ClassNotFoundException exn) {
            System.err.println("Could not load .class: " + className);
            System.err.println(exn.getMessage());
        }
        catch (NoSuchFieldException exn) {
            System.err.println("Could not reflect jlc fields");
            System.err.println(exn.getMessage());
        }
        catch (SecurityException exn) {
            System.err.println("Security policy error.");
            System.err.println(exn.getMessage());
        }
    }

    private static void configureOptions(Options options) {
        try {
            options.parseCommandLine(new String[]{"-d", ".", "Dummy"}, new HashSet<String>());
        }
        catch (UsageError e) {
            throw new InternalCompilerError(e);
        }
    }
}

