/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import polyglot.util.Transformation;

public final class TransformingIterator<T, U>
implements Iterator<U> {
    protected U next_item;
    protected Iterator<T> current_iter;
    protected int index = 0;
    protected Iterator<T>[] backing_iterators;
    protected Transformation<T, U> transformation;

    public TransformingIterator(Iterator<T> iter, Transformation<T, U> trans) {
        this(new Iterator[]{iter}, trans);
    }

    public TransformingIterator(Collection<Iterator<T>> iters, Transformation<T, U> trans) {
        Iterator[] tmp = new Iterator[]{};
        this.backing_iterators = iters.toArray(tmp);
        this.transformation = trans;
        if (this.backing_iterators.length > 0) {
            this.current_iter = this.backing_iterators[0];
        }
        this.findNextItem();
    }

    public TransformingIterator(Iterator<T>[] iters, Transformation<T, U> trans) {
        this.backing_iterators = (Iterator[])iters.clone();
        this.transformation = trans;
        if (iters.length > 0) {
            this.current_iter = iters[0];
        }
        this.findNextItem();
    }

    @Override
    public U next() {
        U res = this.next_item;
        if (res == null) {
            throw new NoSuchElementException();
        }
        this.findNextItem();
        return res;
    }

    @Override
    public boolean hasNext() {
        return this.next_item != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("TransformingIterator.remove");
    }

    private void findNextItem() {
        while (this.current_iter != null) {
            while (this.current_iter.hasNext()) {
                T o = this.current_iter.next();
                U res = this.transformation.transform(o);
                if (res == Transformation.NOTHING) continue;
                this.next_item = res;
                return;
            }
            ++this.index;
            if (this.index < this.backing_iterators.length) {
                this.current_iter = this.backing_iterators[this.index];
                continue;
            }
            this.current_iter = null;
        }
        this.next_item = null;
    }
}

