/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import polyglot.util.AllowBreak;
import polyglot.util.OCItem;
import polyglot.util.SearchState;

class TextItem
extends OCItem {
    String s;
    int length;
    int[] minBreakLevels = new int[]{0, 0, 0};

    TextItem(String s_, int length_) {
        this.s = s_;
        this.length = length_;
    }

    @Override
    void selfFormat(SearchState s) {
        if (s.findminovf && s.pos + this.length > s.rmargin) {
            s.forward = false;
            s.minovf = s.pos + this.length - s.rmargin;
        } else {
            s.pos += this.length;
        }
    }

    @Override
    int sendOutput(PrintWriter o, int lmargin, int pos, Map<AllowBreak, Boolean> brkAssignment) {
        o.write(this.s);
        return pos + this.length;
    }

    @Override
    int[] minBreakLevels() {
        return this.minBreakLevels;
    }

    @Override
    String selfToString() {
        StringWriter sw = new StringWriter();
        for (int i = 0; i < this.s.length(); ++i) {
            char c = this.s.charAt(i);
            if (c == ' ') {
                sw.write("\\ ");
                continue;
            }
            sw.write(c);
        }
        return sw.toString();
    }

    public void appendTextItem(TextItem item) {
        this.s = this.s + item.s;
        this.length += item.length;
    }
}

