/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;

public class SubtypeSet
implements Set<Type> {
    protected List<Type> v;
    protected TypeSystem ts;
    protected Type topType;

    public SubtypeSet(TypeSystem ts) {
        this(ts.Object());
    }

    public SubtypeSet(Type top) {
        this.v = new ArrayList<Type>();
        this.ts = top.typeSystem();
        this.topType = top;
    }

    public SubtypeSet(SubtypeSet s) {
        this.v = new ArrayList<Type>(s.v);
        this.ts = s.ts;
        this.topType = s.topType;
    }

    public SubtypeSet(TypeSystem ts, Collection<? extends Type> c) {
        this(ts);
        this.addAll(c);
    }

    public SubtypeSet(Type top, Collection<? extends Type> c) {
        this(top);
        this.addAll(c);
    }

    @Override
    public boolean add(Type type) {
        if (type == null) {
            return false;
        }
        if (this.ts.isSubtype(type, this.topType)) {
            boolean haveToAdd = true;
            Iterator<Type> i = this.v.iterator();
            while (i.hasNext()) {
                Type t = i.next();
                if (this.ts.descendsFrom(t, type)) {
                    i.remove();
                }
                if (!this.ts.isSubtype(type, t)) continue;
                haveToAdd = false;
                break;
            }
            if (haveToAdd) {
                this.v.add(type);
            }
            return haveToAdd;
        }
        throw new InternalCompilerError("Can only add " + this.topType + "s to the set. Got a " + type);
    }

    @Override
    public boolean addAll(Collection<? extends Type> c) {
        if (c == null) {
            return false;
        }
        boolean changed = false;
        for (Type type : c) {
            changed |= this.add(type);
        }
        return changed;
    }

    @Override
    public void clear() {
        this.v.clear();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Type) {
            Type type = (Type)o;
            for (Type t : this.v) {
                if (!this.ts.isSubtype(type, t)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsSubtype(Type type) {
        for (Type t : this.v) {
            if (!this.ts.isSubtype(type, t) && !this.ts.isSubtype(t, type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.v.isEmpty();
    }

    @Override
    public Iterator<Type> iterator() {
        return this.v.iterator();
    }

    @Override
    public boolean remove(Object o) {
        Type type = (Type)o;
        boolean removed = false;
        Iterator<Type> i = this.v.iterator();
        while (i.hasNext()) {
            Type t = i.next();
            if (!this.ts.isSubtype(t, type)) continue;
            removed = true;
            i.remove();
        }
        return removed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            changed |= this.remove(o);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        ListIterator<Type> itr = this.v.listIterator();
        while (itr.hasNext()) {
            Type t = itr.next();
            Type glb = null;
            for (Object o : c) {
                if (!(o instanceof Type)) continue;
                Type type = (Type)o;
                if (glb == null) {
                    if (this.ts.isSubtype(type, t)) {
                        glb = type;
                        continue;
                    }
                    if (!this.ts.isSubtype(t, type)) continue;
                    glb = t;
                    continue;
                }
                if (!this.ts.isSubtype(type, glb)) continue;
                glb = type;
            }
            if (glb == t) continue;
            changed = true;
            if (glb == null) {
                itr.remove();
                continue;
            }
            itr.set(glb);
        }
        return changed;
    }

    @Override
    public int size() {
        return this.v.size();
    }

    @Override
    public Object[] toArray() {
        return this.v.toArray();
    }

    @Override
    public <U> U[] toArray(U[] a) {
        return this.v.toArray(a);
    }

    public String toString() {
        return this.v.toString();
    }
}

