/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.io.Externalizable;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Comparator;
import java.util.TreeSet;

public class SerialVersionUID
implements Serializable {
    private static final long serialVersionUID = SerialVersionUID.generate();

    public static long generate() {
        StackTraceElement caller = new Exception().getStackTrace()[1];
        try {
            Class<?> clazz = Class.forName(caller.getClassName());
            return SerialVersionUID.generate(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new Error(e);
        }
    }

    public static long generate(Class<?> clazz) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] className = clazz.getName().getBytes("UTF-8");
            md.update(className);
            Class<?> superClass = clazz.getSuperclass();
            if (!Object.class.equals(superClass)) {
                ObjectStreamClass osc = ObjectStreamClass.lookup(superClass);
                md.update(SerialVersionUID.getBytes(osc.getSerialVersionUID()));
            }
            md.update((byte)(clazz.isEnum() ? 1 : 0));
            Class<?>[] interfaces = clazz.getInterfaces();
            boolean serializable = false;
            boolean externalizable = false;
            for (Class<?> iface : interfaces) {
                if (!serializable && iface.equals(Serializable.class)) {
                    serializable = true;
                }
                if (externalizable || !iface.equals(Externalizable.class)) continue;
                externalizable = true;
            }
            md.update((byte)(serializable ? 1 : 0));
            md.update((byte)(externalizable ? 1 : 0));
            TreeSet<Field> fields = new TreeSet<Field>(new Comparator<Field>(){

                @Override
                public int compare(Field f1, Field f2) {
                    return f1.getName().compareTo(f2.getName());
                }
            });
            for (Field field : clazz.getDeclaredFields()) {
                fields.add(field);
            }
            for (Field field : fields) {
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
                md.update(field.getName().getBytes("UTF-8"));
                Class<?> fieldType = field.getClass();
                if (!fieldType.isPrimitive()) continue;
                md.update(fieldType.getName().getBytes("UTF-8"));
            }
            try {
                clazz.getDeclaredMethod("writeObject", ObjectOutputStream.class);
                try {
                    Field writeObjectVersion = clazz.getDeclaredField("writeObjectVersionUID");
                    writeObjectVersion.setAccessible(true);
                    long ver = writeObjectVersion.getLong(clazz);
                    md.update(SerialVersionUID.getBytes(ver));
                }
                catch (NoSuchFieldException e) {
                    throw new Error(clazz + " defines writeObject(ObjectOutputStream) " + "but not writeObjectVersionUID");
                }
                catch (IllegalAccessException e) {
                    throw new Error(e);
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            try {
                clazz.getDeclaredMethod("readObject", ObjectInputStream.class);
                try {
                    Field readObjectVersion = clazz.getDeclaredField("readObjectVersionUID");
                    readObjectVersion.setAccessible(true);
                    long ver = readObjectVersion.getLong(clazz);
                    md.update(SerialVersionUID.getBytes(ver));
                }
                catch (NoSuchFieldException e) {
                    throw new Error(clazz + " defines readObject(ObjectInputStream) " + "but not readObjectVersionUID");
                }
                catch (IllegalAccessException e) {
                    throw new Error(e);
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            try {
                clazz.getDeclaredMethod("writeReplace", new Class[0]);
                try {
                    Field writeReplaceVersion = clazz.getDeclaredField("writeReplaceVersionUID");
                    writeReplaceVersion.setAccessible(true);
                    long ver = writeReplaceVersion.getLong(clazz);
                    md.update(SerialVersionUID.getBytes(ver));
                }
                catch (NoSuchFieldException e) {
                    throw new Error(clazz + " defines writeReplace() " + "but not writeReplaceVersionUID");
                }
                catch (IllegalAccessException e) {
                    throw new Error(e);
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            try {
                clazz.getDeclaredMethod("readResolve", new Class[0]);
                try {
                    Field readResolveVersion = clazz.getDeclaredField("readResolveVersionUID");
                    readResolveVersion.setAccessible(true);
                    long ver = readResolveVersion.getLong(clazz);
                    md.update(SerialVersionUID.getBytes(ver));
                }
                catch (NoSuchFieldException e) {
                    throw new Error(clazz + " defines readResolve() " + "but not readResolveVersionUID");
                }
                catch (IllegalAccessException e) {
                    throw new Error(e);
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            byte[] md5 = md.digest();
            return SerialVersionUID.longAt(md5, 0) ^ SerialVersionUID.longAt(md5, 8);
        }
        catch (UnsupportedEncodingException | IllegalArgumentException | SecurityException | NoSuchAlgorithmException e) {
            throw new Error(e);
        }
    }

    public static final long longAt(byte[] data, int pos) {
        return (long)(data[pos + 0] & 0xFF) << 56 | (long)(data[pos + 1] & 0xFF) << 48 | (long)(data[pos + 2] & 0xFF) << 40 | (long)(data[pos + 3] & 0xFF) << 32 | (long)(data[pos + 4] & 0xFF) << 24 | (long)(data[pos + 5] & 0xFF) << 16 | (long)(data[pos + 6] & 0xFF) << 8 | (long)(data[pos + 7] & 0xFF) << 0;
    }

    public static final byte[] getBytes(long value) {
        byte[] data = new byte[]{(byte)(0xFFL & value >> 56), (byte)(0xFFL & value >> 48), (byte)(0xFFL & value >> 40), (byte)(0xFFL & value >> 32), (byte)(0xFFL & value >> 24), (byte)(0xFFL & value >> 16), (byte)(0xFFL & value >> 8), (byte)(0xFFL & value >> 0)};
        return data;
    }
}

