/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.io.Serializable;
import polyglot.main.Options;

public class Position
implements Serializable {
    static final long serialVersionUID = -4588386982624074261L;
    private String path;
    private String file;
    private String info;
    private int line;
    private int column;
    private int endLine;
    private int endColumn;
    private boolean compilerGenerated = false;
    private int offset;
    private int endOffset;
    public static final int UNKNOWN = -1;
    public static final int END_UNUSED = -2;
    public static final Position COMPILER_GENERATED = new Position("Compiler Generated", true);
    public static final int THIS_METHOD = 1;
    public static final int CALLER = 2;

    public static Position compilerGenerated(int depth) {
        if (!Options.global.precise_compiler_generated_positions) {
            return COMPILER_GENERATED;
        }
        StackTraceElement[] stack = new Exception().getStackTrace();
        if (depth < stack.length) {
            return new Position(stack[depth].getFileName() + " (compiler generated)", stack[depth].getLineNumber(), true);
        }
        return COMPILER_GENERATED;
    }

    public static Position compilerGenerated() {
        return Position.compilerGenerated(2);
    }

    public static Position compilerGenerated(String info) {
        Position pos = Position.compilerGenerated(2);
        pos.setInfo(info);
        return pos;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public boolean isCompilerGenerated() {
        return this.compilerGenerated;
    }

    protected Position() {
        this.endLine = 0;
        this.line = 0;
        this.endColumn = 0;
        this.column = 0;
        this.endOffset = 0;
        this.offset = 0;
    }

    public Position(String desc, boolean compilerGenerated) {
        this(null, desc, -1, -1);
        this.compilerGenerated = compilerGenerated;
    }

    public Position(String desc, int line, boolean compilerGenerated) {
        this(null, desc, line, -1);
        this.compilerGenerated = compilerGenerated;
    }

    public Position(String path, String file) {
        this(path, file, -1, -1);
    }

    public Position(String path, String file, int line) {
        this(path, file, line, -1);
    }

    public Position(String path, String file, int line, int column) {
        this(path, file, line, column, -2, -2);
    }

    public Position(String path, String file, int line, int column, int endLine, int endColumn) {
        this(path, file, line, column, endLine, endColumn, 0, 0);
    }

    public Position(String path, String file, int line, int column, int endLine, int endColumn, int offset, int endOffset) {
        this.file = file;
        this.path = path;
        this.line = line;
        this.column = column;
        this.endLine = endLine;
        this.endColumn = endColumn;
        this.offset = offset;
        this.endOffset = endOffset;
    }

    public Position(Position start, Position end) {
        this(start.path(), start.file(), start.line, start.column, end == null ? start.endLine : end.endLine, end == null ? start.endColumn : end.endColumn, start.offset, end == null ? start.endOffset : end.endOffset);
    }

    public Position truncateEnd(int len) {
        if (this == COMPILER_GENERATED) {
            return this;
        }
        int eo = this.endOffset;
        int el = this.endLine;
        int ec = this.endColumn;
        eo = eo >= this.offset + len ? (eo -= len) : this.offset;
        if (this.line == el) {
            ec = ec >= this.column + len ? (ec -= len) : this.column;
        } else if (ec >= len) {
            ec -= len;
        } else {
            el = this.line;
            ec = this.column;
        }
        return new Position(this.path, this.file, this.line, this.column, el, ec, this.offset, eo);
    }

    public Position startOf() {
        if (this == COMPILER_GENERATED) {
            return this;
        }
        return new Position(this.path, this.file, this.line, this.column, this.line, this.column, this.offset, this.offset);
    }

    public Position endOf() {
        if (this == COMPILER_GENERATED) {
            return this;
        }
        return new Position(this.path, this.file, this.endLine, this.endColumn, this.endLine, this.endColumn, this.endOffset, this.endOffset);
    }

    public int line() {
        return this.line;
    }

    public int column() {
        return this.column;
    }

    public int endLine() {
        if (this.endLine == -1 || this.line != -1 && this.endLine < this.line) {
            return this.line;
        }
        return this.endLine;
    }

    public int endColumn() {
        if (this.endColumn == -1 || this.column != -1 && this.endLine() == this.line() && this.endColumn < this.column) {
            return this.column;
        }
        return this.endColumn;
    }

    public int offset() {
        return this.offset;
    }

    public int endOffset() {
        if (this.endOffset == -1 || this.offset != -1 && this.endOffset < this.offset) {
            return this.offset;
        }
        return this.endOffset;
    }

    public String file() {
        return this.file;
    }

    public String path() {
        return this.path;
    }

    public String nameAndLineString() {
        String s = this.path;
        if (s == null || s.length() == 0) {
            s = this.file;
        }
        if (s == null) {
            s = "unknown file";
        }
        if (this.line != -1) {
            s = s + ":" + this.line;
            if (this.endLine != this.line && this.endLine != -1 && this.endLine != -2) {
                s = s + "-" + this.endLine;
            }
        }
        if (this.info != null) {
            s = s + " (" + this.info + ")";
        }
        return s;
    }

    public String toString() {
        String s = this.path;
        if (s == null) {
            s = this.file;
        }
        if (s == null) {
            s = "unknown file";
        }
        if (this.line != -1) {
            s = s + ":" + this.line;
            if (this.column != -1) {
                s = s + "," + this.column;
                if (this.line == this.endLine && this.endColumn != -1 && this.endColumn != -2) {
                    s = s + "-" + this.endColumn;
                }
                if (this.line != this.endLine && this.endColumn != -1 && this.endColumn != -2) {
                    s = s + "-" + this.endLine + "," + this.endColumn;
                }
            }
        }
        if (this.info != null) {
            s = s + " (" + this.info + ")";
        }
        return s;
    }

    private static boolean isComparable(Position pos1, Position pos2) {
        if (pos1 == null || pos2 == null) {
            return false;
        }
        if (pos1.compilerGenerated || pos2.compilerGenerated) {
            return false;
        }
        if (pos1.file == null || pos2.file == null || !pos1.file.equals(pos2.file)) {
            return false;
        }
        if (pos1.path == null || pos2.path == null || !pos1.path.equals(pos2.path)) {
            return false;
        }
        if (pos1.line == -1 || pos2.line == -1) {
            return false;
        }
        if (pos1.column == -1 || pos2.column == -1) {
            return false;
        }
        if (pos1.endLine == -1 || pos2.endLine == -1) {
            return false;
        }
        return pos1.endColumn != -1 && pos2.endColumn != -1;
    }

    public static Position first(Position pos1, Position pos2) {
        if (!Position.isComparable(pos1, pos2)) {
            return null;
        }
        if (pos1.line < pos2.line) {
            return pos1;
        }
        if (pos1.line == pos2.line && pos1.column <= pos2.column) {
            return pos1;
        }
        return pos2;
    }

    public static Position last(Position pos1, Position pos2) {
        if (!Position.isComparable(pos1, pos2)) {
            return null;
        }
        if (pos1.endLine > pos2.endLine) {
            return pos1;
        }
        if (pos1.endLine == pos2.endLine && pos1.endColumn >= pos2.endColumn) {
            return pos1;
        }
        return pos2;
    }
}

