/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import polyglot.util.AllowBreak;
import polyglot.util.BlockItem;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Newline;
import polyglot.util.OCItem;
import polyglot.util.TextItem;

public class OptimalCodeWriter
extends CodeWriter {
    protected List<BlockItem> blockStack = new LinkedList<BlockItem>();
    protected BlockItem input;
    protected BlockItem current;
    protected static OCItem top;
    protected PrintWriter output;
    protected int width;
    protected static int format_calls;
    public static final boolean debug = false;
    public static final boolean showInput = false;
    public static final boolean visualize = false;
    public static final boolean precompute = true;
    protected int trace_indent = 0;

    public OptimalCodeWriter(OutputStream o, int width_) {
        this(new PrintWriter(new OutputStreamWriter(o)), width_);
    }

    public OptimalCodeWriter(PrintWriter o, int width_) {
        this.output = o;
        this.width = width_;
        this.current = this.input = new BlockItem(0);
    }

    public OptimalCodeWriter(Writer o, int width_) {
        this(new PrintWriter(o), width_);
    }

    @Override
    public void write(String s) {
        if (s.length() > 0) {
            this.write(s, s.length());
        }
    }

    @Override
    public void write(String s, int length) {
        this.current.add(new TextItem(s, length));
    }

    @Override
    public void begin(int n) {
        BlockItem b = new BlockItem(n);
        this.current.add(b);
        this.blockStack.add(0, this.current);
        this.current = b;
    }

    @Override
    public void end() {
        if (this.blockStack.isEmpty()) {
            throw new InternalCompilerError("Mismatched blocks");
        }
        this.current = this.blockStack.remove(0);
    }

    @Override
    public void allowBreak(int n, int level, String alt, int altlen) {
        this.current.add(new AllowBreak(n, level, alt, altlen, false));
    }

    @Override
    public void unifiedBreak(int n, int level, String alt, int altlen) {
        this.current.add(new AllowBreak(n, level, alt, altlen, true));
    }

    @Override
    public void newline(int n, int level) {
        this.current.add(new Newline(n, level));
    }

    @Override
    public boolean flush() throws IOException {
        return this.flush(true);
    }

    @Override
    public boolean flush(boolean format) throws IOException {
        if (!this.blockStack.isEmpty()) {
            throw new InternalCompilerError("Mismatched blocks");
        }
        boolean success = true;
        format_calls = 0;
        Map<AllowBreak, Boolean> brkAssignment = format ? OCItem.format(this.input, this.width) : Collections.emptyMap();
        this.input.sendOutput(this.output, 0, 0, brkAssignment);
        this.output.flush();
        this.current = this.input = new BlockItem(0);
        return success;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.output.close();
    }

    @Override
    public String toString() {
        return this.input.toString();
    }

    void incIndent() {
        ++this.trace_indent;
    }

    void decIndent() {
        --this.trace_indent;
        if (this.trace_indent < 0) {
            throw new RuntimeException("unmatched end");
        }
    }

    void trace(String s) {
        for (int i = 0; i < this.trace_indent; ++i) {
            System.out.print(" ");
        }
        System.out.println(s);
    }

    static {
        format_calls = 0;
    }
}

