/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import polyglot.util.CodeWriter;
import polyglot.util.StringUtil;

public class ObjectDumper {
    CodeWriter w;
    int modifiersMask;

    public ObjectDumper(CodeWriter w) {
        this(w, 136);
    }

    public ObjectDumper(CodeWriter w, int modifiersMask) {
        this.w = w;
        this.modifiersMask = modifiersMask;
    }

    public void dump(Object o) {
        HashSet<Object> cache = new HashSet<Object>();
        this.w.write("(");
        this.dumpObject(o, cache);
        this.w.write(")");
        this.w.newline(0);
        try {
            this.w.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void dumpObject(Object obj, Set<Object> cache) {
        if (obj == null) {
            this.w.write("null");
            return;
        }
        this.w.write(StringUtil.getShortNameComponent(obj.getClass().getName()));
        if (cache.contains(obj)) {
            return;
        }
        cache.add(obj);
        this.w.allowBreak(1, " ");
        this.w.begin(0);
        try {
            AccessibleObject[] fields = obj.getClass().getDeclaredFields();
            AccessibleObject.setAccessible(fields, true);
            for (AccessibleObject field : fields) {
                if ((((Field)field).getModifiers() & this.modifiersMask) != 0) continue;
                this.w.write("(");
                this.w.write(((Field)field).getName());
                this.w.allowBreak(1, " ");
                try {
                    Object o = ((Field)field).get(obj);
                    this.dumpObject(o, cache);
                }
                catch (IllegalAccessException exn) {
                    this.w.write("##[" + exn.getMessage() + "]");
                }
                this.w.write(")");
                this.w.newline(0);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.w.end();
    }
}

