/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.io.PrintWriter;
import java.util.Map;
import polyglot.util.AllowBreak;
import polyglot.util.BlockItem;
import polyglot.util.OptimalCodeWriter;
import polyglot.util.SearchState;

abstract class OCItem {
    OCItem next = null;

    protected OCItem() {
    }

    static Map<AllowBreak, Boolean> format(OCItem it, int rmargin) {
        SearchState s = new SearchState(0, rmargin, 0, 0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        OCItem cur = it;
        while (cur != null) {
            ++OptimalCodeWriter.format_calls;
            cur.selfFormat(s);
            if (s.forward) {
                if (cur instanceof BlockItem) {
                    BlockItem bi = (BlockItem)cur;
                    cur = bi.first;
                } else {
                    cur = cur.next;
                }
                while (cur == null && !s.blks.isEmpty()) {
                    cur = s.popBlock().next;
                }
                continue;
            }
            SearchState prev = s.prevBreak;
            cur = prev.it;
            s.lmargin = prev.lmargin;
            s.rmargin = prev.rmargin;
            s.pos = prev.pos;
            s.minbr = prev.minbr;
            s.minbu = prev.minbu;
            s.maxbr = prev.maxbr;
            s.maxbi = prev.maxbi;
            s.blks = prev.blks;
            s.lmargins = prev.lmargins;
            s.rmargins = prev.rmargins;
            s.minbrs = prev.minbrs;
            s.minbus = prev.minbus;
            s.maxbrs = prev.maxbrs;
            s.maxbis = prev.maxbis;
        }
        return s.brkAssignment;
    }

    abstract void selfFormat(SearchState var1);

    abstract int sendOutput(PrintWriter var1, int var2, int var3, Map<AllowBreak, Boolean> var4);

    public String summarize(String s) {
        if (s.length() <= 79) {
            return s;
        }
        return s.substring(0, 76) + "...";
    }

    public String toString() {
        if (this.next == null) {
            return this.summarize(this.selfToString());
        }
        return this.summarize(this.selfToString() + this.next.toString());
    }

    abstract String selfToString();

    abstract int[] minBreakLevels();
}

