/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import polyglot.util.AllowBreak;
import polyglot.util.InternalCompilerError;
import polyglot.util.SearchState;

class Newline
extends AllowBreak {
    int[] minBreakLevels;

    Newline(int n, int level) {
        super(n, level, "\n", 0, true);
        this.minBreakLevels = new int[]{this.level, this.level > 0 ? this.level - 1 : 0, this.level};
    }

    @Override
    void selfFormat(SearchState s) {
        if (!this.canBreak(s.maxbr)) {
            throw new InternalCompilerError("Newline cannot be broken.");
        }
        s.pos = s.lmargin + this.indent;
        if (s.minbr < this.level) {
            s.minbr = this.level - 1;
        }
        if (this.unified && s.minbu < this.level) {
            s.minbu = this.level;
        }
    }

    @Override
    boolean canLeaveUnbroken(int minLevel, int minLevelUnified) {
        return false;
    }

    @Override
    String selfToString() {
        if (this.indent == 0) {
            return "\\n";
        }
        return "\\n[" + this.indent + "]";
    }

    @Override
    int[] minBreakLevels() {
        return this.minBreakLevels;
    }
}

