/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import polyglot.util.ConcatenatedIterator;
import polyglot.util.FilteringIterator;
import polyglot.util.NilMap;
import polyglot.util.Predicate;

public class NestedMap<K, V>
extends AbstractMap<K, V> {
    private HashMap<K, V> myMap;
    private int nShadowed;
    private Set<Map.Entry<K, V>> setView;
    private Map<K, V> superMap;
    private Predicate<Map.Entry<K, V>> entryKeyNotInMyMap = new Predicate<Map.Entry<K, V>>(){

        @Override
        public boolean isTrue(Map.Entry<K, V> ent) {
            return !NestedMap.this.myMap.containsKey(ent.getKey());
        }
    };
    private Predicate<K> keyNotInMyMap = new Predicate<K>(){

        @Override
        public boolean isTrue(K o) {
            return !NestedMap.this.myMap.containsKey(o);
        }
    };

    public NestedMap(Map<K, V> containing) {
        this.superMap = containing == null ? NilMap.emptyMap() : containing;
        this.myMap = new HashMap();
        this.setView = new EntrySet();
        this.nShadowed = 0;
    }

    public Map<K, V> getContainingMap() {
        return this.superMap instanceof NilMap ? null : this.superMap;
    }

    public void release(Object key) {
        this.myMap.remove(key);
    }

    public Map<K, V> getInnerMap() {
        return this.myMap;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.setView;
    }

    @Override
    public int size() {
        return this.superMap.size() + this.myMap.size() - this.nShadowed;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.myMap.containsKey(key) || this.superMap.containsKey(key);
    }

    @Override
    public V get(Object key) {
        if (this.myMap.containsKey(key)) {
            return this.myMap.get(key);
        }
        return this.superMap.get(key);
    }

    @Override
    public V put(K key, V value) {
        if (this.myMap.containsKey(key)) {
            return this.myMap.put(key, value);
        }
        V oldV = this.superMap.get(key);
        this.myMap.put(key, value);
        ++this.nShadowed;
        return oldV;
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException("Remove from NestedMap");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Clear in NestedMap");
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new ConcatenatedIterator(NestedMap.this.myMap.entrySet().iterator(), new FilteringIterator(NestedMap.this.superMap.entrySet(), NestedMap.this.entryKeyNotInMyMap));
        }

        @Override
        public int size() {
            return NestedMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry ent = (Map.Entry)o;
            Object entKey = ent.getKey();
            Object entVal = ent.getValue();
            if (entVal != null) {
                Object val = NestedMap.this.get(entKey);
                return val != null && val.equals(entVal);
            }
            return NestedMap.this.containsKey(entKey) && NestedMap.this.get(entKey) == null;
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("Remove from NestedMap.entrySet");
        }
    }

    public final class KeySet
    extends AbstractSet<K> {
        @Override
        public Iterator<K> iterator() {
            return new ConcatenatedIterator(NestedMap.this.myMap.keySet().iterator(), new FilteringIterator(NestedMap.this.superMap.keySet(), NestedMap.this.keyNotInMyMap));
        }

        @Override
        public int size() {
            return NestedMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return NestedMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("Remove from NestedMap.keySet");
        }
    }
}

