/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import polyglot.util.Transformation;
import polyglot.util.TransformingList;

public class CachingTransformingList<T, U>
extends TransformingList<T, U> {
    protected ArrayList<U> cache;

    public CachingTransformingList(Collection<? extends T> underlying, Transformation<T, U> trans) {
        this((List<? extends T>)new ArrayList<T>(underlying), (Transformation<? extends T, U>)trans);
    }

    public CachingTransformingList(List<T> underlying, Transformation<T, U> trans) {
        super(underlying, trans);
        this.cache = new ArrayList<Object>(Collections.nCopies(underlying.size(), null));
    }

    @Override
    public U get(int index) {
        U o = this.cache.get(index);
        if (o == null) {
            o = this.trans.transform(this.underlying.get(index));
            this.cache.set(index, o);
        }
        return o;
    }
}

