/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.io.PrintWriter;
import java.util.Map;
import polyglot.util.AllowBreak;
import polyglot.util.OCItem;
import polyglot.util.SearchState;
import polyglot.util.TextItem;

class BlockItem
extends OCItem {
    OCItem first = null;
    OCItem last = null;
    int indent;
    int[] minBreakLevels = null;

    BlockItem(int indent_) {
        this.indent = indent_;
    }

    void add(OCItem it) {
        if (this.first == null) {
            this.first = it;
        } else {
            if (it instanceof TextItem && this.last instanceof TextItem) {
                TextItem lasts = (TextItem)this.last;
                lasts.appendTextItem((TextItem)it);
                return;
            }
            this.last.next = it;
        }
        this.last = it;
    }

    @Override
    void selfFormat(SearchState s) {
        s.pushBlock(this);
        s.lmargin = s.pos + this.indent;
        s.minbr = this.minBreakLevels()[3];
        s.minbu = this.minBreakLevels()[4];
        s.maxbr = s.maxbi;
    }

    @Override
    int sendOutput(PrintWriter o, int lmargin, int pos, Map<AllowBreak, Boolean> brkAssignment) {
        lmargin = pos + this.indent;
        OCItem it = this.first;
        while (it != null) {
            pos = it.sendOutput(o, lmargin, pos, brkAssignment);
            it = it.next;
        }
        return pos;
    }

    @Override
    int[] minBreakLevels() {
        if (this.minBreakLevels == null) {
            this.minBreakLevels = new int[]{0, 0, 0, 0, 0};
            OCItem it = this.first;
            while (it != null) {
                int[] mbls = it.minBreakLevels();
                if (this.minBreakLevels[2] < mbls[0]) {
                    this.minBreakLevels[2] = mbls[0];
                }
                if (this.minBreakLevels[3] < mbls[1]) {
                    this.minBreakLevels[3] = mbls[1];
                }
                if (this.minBreakLevels[4] < mbls[2]) {
                    this.minBreakLevels[4] = mbls[2];
                }
                it = it.next;
            }
            this.minBreakLevels[0] = this.minBreakLevels[1] = this.minBreakLevels[2];
        }
        return this.minBreakLevels;
    }

    @Override
    String selfToString() {
        if (this.indent == 0) {
            return "[" + this.first + "]";
        }
        return "[" + this.indent + this.first + "]";
    }
}

