/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import polyglot.util.ConsList;
import polyglot.util.InternalCompilerError;
import polyglot.util.OCItem;
import polyglot.util.Pair;
import polyglot.util.SearchState;

class AllowBreak
extends OCItem {
    final int indent;
    final int level;
    final boolean unified;
    final String alt;
    final int altlen;
    Map<Integer, Map<Integer, Pair<Integer, ConsList<Boolean>>>> cache = new HashMap<Integer, Map<Integer, Pair<Integer, ConsList<Boolean>>>>();
    int minovf;
    ConsList<Boolean> afterBrkAssignment;
    int[] minBreakLevels = new int[]{0, 0, 0};

    AllowBreak(int n_, int level_, String alt_, int altlen_, boolean u) {
        this.indent = n_;
        this.alt = alt_;
        this.altlen = altlen_;
        this.level = level_;
        this.unified = u;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void selfFormat(SearchState s) {
        boolean assignment;
        Map<Integer, Pair<Integer, ConsList<Boolean>>> brCache;
        boolean backtrack = false;
        boolean findminovf = false;
        if (s.forward) {
            if (s.findminovf && this.cache.containsKey(s.maxbr) && (brCache = this.cache.get(s.maxbr)).containsKey(s.pos)) {
                Pair<Integer, ConsList<Boolean>> result = brCache.get(s.pos);
                s.forward = false;
                s.minovf = result.part1();
                s.afterBrkAssignment = result.part2();
                return;
            }
            if (s.afterBrkAssignment.length() > 0) {
                assignment = (Boolean)s.afterBrkAssignment.elem;
                s.afterBrkAssignment = s.afterBrkAssignment.next;
            } else if (this.canLeaveUnbroken(s.minbr, s.minbu) && s.pos + this.altlen <= s.rmargin) {
                assignment = false;
                findminovf = true;
            } else if (this.canBreak(s.maxbr)) {
                assignment = true;
                findminovf = s.findminovf;
            } else {
                if (!this.canLeaveUnbroken(s.minbr, s.minbu)) throw new InternalCompilerError("Could not either break or not break." + this);
                assignment = false;
                if (s.findminovf) {
                    backtrack = true;
                    s.minovf = s.pos + this.altlen - s.rmargin;
                }
            }
        } else {
            s.forward = true;
            if (!s.brkAssignment.get(this).booleanValue() && this.canBreak(s.maxbr)) {
                this.minovf = s.minovf;
                this.afterBrkAssignment = s.afterBrkAssignment;
                s.afterBrkAssignment = ConsList.empty();
                assignment = true;
            } else {
                if (this.afterBrkAssignment != null) {
                    if (this.afterBrkAssignment.length() > s.afterBrkAssignment.length() || this.afterBrkAssignment.length() == s.afterBrkAssignment.length() && this.minovf <= s.minovf) {
                        assignment = false;
                        s.minovf = this.minovf;
                        s.afterBrkAssignment = this.afterBrkAssignment;
                    } else {
                        assignment = true;
                    }
                } else {
                    assignment = this.canBreak(s.maxbr);
                }
                SearchState prev = s.prevBreak;
                s.prevBreak = prev.prevBreak;
                if (prev.findminovf) {
                    backtrack = true;
                } else {
                    s.findminovf = false;
                }
            }
        }
        if (backtrack) {
            this.afterBrkAssignment = null;
            s.forward = false;
            s.brkAssignment.remove(this);
            s.afterBrkAssignment = ConsList.cons(assignment, s.afterBrkAssignment);
            if (this.cache.containsKey(s.maxbr)) {
                brCache = this.cache.get(s.maxbr);
            } else {
                brCache = new HashMap<Integer, Pair<Integer, ConsList<Boolean>>>();
                this.cache.put(s.maxbr, brCache);
            }
            Pair<Integer, ConsList<Boolean>> result = new Pair<Integer, ConsList<Boolean>>(s.minovf, s.afterBrkAssignment);
            brCache.put(s.pos, result);
            return;
        } else {
            if (findminovf) {
                s.it = this;
                s.prevBreak = s.copy();
                s.findminovf = true;
                s.minovf = 0;
            }
            s.brkAssignment.put(this, assignment);
            if (assignment) {
                s.pos = s.lmargin + this.indent;
                if (s.minbr < this.level) {
                    s.minbr = this.level - 1;
                }
                if (!this.unified || s.minbu >= this.level) return;
                s.minbu = this.level;
                return;
            } else {
                s.pos += this.altlen;
                if (s.maxbr >= this.level) {
                    s.maxbr = this.unified ? this.level - 1 : this.level;
                }
                if (s.maxbi < this.level) return;
                s.maxbi = this.level - 1;
            }
        }
    }

    @Override
    int sendOutput(PrintWriter o, int lmargin, int pos, Map<AllowBreak, Boolean> brkAssignment) {
        if (brkAssignment.containsKey(this) && !brkAssignment.get(this).booleanValue()) {
            o.print(this.alt);
            return pos + this.altlen;
        }
        o.println();
        for (int i = 0; i < lmargin + this.indent; ++i) {
            o.print(" ");
        }
        return lmargin + this.indent;
    }

    boolean canBreak(int maxb) {
        return this.level <= maxb;
    }

    boolean canLeaveUnbroken(int minLevel, int minLevelUnified) {
        return this.level > minLevelUnified || !this.unified && this.level > minLevel;
    }

    @Override
    int[] minBreakLevels() {
        return this.minBreakLevels;
    }

    @Override
    String selfToString() {
        String result = this.unified ? "@<" : "<";
        result = result + this.level + ">";
        if (this.indent == 0) {
            return result + " ";
        }
        return result + "^" + this.indent;
    }
}

