/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import polyglot.util.ErrorInfo;
import polyglot.util.ErrorLimitError;
import polyglot.util.ErrorQueue;
import polyglot.util.Position;

public abstract class AbstractErrorQueue
implements ErrorQueue {
    protected boolean flushed;
    protected int errorCount = 0;
    protected final int limit;
    protected final String name;

    public AbstractErrorQueue(int limit, String name) {
        this.limit = limit;
        this.name = name;
        this.flushed = true;
    }

    @Override
    public final void enqueue(int type, String message) {
        this.enqueue(type, message, null);
    }

    @Override
    public final void enqueue(int type, String message, Position position) {
        this.enqueue(new ErrorInfo(type, message, position));
    }

    @Override
    public final void enqueue(ErrorInfo e) {
        if (e.getErrorKind() != 0 && e.getErrorKind() != 7) {
            ++this.errorCount;
        }
        this.flushed = false;
        this.displayError(e);
        if (this.errorCount >= this.limit) {
            this.tooManyErrors(e);
            this.flush();
            throw new ErrorLimitError();
        }
    }

    protected abstract void displayError(ErrorInfo var1);

    protected void tooManyErrors(ErrorInfo lastError) {
    }

    @Override
    public void flush() {
        this.flushed = true;
    }

    @Override
    public final boolean hasErrors() {
        return this.errorCount > 0;
    }

    @Override
    public final int errorCount() {
        return this.errorCount;
    }
}

