/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import polyglot.types.Declaration;
import polyglot.types.Flags;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeObject_c;
import polyglot.types.TypeSystem;
import polyglot.types.VarInstance;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;

public abstract class VarInstance_c
extends TypeObject_c
implements VarInstance {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Flags flags;
    protected Type type;
    protected String name;
    protected Object constantValue;
    protected boolean isConstant;
    protected boolean constantValueSet;
    protected VarInstance decl;

    protected VarInstance_c() {
    }

    public VarInstance_c(TypeSystem ts, Position pos, Flags flags, Type type, String name) {
        super(ts, pos);
        this.flags = flags;
        this.type = type;
        this.name = name;
        this.decl = this;
    }

    @Override
    public Declaration declaration() {
        return this.decl;
    }

    @Override
    public void setDeclaration(Declaration decl) {
        this.decl = (VarInstance)decl;
    }

    @Override
    public boolean constantValueSet() {
        if (this != this.declaration()) {
            return ((VarInstance)this.declaration()).constantValueSet();
        }
        return this.constantValueSet;
    }

    @Override
    public boolean isConstant() {
        if (this != this.declaration()) {
            return ((VarInstance)this.declaration()).isConstant();
        }
        if (!this.constantValueSet && !this.flags.isFinal()) {
            this.setNotConstant();
            return this.isConstant;
        }
        return this.isConstant;
    }

    @Override
    public Object constantValue() {
        if (this != this.declaration()) {
            return ((VarInstance)this.declaration()).constantValue();
        }
        if (this.isConstant()) {
            return this.constantValue;
        }
        return null;
    }

    @Override
    public Flags flags() {
        return this.flags;
    }

    @Override
    public Type type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int hashCode() {
        return this.flags.hashCode() + this.name.hashCode();
    }

    @Override
    public boolean equalsImpl(TypeObject o) {
        if (o instanceof VarInstance) {
            VarInstance i = (VarInstance)o;
            return this.flags.equals(i.flags()) && this.ts.equals(this.type, i.type()) && this.name.equals(i.name());
        }
        return false;
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public void setFlags(Flags flags) {
        this.flags = flags;
    }

    @Override
    public void setConstantValue(Object constantValue) {
        if (!(constantValue == null || constantValue instanceof Boolean || constantValue instanceof Number || constantValue instanceof Character || constantValue instanceof String)) {
            throw new InternalCompilerError("Can only set constant value to a primitive or String.");
        }
        this.constantValue = constantValue;
        this.isConstant = true;
        this.constantValueSet = true;
    }

    @Override
    public void setNotConstant() {
        this.constantValue = null;
        this.isConstant = false;
        this.constantValueSet = true;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }
}

