/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import polyglot.main.Report;
import polyglot.types.Importable;
import polyglot.types.Named;
import polyglot.types.NoClassException;
import polyglot.types.SemanticException;
import polyglot.types.TopLevelResolver;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;

public class TableResolver
implements TopLevelResolver {
    protected Map<String, Named> table = new HashMap<String, Named>();
    private static final Collection<String> TOPICS = CollectionUtil.list("types", "resolver");

    public void addNamed(Named type) {
        this.addNamed(type.name(), type);
    }

    public void addNamed(String name, Named type) {
        if (name == null || type == null) {
            throw new InternalCompilerError("Bad insertion into TableResolver");
        }
        if (Report.should_report(TOPICS, 3)) {
            Report.report(3, "TableCR.addNamed(" + name + ", " + type + ")");
        }
        this.table.put(name, type);
    }

    @Override
    public boolean packageExists(String name) {
        for (Named type : this.table.values()) {
            Importable im;
            if (!(type instanceof Importable) || (im = (Importable)type).package_() == null || !im.package_().fullName().equals(name) && !im.package_().fullName().startsWith(name + ".")) continue;
            return true;
        }
        return false;
    }

    @Override
    public Named find(String name) throws SemanticException {
        Named n;
        if (Report.should_report(TOPICS, 3)) {
            Report.report(3, "TableCR.find(" + name + ")");
        }
        if ((n = this.table.get(name)) != null) {
            return n;
        }
        throw new NoClassException(name);
    }

    public String toString() {
        return "(table " + this.table + ")";
    }
}

