/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import polyglot.frontend.ExtensionInfo;
import polyglot.main.Report;
import polyglot.types.CachingResolver;
import polyglot.types.ClassType;
import polyglot.types.Importable;
import polyglot.types.Named;
import polyglot.types.Package;
import polyglot.types.ParsedTypeObject;
import polyglot.types.SemanticException;
import polyglot.types.TopLevelResolver;
import polyglot.types.Type;
import polyglot.util.CollectionUtil;
import polyglot.util.Pair;
import polyglot.util.StringUtil;
import polyglot.util.Transformation;
import polyglot.util.TransformingList;

public class SystemResolver
extends CachingResolver
implements TopLevelResolver {
    protected Map<String, Boolean> packageCache;
    protected ExtensionInfo extInfo;
    protected SystemResolver previous;
    protected Collection<Pair<String, Named>> justAdded;
    private static final Collection<String> TOPICS = CollectionUtil.list("types", "resolver", "sysresolver");

    public SystemResolver(TopLevelResolver inner, ExtensionInfo extInfo) {
        super(inner);
        this.extInfo = extInfo;
        this.packageCache = new HashMap<String, Boolean>();
        this.previous = null;
        this.justAdded = new LinkedList<Pair<String, Named>>();
    }

    public SystemResolver previous() {
        return this.previous;
    }

    @Override
    public SystemResolver copy() {
        SystemResolver r = (SystemResolver)super.copy();
        r.packageCache = new HashMap<String, Boolean>(this.packageCache);
        r.previous = this;
        r.justAdded = new LinkedList<Pair<String, Named>>();
        return r;
    }

    public void installInAll(String name, Named n) {
        this.install(name, n);
        if (this.previous != null) {
            this.previous.installInAll(name, n);
        }
    }

    public boolean installedInAll(String name, Named q) {
        if (this.check(name) != q) {
            return false;
        }
        if (this.previous != null) {
            return this.previous.installedInAll(name, q);
        }
        return true;
    }

    protected boolean packageExistsInCache(String name) {
        for (CachingResolver.CachedResult cr : this.cachedResults()) {
            Importable im;
            Named named;
            if (!(cr instanceof CachingResolver.CachedResult.Success) || !((named = ((CachingResolver.CachedResult.Success)cr).named) instanceof Importable) || (im = (Importable)named).package_() == null || im.package_().fullName() == null || !im.package_().fullName().equals(name) && !im.package_().fullName().startsWith(name + ".")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean packageExists(String name) {
        Boolean b = this.packageCache.get(name);
        if (b != null) {
            return b;
        }
        String prefix = StringUtil.getPackageComponent(name);
        if (this.packageCache.containsKey(prefix) && !this.packageCache.get(prefix).booleanValue()) {
            this.packageCache.put(name, false);
            return false;
        }
        boolean exists = this.packageExistsInCache(name);
        if (!exists) {
            exists = ((TopLevelResolver)this.inner).packageExists(name);
        }
        if (exists) {
            this.packageCache.put(name, true);
            do {
                this.packageCache.put(prefix, true);
            } while (!(prefix = StringUtil.getPackageComponent(prefix)).equals(""));
        } else {
            this.packageCache.put(name, false);
        }
        return exists;
    }

    protected void cachePackage(Package p) {
        if (p != null) {
            this.packageCache.put(p.fullName(), true);
            this.cachePackage(p.prefix());
        }
    }

    public Type checkType(String name) {
        return (Type)((Object)this.check(name));
    }

    public Collection<Named> justAdded() {
        return new TransformingList<Pair<String, Named>, Named>(this.justAdded, new Transformation<Pair<String, Named>, Named>(){

            @Override
            public Named transform(Pair<String, Named> o) {
                return o.part2();
            }
        });
    }

    public void clearAdded() {
        this.justAdded = new LinkedList<Pair<String, Named>>();
    }

    public void putAll(SystemResolver r) throws SemanticException {
        for (Pair<String, Named> e : r.justAdded) {
            String name = e.part1();
            Named n = e.part2();
            this.install(name, n);
            if (!(n instanceof Package)) continue;
            Package p = (Package)n;
            this.cachePackage(p);
        }
    }

    @Override
    public Named find(String name) throws SemanticException {
        if (this.previous == null) {
            this.clearAdded();
        }
        Named n = super.find(name);
        if (this.previous == null) {
            if (Report.should_report(TOPICS, 2)) {
                Report.report(2, "Returning from root-level SR.find(" + name + "); added = " + this.justAdded);
            }
            this.clearAdded();
        } else if (Report.should_report(TOPICS, 2)) {
            Report.report(2, "Returning from non-root-level SR.find(" + name + "); added = " + this.justAdded);
        }
        return n;
    }

    @Override
    public void install(String name, Named q) {
        if (Report.should_report(TOPICS, 2) && this.check(name) == null) {
            Report.report(2, (this.previous == null ? "root" : "non-root") + " SR installing " + name + "->" + q + " : " + q.getClass());
        }
        super.install(name, q);
        if (this.previous == null) {
            if (q instanceof ParsedTypeObject && !((ParsedTypeObject)q).initializer().isTypeObjectInitialized()) {
                if (Report.should_report(TOPICS, 2)) {
                    Report.report(2, "SR initializing " + q);
                }
                ((ParsedTypeObject)q).initializer().initTypeObject();
            }
        } else {
            this.justAdded.add(new Pair<String, Named>(name, q));
        }
    }

    @Override
    public void addNamed(String name, Named q) throws SemanticException {
        Package p;
        String containerName;
        ClassType ct;
        super.addNamed(name, q);
        if (q instanceof ClassType) {
            ct = (ClassType)q;
            containerName = StringUtil.getPackageComponent(name);
            if (ct.isTopLevel()) {
                Package p2 = ((ClassType)q).package_();
                this.cachePackage(p2);
                if (p2 != null && containerName.equals(p2.fullName())) {
                    this.addNamed(containerName, p2);
                }
            } else if (ct.isMember() && name.equals(ct.fullName())) {
                this.addNamed(containerName, ct.outer());
            }
        } else if (q instanceof Package) {
            Package p3 = (Package)q;
            this.cachePackage(p3);
            containerName = StringUtil.getPackageComponent(name);
            if (p3.prefix() != null && containerName.equals(p3.prefix().fullName())) {
                this.addNamed(containerName, p3.prefix());
            }
        }
        if (q instanceof ClassType && (p = (ct = (ClassType)q).package_()) != null && this.packageExists(name)) {
            throw new SemanticException("Class \"" + q + "\" clashes with package of the same name.", q.position());
        }
    }
}

