/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.io.File;
import polyglot.frontend.Compiler;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.FileSource;
import polyglot.frontend.Job;
import polyglot.frontend.MissingDependencyException;
import polyglot.frontend.Scheduler;
import polyglot.frontend.goals.Goal;
import polyglot.main.Report;
import polyglot.types.BadSerializationException;
import polyglot.types.LoadedClassResolver;
import polyglot.types.Named;
import polyglot.types.NoClassException;
import polyglot.types.SemanticException;
import polyglot.types.reflect.ClassFile;

public class SourceClassResolver
extends LoadedClassResolver {
    protected Compiler compiler;
    protected ExtensionInfo ext;
    protected boolean compileCommandLineOnly;
    protected boolean ignoreModTimes;

    public SourceClassResolver(Compiler compiler, ExtensionInfo ext, boolean allowRawClasses, boolean compileCommandLineOnly, boolean ignoreModTimes) {
        super(ext, allowRawClasses);
        this.compiler = compiler;
        this.ext = ext;
        this.compileCommandLineOnly = compileCommandLineOnly;
        this.ignoreModTimes = ignoreModTimes;
    }

    @Override
    public boolean packageExists(String name) {
        return super.packageExists(name);
    }

    @Override
    public Named find(String name) throws SemanticException {
        if (Report.should_report(report_topics, 3)) {
            Report.report(3, "SourceCR.find(" + name + ")");
        }
        ClassFile clazz = null;
        ClassFile encodedClazz = null;
        FileSource source = null;
        clazz = this.loadFile(name);
        if (clazz != null) {
            if (clazz.encodedClassType(this.version.name()) != null) {
                if (Report.should_report(report_topics, 4)) {
                    Report.report(4, "Class " + name + " has encoded type info");
                }
                encodedClazz = clazz;
            }
            if (encodedClazz != null && !name.replace(".", "/").equals(encodedClazz.name())) {
                if (Report.should_report(report_topics, 3)) {
                    Report.report(3, "Not using " + encodedClazz.name() + "(case-insensitive filesystem?)");
                }
                encodedClazz = null;
                clazz = null;
            }
        }
        if ((source = this.ext.sourceLoader().classSource(name)) != null) {
            String clazzName;
            String className = source.path();
            int dot1 = className.lastIndexOf(46);
            className = dot1 > 0 ? className.substring(0, dot1) : className;
            int slash1 = className.lastIndexOf(File.separatorChar);
            className = slash1 > 0 ? className.substring(slash1 + 1) : className;
            int dot2 = name.lastIndexOf(46);
            String string = clazzName = dot2 > 0 ? name.substring(dot2 + 1) : name;
            if (!className.equals(clazzName)) {
                source = null;
            }
        }
        if (this.ext.scheduler().sourceHasJob(source)) {
            return this.getTypeFromSource(source, name);
        }
        if (Report.should_report(report_topics, 4)) {
            if (source == null) {
                Report.report(4, "Class " + name + " not found in source file");
            } else {
                Report.report(4, "Class " + name + " found in source " + source);
            }
        }
        if (encodedClazz != null || source != null) {
            if (Report.should_report(report_topics, 4)) {
                Report.report(4, "Not using raw class file for " + name);
            }
            clazz = null;
        }
        if (encodedClazz != null && source != null) {
            long classModTime = encodedClazz.sourceLastModified(this.version.name());
            long sourceModTime = source.getLastModified();
            int comp = this.checkCompilerVersion(encodedClazz.compilerVersion(this.version.name()));
            if (!this.ignoreModTimes && classModTime < sourceModTime) {
                if (Report.should_report(report_topics, 3)) {
                    Report.report(3, "Source file version is newer than compiled for " + name + ".");
                }
                encodedClazz = null;
            } else if (comp != 0) {
                if (Report.should_report(report_topics, 3)) {
                    Report.report(3, "Incompatible source file version for " + name + ".");
                }
                encodedClazz = null;
            }
        }
        Named result = null;
        BadSerializationException se = null;
        if (encodedClazz != null) {
            if (Report.should_report(report_topics, 4)) {
                Report.report(4, "Using encoded class type for " + name);
            }
            try {
                result = this.getEncodedType(encodedClazz, name);
            }
            catch (BadSerializationException e) {
                se = e;
            }
            catch (SemanticException e) {
                if (Report.should_report(report_topics, 4)) {
                    Report.report(4, "Could not load encoded class " + name);
                }
                encodedClazz = null;
            }
        }
        if (result == null && clazz != null && this.allowRawClasses) {
            if (Report.should_report(report_topics, 4)) {
                Report.report(4, "Using raw class file for " + name);
            }
            result = this.ts.classFileLazyClassInitializer(clazz).type();
        }
        if (result == null && source != null) {
            if (Report.should_report(report_topics, 4)) {
                Report.report(4, "Using source file for " + name);
            }
            result = this.getTypeFromSource(source, name);
        }
        if (result != null) {
            return result;
        }
        if (clazz != null && !this.allowRawClasses) {
            throw new SemanticException("Class \"" + name + "\" not found." + " A class file was found at " + clazz.getClassFileURI() + ", but it did not contain appropriate" + " information for the Polyglot-based compiler " + this.ext.compilerName() + ". Try using " + this.ext.compilerName() + " to recompile the source code.");
        }
        throw se == null ? new NoClassException(name) : se;
    }

    protected Named getTypeFromSource(FileSource source, String name) throws SemanticException {
        Scheduler scheduler = this.ext.scheduler();
        Job job = scheduler.loadSource(source, !this.compileCommandLineOnly);
        if (Report.should_report("sourceloader", 3)) {
            new Exception("loaded " + source).printStackTrace();
        }
        if (job != null) {
            Named n = this.ts.systemResolver().check(name);
            if (n != null) {
                return n;
            }
            Goal g = scheduler.TypesInitialized(job);
            if (!scheduler.reached(g)) {
                throw new MissingDependencyException(g);
            }
        }
        throw new NoClassException(name, "Could not find \"" + name + "\" in " + source + ".");
    }
}

