/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import polyglot.frontend.MissingDependencyException;
import polyglot.frontend.Scheduler;
import polyglot.types.LazyClassInitializer;
import polyglot.types.ParsedClassType;
import polyglot.types.TypeSystem;

public class SchedulerClassInitializer
implements LazyClassInitializer {
    protected TypeSystem ts;
    protected ParsedClassType ct;
    protected Scheduler scheduler;
    protected boolean init;
    protected boolean superclassInitialized;
    protected boolean interfacesInitialized;
    protected boolean memberClassesInitialized;
    protected boolean constructorsInitialized;
    protected boolean methodsInitialized;
    protected boolean fieldsInitialized;
    protected boolean constructorsCanonicalized;
    protected boolean methodsCanonicalized;
    protected boolean fieldsCanonicalized;

    public SchedulerClassInitializer(TypeSystem ts) {
        this.ts = ts;
        this.scheduler = ts.extensionInfo().scheduler();
    }

    @Override
    public void setClass(ParsedClassType ct) {
        this.ct = ct;
    }

    @Override
    public boolean fromClassFile() {
        return false;
    }

    @Override
    public void initTypeObject() {
        this.init = true;
    }

    @Override
    public boolean isTypeObjectInitialized() {
        return this.init;
    }

    @Override
    public void initSuperclass() {
        if (!this.superclassInitialized) {
            if (this.ct.supertypesResolved()) {
                this.superclassInitialized = true;
            } else {
                throw new MissingDependencyException(this.scheduler.SupertypesResolved(this.ct));
            }
        }
    }

    @Override
    public void initInterfaces() {
        if (!this.interfacesInitialized) {
            if (this.ct.supertypesResolved()) {
                this.interfacesInitialized = true;
            } else {
                throw new MissingDependencyException(this.scheduler.SupertypesResolved(this.ct));
            }
        }
    }

    @Override
    public void initMemberClasses() {
        if (!this.memberClassesInitialized) {
            if (this.ct.membersAdded()) {
                this.memberClassesInitialized = true;
            } else {
                throw new MissingDependencyException(this.scheduler.MembersAdded(this.ct));
            }
        }
    }

    @Override
    public void canonicalConstructors() {
        if (!this.constructorsCanonicalized) {
            if (this.ct.signaturesResolved()) {
                this.constructorsCanonicalized = true;
            } else {
                throw new MissingDependencyException(this.scheduler.SignaturesResolved(this.ct));
            }
        }
    }

    @Override
    public void canonicalMethods() {
        if (!this.methodsCanonicalized) {
            if (this.ct.signaturesResolved()) {
                this.methodsCanonicalized = true;
            } else {
                throw new MissingDependencyException(this.scheduler.SignaturesResolved(this.ct));
            }
        }
    }

    @Override
    public void canonicalFields() {
        if (!this.fieldsCanonicalized) {
            if (this.ct.signaturesResolved()) {
                this.fieldsCanonicalized = true;
            } else {
                throw new MissingDependencyException(this.scheduler.SignaturesResolved(this.ct));
            }
        }
    }

    @Override
    public void initConstructors() {
        if (!this.constructorsInitialized) {
            if (this.ct.membersAdded()) {
                this.constructorsInitialized = true;
            } else {
                throw new MissingDependencyException(this.scheduler.MembersAdded(this.ct));
            }
        }
    }

    @Override
    public void initMethods() {
        if (!this.methodsInitialized) {
            if (this.ct.membersAdded()) {
                this.methodsInitialized = true;
            } else {
                throw new MissingDependencyException(this.scheduler.MembersAdded(this.ct));
            }
        }
    }

    @Override
    public void initFields() {
        if (!this.fieldsInitialized) {
            if (this.ct.membersAdded()) {
                this.fieldsInitialized = true;
            } else {
                throw new MissingDependencyException(this.scheduler.MembersAdded(this.ct));
            }
        }
    }
}

