/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import polyglot.frontend.Job;
import polyglot.frontend.Source;
import polyglot.main.Report;
import polyglot.types.ClassType;
import polyglot.types.ClassType_c;
import polyglot.types.ConstructorInstance;
import polyglot.types.Declaration;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.LazyClassInitializer;
import polyglot.types.LazyInitializer;
import polyglot.types.MemberInstance;
import polyglot.types.MethodInstance;
import polyglot.types.Package;
import polyglot.types.ParsedClassType;
import polyglot.types.PlaceHolder;
import polyglot.types.ReferenceType;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.util.TypeInputStream;

public class ParsedClassType_c
extends ClassType_c
implements ParsedClassType {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected transient LazyClassInitializer init;
    protected transient Source fromSource;
    protected transient Job job;
    protected Type superType;
    protected List<ReferenceType> interfaces;
    protected List<MethodInstance> methods;
    protected List<FieldInstance> fields;
    protected List<ConstructorInstance> constructors;
    protected Package package_;
    protected Flags flags;
    protected ClassType.Kind kind;
    protected String name;
    protected ClassType outer;
    protected transient List<ClassType> memberClasses;
    protected boolean inStaticContext = false;
    protected boolean needSerialization = true;
    protected boolean membersAdded;
    protected boolean supertypesResolved;
    protected boolean signaturesResolved;
    private static final long writeObjectVersionUID = 1L;
    private static final long readObjectVersionUID = 1L;

    public LazyClassInitializer init() {
        return this.init;
    }

    public void setInit(LazyClassInitializer init) {
        this.init = init;
    }

    protected ParsedClassType_c() {
    }

    public ParsedClassType_c(TypeSystem ts, LazyClassInitializer init, Source fromSource) {
        super(ts);
        this.fromSource = fromSource;
        this.setInitializer(init);
        this.interfaces = new LinkedList<ReferenceType>();
        this.methods = new LinkedList<MethodInstance>();
        this.fields = new LinkedList<FieldInstance>();
        this.constructors = new LinkedList<ConstructorInstance>();
        this.memberClasses = new LinkedList<ClassType>();
    }

    @Override
    public LazyInitializer initializer() {
        return this.init;
    }

    @Override
    public void setInitializer(LazyInitializer init) {
        this.init = (LazyClassInitializer)init;
        ((LazyClassInitializer)init).setClass(this);
    }

    @Override
    public Source fromSource() {
        return this.fromSource;
    }

    @Override
    public Job job() {
        return this.job;
    }

    @Override
    public void setJob(Job job) {
        this.job = job;
    }

    @Override
    public ClassType.Kind kind() {
        return this.kind;
    }

    @Override
    public void inStaticContext(boolean inStaticContext) {
        this.inStaticContext = inStaticContext;
    }

    @Override
    public boolean inStaticContext() {
        return this.inStaticContext;
    }

    @Override
    public ClassType outer() {
        if (this.isTopLevel()) {
            return null;
        }
        if (this.outer == null) {
            throw new InternalCompilerError("Nested class " + this + " must have outer classes.");
        }
        return this.outer;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Type superType() {
        this.init.initSuperclass();
        return this.superType;
    }

    @Override
    public Package package_() {
        return this.package_;
    }

    @Override
    public Flags flags() {
        if (this.isAnonymous()) {
            return Flags.NONE;
        }
        return this.flags;
    }

    @Override
    public void setFlags(Flags flags) {
        this.flags = flags;
    }

    @Override
    public void flags(Flags flags) {
        this.flags = flags;
    }

    @Override
    public void kind(ClassType.Kind kind) {
        this.kind = kind;
    }

    @Override
    public void outer(ClassType outer) {
        if (this.isTopLevel()) {
            throw new InternalCompilerError("Top-level classes cannot have outer classes.");
        }
        this.outer = outer;
    }

    @Override
    public void setContainer(ReferenceType container) {
        if (!(container instanceof ClassType) || !this.isMember()) {
            throw new InternalCompilerError("Only member classes can have containers.");
        }
        this.outer((ClassType)container);
    }

    @Override
    public void name(String name) {
        if (this.isAnonymous()) {
            throw new InternalCompilerError("Anonymous classes cannot have names.");
        }
        this.name = name;
    }

    @Override
    public void position(Position pos) {
        this.position = pos;
    }

    @Override
    public void package_(Package p) {
        this.package_ = p;
    }

    @Override
    public void superType(Type t) {
        this.superType = t;
    }

    @Override
    public void addInterface(ReferenceType t) {
        this.interfaces.add(t);
    }

    @Override
    public void addMethod(MethodInstance mi) {
        this.methods.add(mi);
    }

    @Override
    public void addConstructor(ConstructorInstance ci) {
        this.constructors.add(ci);
    }

    @Override
    public void addField(FieldInstance fi) {
        this.fields.add(fi);
    }

    @Override
    public void addMemberClass(ClassType t) {
        this.memberClasses.add(t);
    }

    @Override
    public void setInterfaces(List<? extends ReferenceType> l) {
        this.interfaces = new ArrayList<ReferenceType>(l);
    }

    @Override
    public void setMethods(List<? extends MethodInstance> l) {
        this.methods = new ArrayList<MethodInstance>(l);
    }

    @Override
    public void setFields(List<? extends FieldInstance> l) {
        this.fields = new ArrayList<FieldInstance>(l);
    }

    @Override
    public void setConstructors(List<? extends ConstructorInstance> l) {
        this.constructors = new ArrayList<ConstructorInstance>(l);
    }

    @Override
    public void setMemberClasses(List<? extends ClassType> l) {
        this.memberClasses = new ArrayList<ClassType>(l);
    }

    @Override
    public boolean defaultConstructorNeeded() {
        this.init.initConstructors();
        if (this.flags().isInterface()) {
            return false;
        }
        return this.constructors.isEmpty();
    }

    @Override
    public List<? extends ConstructorInstance> constructors() {
        this.init.initConstructors();
        this.init.canonicalConstructors();
        return Collections.unmodifiableList(this.constructors);
    }

    @Override
    public List<? extends ClassType> memberClasses() {
        this.init.initMemberClasses();
        return Collections.unmodifiableList(this.memberClasses);
    }

    @Override
    public List<? extends MethodInstance> methods() {
        this.init.initMethods();
        this.init.canonicalMethods();
        return Collections.unmodifiableList(this.methods);
    }

    @Override
    public List<? extends MethodInstance> methodsNamed(String name) {
        this.init.initMethods();
        LinkedList<MethodInstance> l = new LinkedList<MethodInstance>();
        for (MethodInstance mi : this.methods) {
            if (!mi.name().equals(name)) continue;
            if (!mi.isCanonical()) {
                this.init.canonicalMethods();
            }
            l.add(mi);
        }
        return l;
    }

    @Override
    public List<? extends FieldInstance> fields() {
        this.init.initFields();
        this.init.canonicalFields();
        return Collections.unmodifiableList(this.fields);
    }

    @Override
    public FieldInstance fieldNamed(String name) {
        this.init.initFields();
        for (FieldInstance fi : this.fields) {
            if (!fi.name().equals(name)) continue;
            if (!fi.isCanonical()) {
                this.init.canonicalFields();
            }
            return fi;
        }
        return null;
    }

    @Override
    public List<? extends ReferenceType> interfaces() {
        this.init.initInterfaces();
        return Collections.unmodifiableList(this.interfaces);
    }

    @Override
    public boolean membersAdded() {
        return this.membersAdded;
    }

    @Override
    public void setMembersAdded(boolean membersAdded) {
        this.membersAdded = membersAdded;
    }

    @Override
    public void setSignaturesResolved(boolean signaturesDisambiguated) {
        this.signaturesResolved = signaturesDisambiguated;
    }

    @Override
    public boolean supertypesResolved() {
        return this.supertypesResolved;
    }

    @Override
    public void setSupertypesResolved(boolean supertypesResolved) {
        this.supertypesResolved = supertypesResolved;
    }

    @Override
    public int numSignaturesUnresolved() {
        if (this.signaturesResolved) {
            return 0;
        }
        if (!this.membersAdded()) {
            return Integer.MAX_VALUE;
        }
        ArrayList<Declaration> l = new ArrayList<Declaration>();
        l.addAll(this.methods);
        l.addAll(this.fields);
        l.addAll(this.constructors);
        l.addAll(this.memberClasses);
        int count = 0;
        for (MemberInstance memberInstance : l) {
            if (memberInstance.isCanonical()) continue;
            ++count;
        }
        if (count == 0) {
            this.signaturesResolved = true;
        }
        return count;
    }

    @Override
    public boolean signaturesResolved() {
        if (!this.signaturesResolved) {
            if (!this.membersAdded()) {
                return false;
            }
            ArrayList<Declaration> l = new ArrayList<Declaration>();
            l.addAll(this.methods);
            l.addAll(this.fields);
            l.addAll(this.constructors);
            l.addAll(this.memberClasses);
            int count = 0;
            for (MemberInstance memberInstance : l) {
                if (memberInstance.isCanonical()) continue;
                if (Report.should_report("ambcheck", 2)) {
                    Report.report(2, memberInstance + " is ambiguous");
                }
                ++count;
            }
            if (count == 0) {
                this.signaturesResolved = true;
            }
        }
        return this.signaturesResolved;
    }

    @Override
    public String toString() {
        if (this.kind() == null) {
            return "<unknown class " + this.name + ">";
        }
        if (this.isAnonymous()) {
            if (this.interfaces != null && !this.interfaces.isEmpty()) {
                return "<anonymous subtype of " + this.interfaces.get(0) + ">";
            }
            if (this.superType != null) {
                return "<anonymous subclass of " + this.superType + ">";
            }
        }
        return super.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Object o = this.ts.placeHolder(this);
        if (o instanceof PlaceHolder && o != this) {
            out.writeBoolean(true);
            out.writeObject(o);
        } else {
            out.writeBoolean(false);
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (in instanceof TypeInputStream) {
            TypeInputStream tin = (TypeInputStream)in;
            boolean b = tin.readBoolean();
            if (b) {
                tin.enableReplace(false);
                PlaceHolder p = (PlaceHolder)tin.readObject();
                tin.installInPlaceHolderCache(p, this);
                tin.enableReplace(true);
            }
            this.fromSource = null;
            this.job = null;
            this.init = tin.getTypeSystem().deserializedClassInitializer();
            this.init.setClass(this);
            this.membersAdded = true;
            this.supertypesResolved = true;
            this.signaturesResolved = true;
            this.memberClasses = new ArrayList<ClassType>();
        }
        in.defaultReadObject();
    }

    @Override
    public void needSerialization(boolean b) {
        this.needSerialization = b;
    }

    @Override
    public boolean needSerialization() {
        return this.needSerialization;
    }
}

