/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import polyglot.types.AbstractAccessControlResolver;
import polyglot.types.ClassType;
import polyglot.types.Named;
import polyglot.types.NoClassException;
import polyglot.types.Package;
import polyglot.types.Resolver;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.StringUtil;

public class PackageContextResolver
extends AbstractAccessControlResolver {
    protected Package p;

    public PackageContextResolver(TypeSystem ts, Package p) {
        super(ts);
        this.p = p;
    }

    public Package package_() {
        return this.p;
    }

    public Resolver outer() {
        return this.ts.systemResolver();
    }

    @Override
    public Named find(String name, ClassType accessor) throws SemanticException {
        Named n;
        block5: {
            if (!StringUtil.isNameShort(name)) {
                throw new InternalCompilerError("Cannot lookup qualified name " + name);
            }
            n = null;
            try {
                n = this.ts.systemResolver().find(this.p.fullName() + "." + name);
            }
            catch (NoClassException e) {
                if (e.getClassName().equals(this.p.fullName() + "." + name)) break block5;
                throw e;
            }
        }
        if (n == null) {
            n = this.ts.createPackage(this.p, name);
        }
        if (!this.canAccess(n, accessor)) {
            throw new SemanticException("Cannot access " + n + " from " + accessor + ".");
        }
        return n;
    }

    protected boolean canAccess(Named n, ClassType accessor) {
        if (n instanceof ClassType) {
            return accessor == null || this.ts.classAccessible((ClassType)n, accessor);
        }
        return true;
    }

    public String toString() {
        return "(package-context " + this.p.toString() + ")";
    }
}

