/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import polyglot.types.Named;
import polyglot.types.SemanticException;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;

public class NoClassException
extends SemanticException {
    private static final long serialVersionUID = SerialVersionUID.generate();
    private String className;

    private static String message(String className, Named scope) {
        if (scope == null) {
            return "Class \"" + className + "\" not found.";
        }
        return "Class \"" + className + "\" not found" + " in scope of " + scope.toString();
    }

    public NoClassException(String className) {
        super(NoClassException.message(className, null));
        this.className = className;
    }

    public NoClassException(String className, String msg) {
        super(msg);
        this.className = className;
    }

    public NoClassException(String className, Named scope) {
        super(NoClassException.message(className, scope));
        this.className = className;
    }

    public NoClassException(String className, Position position) {
        super(NoClassException.message(className, null), position);
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }
}

