/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import polyglot.util.Copy;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;

public class Flags
implements Serializable,
Copy<Flags> {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Set<String> flags = new TreeSet<String>(FlagComparator.instance);
    protected Position position = Position.compilerGenerated();
    public static final Flags NONE = new Flags();
    public static final Flags PUBLIC = Flags.createFlag("public", null);
    public static final Flags PROTECTED = Flags.createFlag("protected", null);
    public static final Flags PRIVATE = Flags.createFlag("private", null);
    public static final Flags ABSTRACT = Flags.createFlag("abstract", null);
    public static final Flags STATIC = Flags.createFlag("static", null);
    public static final Flags FINAL = Flags.createFlag("final", null);
    public static final Flags SYNCHRONIZED = Flags.createFlag("synchronized", null);
    public static final Flags NATIVE = Flags.createFlag("native", null);
    public static final Flags STRICTFP = Flags.createFlag("strictfp", null);
    public static final Flags TRANSIENT = Flags.createFlag("transient", null);
    public static final Flags VOLATILE = Flags.createFlag("volatile", null);
    public static final Flags INTERFACE = Flags.createFlag("interface", null);
    protected static final Flags ACCESS_FLAGS = PUBLIC.set(PRIVATE).set(PROTECTED);

    public static Flags createFlag(String name, Flags after) {
        Flags.addToOrder(name, after);
        return new Flags(name);
    }

    public static void addToOrder(String name, Flags after) {
        int index;
        Map<String, Integer> ordering = FlagComparator.ordering;
        Map<Integer, String> revOrdering = FlagComparator.revOrdering;
        if (ordering.containsKey(name)) {
            throw new InternalCompilerError("Flag " + name + " already added.");
        }
        if (after == null) {
            index = ordering.size() + 1;
        } else {
            index = 0;
            for (String s : after.flags) {
                int si = ordering.get(s);
                if (si <= index) continue;
                index = si;
            }
            for (int i = ordering.size(); i > index; --i) {
                String s;
                s = revOrdering.get(i);
                ordering.put(s, i + 1);
                revOrdering.put(i + 1, s);
            }
            ++index;
        }
        ordering.put(name, index);
        revOrdering.put(index, name);
    }

    protected Flags() {
    }

    protected Flags(String name) {
        this();
        this.flags.add(name);
    }

    public Set<String> flags() {
        return this.flags;
    }

    public Position position() {
        return this.position;
    }

    public Flags position(Position position) {
        return this.position(this, position);
    }

    protected Flags position(Flags flags, Position position) {
        if (flags.position == position) {
            return flags;
        }
        flags = this.copyIfNeeded(flags);
        flags.position = position;
        return flags;
    }

    protected Flags copyIfNeeded(Flags flags) {
        if (flags == this) {
            flags = Copy.Util.copy(flags);
        }
        return flags;
    }

    @Override
    public Flags copy() {
        try {
            Flags flags = (Flags)super.clone();
            return flags;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalCompilerError("Java clone() weirdness.");
        }
    }

    public Flags set(Flags other) {
        Flags f = new Flags();
        f.flags.addAll(this.flags);
        f.flags.addAll(other.flags);
        Position start = Position.first(this.position, other.position);
        Position end = Position.last(this.position, other.position);
        f.position = start == null || end == null ? Position.compilerGenerated() : new Position(start, end);
        return f;
    }

    public Flags clear(Flags other) {
        Flags f = new Flags();
        f.flags.addAll(this.flags);
        f.flags.removeAll(other.flags);
        f.position = Position.compilerGenerated();
        return f;
    }

    public Flags retain(Flags other) {
        Flags f = new Flags();
        f.flags.addAll(this.flags);
        f.flags.retainAll(other.flags);
        f.position = Position.compilerGenerated();
        return f;
    }

    public boolean intersects(Flags other) {
        for (String name : this.flags) {
            if (!other.flags.contains(name)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Flags other) {
        return this.flags.containsAll(other.flags);
    }

    public Flags Public() {
        return this.set(PUBLIC);
    }

    public Flags clearPublic() {
        return this.clear(PUBLIC);
    }

    public boolean isPublic() {
        return this.contains(PUBLIC);
    }

    public Flags Private() {
        return this.set(PRIVATE);
    }

    public Flags clearPrivate() {
        return this.clear(PRIVATE);
    }

    public boolean isPrivate() {
        return this.contains(PRIVATE);
    }

    public Flags Protected() {
        return this.set(PROTECTED);
    }

    public Flags clearProtected() {
        return this.clear(PROTECTED);
    }

    public boolean isProtected() {
        return this.contains(PROTECTED);
    }

    public Flags Package() {
        return this.clear(ACCESS_FLAGS);
    }

    public boolean isPackage() {
        return !this.intersects(ACCESS_FLAGS);
    }

    public Flags Static() {
        return this.set(STATIC);
    }

    public Flags clearStatic() {
        return this.clear(STATIC);
    }

    public boolean isStatic() {
        return this.contains(STATIC);
    }

    public Flags Final() {
        return this.set(FINAL);
    }

    public Flags clearFinal() {
        return this.clear(FINAL);
    }

    public boolean isFinal() {
        return this.contains(FINAL);
    }

    public Flags Synchronized() {
        return this.set(SYNCHRONIZED);
    }

    public Flags clearSynchronized() {
        return this.clear(SYNCHRONIZED);
    }

    public boolean isSynchronized() {
        return this.contains(SYNCHRONIZED);
    }

    public Flags Transient() {
        return this.set(TRANSIENT);
    }

    public Flags clearTransient() {
        return this.clear(TRANSIENT);
    }

    public boolean isTransient() {
        return this.contains(TRANSIENT);
    }

    public Flags Native() {
        return this.set(NATIVE);
    }

    public Flags clearNative() {
        return this.clear(NATIVE);
    }

    public boolean isNative() {
        return this.contains(NATIVE);
    }

    public Flags Interface() {
        return this.set(INTERFACE);
    }

    public Flags clearInterface() {
        return this.clear(INTERFACE);
    }

    public boolean isInterface() {
        return this.contains(INTERFACE);
    }

    public Flags Abstract() {
        return this.set(ABSTRACT);
    }

    public Flags clearAbstract() {
        return this.clear(ABSTRACT);
    }

    public boolean isAbstract() {
        return this.contains(ABSTRACT);
    }

    public Flags Volatile() {
        return this.set(VOLATILE);
    }

    public Flags clearVolatile() {
        return this.clear(VOLATILE);
    }

    public boolean isVolatile() {
        return this.contains(VOLATILE);
    }

    public Flags StrictFP() {
        return this.set(STRICTFP);
    }

    public Flags clearStrictFP() {
        return this.clear(STRICTFP);
    }

    public boolean isStrictFP() {
        return this.contains(STRICTFP);
    }

    public boolean moreRestrictiveThan(Flags f) {
        if (this.isPrivate() && (f.isProtected() || f.isPackage() || f.isPublic())) {
            return true;
        }
        if (this.isPackage() && (f.isProtected() || f.isPublic())) {
            return true;
        }
        return this.isProtected() && f.isPublic();
    }

    public String toString() {
        return this.translate().trim();
    }

    public String translate() {
        StringBuffer sb = new StringBuffer();
        for (String s : this.flags) {
            sb.append(s);
            sb.append(" ");
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.flags.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof Flags && this.flags.equals(((Flags)o).flags);
    }

    public boolean isEmpty() {
        return this.flags.isEmpty();
    }

    protected static class FlagComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = SerialVersionUID.generate();
        protected static final FlagComparator instance = new FlagComparator();
        protected static Map<String, Integer> ordering = new HashMap<String, Integer>();
        protected static Map<Integer, String> revOrdering = new HashMap<Integer, String>();
        private static final long readResolveVersionUID = 1L;

        protected FlagComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (ordering.containsKey(o1) && ordering.containsKey(o2)) {
                return ordering.get(o1) - ordering.get(o2);
            }
            return o1.compareTo(o2);
        }

        private Object readResolve() {
            return instance;
        }
    }
}

