/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import polyglot.frontend.Job;
import polyglot.main.Options;
import polyglot.types.CachingResolver;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.Declaration;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.MemberInstance;
import polyglot.types.MethodInstance;
import polyglot.types.Named;
import polyglot.types.Package;
import polyglot.types.ReferenceType;
import polyglot.types.ReferenceType_c;
import polyglot.types.Resolver;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;

public abstract class ClassType_c
extends ReferenceType_c
implements ClassType {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected transient Resolver memberCache;
    protected ClassType decl;

    protected ClassType_c() {
    }

    public ClassType_c(TypeSystem ts) {
        this(ts, null);
    }

    public ClassType_c(TypeSystem ts, Position pos) {
        super(ts, pos);
        this.decl = this;
    }

    @Override
    public Resolver resolver() {
        if (this.memberCache == null) {
            this.memberCache = new CachingResolver(this.ts.createClassContextResolver(this));
        }
        return this.memberCache;
    }

    @Override
    public ClassType_c copy() {
        ClassType_c n = (ClassType_c)super.copy();
        n.memberCache = null;
        return n;
    }

    @Override
    public Declaration declaration() {
        return this.decl;
    }

    @Override
    public void setDeclaration(Declaration decl) {
        this.decl = (ClassType)decl;
    }

    public abstract Job job();

    @Override
    public abstract ClassType.Kind kind();

    @Override
    public abstract ClassType outer();

    @Override
    public abstract String name();

    @Override
    public ReferenceType container() {
        if (!this.isMember()) {
            throw new InternalCompilerError("Non-member class " + this + " cannot have container classes.");
        }
        if (this.outer() == null) {
            throw new InternalCompilerError("Nested class " + this + " must have an outer class.");
        }
        return this.outer();
    }

    @Override
    public String fullName() {
        if (this.isAnonymous()) {
            return this.toString();
        }
        String name = this.name();
        if (this.isTopLevel() && this.package_() != null) {
            return this.package_().fullName() + "." + name;
        }
        if (!this.isMember()) {
            return name;
        }
        ReferenceType container = this.container();
        if (!(container instanceof Named)) {
            return name;
        }
        if (container instanceof ClassType && ((ClassType)container).isAnonymous()) {
            return name;
        }
        return ((Named)((Object)container)).fullName() + "." + name;
    }

    @Override
    public boolean isTopLevel() {
        return this.kind() == TOP_LEVEL;
    }

    @Override
    public boolean isMember() {
        return this.kind() == MEMBER;
    }

    @Override
    public boolean isLocal() {
        return this.kind() == LOCAL;
    }

    @Override
    public boolean isAnonymous() {
        return this.kind() == ANONYMOUS;
    }

    @Override
    @Deprecated
    public final boolean isInner() {
        return this.isNested();
    }

    @Override
    public boolean isNested() {
        return this.kind() == MEMBER || this.kind() == LOCAL || this.kind() == ANONYMOUS;
    }

    @Override
    public boolean isInnerClass() {
        return !this.flags().isInterface() && this.isNested() && !this.flags().isStatic();
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public boolean isClass() {
        return true;
    }

    @Override
    public ClassType toClass() {
        return this;
    }

    @Override
    public abstract Package package_();

    @Override
    public abstract Flags flags();

    @Override
    public abstract List<? extends ConstructorInstance> constructors();

    @Override
    public abstract List<? extends ClassType> memberClasses();

    @Override
    public abstract List<? extends MethodInstance> methods();

    @Override
    public abstract List<? extends FieldInstance> fields();

    @Override
    public abstract List<? extends ReferenceType> interfaces();

    @Override
    public abstract Type superType();

    @Override
    public List<? extends MemberInstance> members() {
        LinkedList<Declaration> l = new LinkedList<Declaration>();
        l.addAll(this.methods());
        l.addAll(this.fields());
        l.addAll(this.constructors());
        l.addAll(this.memberClasses());
        return l;
    }

    @Override
    public FieldInstance fieldNamed(String name) {
        for (FieldInstance fieldInstance : this.fields()) {
            if (!fieldInstance.name().equals(name)) continue;
            return fieldInstance;
        }
        return null;
    }

    @Override
    public ClassType memberClassNamed(String name) {
        for (ClassType classType : this.memberClasses()) {
            if (!classType.name().equals(name)) continue;
            return classType;
        }
        return null;
    }

    @Override
    public boolean descendsFromImpl(Type ancestor) {
        if (!ancestor.isCanonical()) {
            return false;
        }
        if (ancestor.isNull()) {
            return false;
        }
        if (this.ts.typeEquals(this, ancestor)) {
            return false;
        }
        if (!ancestor.isReference()) {
            return false;
        }
        if (this.ts.typeEquals(ancestor, this.ts.Object())) {
            return true;
        }
        if (!this.flags().isInterface()) {
            if (this.ts.typeEquals(this, this.ts.Object())) {
                return false;
            }
            if (this.superType() == null) {
                return false;
            }
            if (this.ts.isSubtype(this.superType(), ancestor)) {
                return true;
            }
        }
        for (Type type : this.interfaces()) {
            if (!this.ts.isSubtype(type, ancestor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isThrowable() {
        return this.ts.isSubtype(this, this.ts.Throwable());
    }

    @Override
    public boolean isUncheckedException() {
        if (this.isThrowable()) {
            for (Type t : this.ts.uncheckedExceptions()) {
                if (!this.ts.isSubtype(this, t)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isImplicitCastValidImpl(Type toType) {
        if (!toType.isClass()) {
            return false;
        }
        return this.ts.isSubtype(this, toType);
    }

    @Override
    public boolean isCastValidImpl(Type toType) {
        if (!toType.isCanonical()) {
            return false;
        }
        if (!toType.isReference()) {
            return false;
        }
        if (toType.isArray()) {
            return this.ts.isSubtype(toType, this);
        }
        if (!toType.isClass()) {
            return false;
        }
        boolean fromInterface = this.flags().isInterface();
        boolean toInterface = toType.toClass().flags().isInterface();
        boolean fromFinal = this.flags().isFinal();
        boolean toFinal = toType.toClass().flags().isFinal();
        if (!fromInterface) {
            if (!toInterface) {
                return this.ts.isSubtype(this, toType) || this.ts.isSubtype(toType, this);
            }
            if (fromFinal) {
                return this.ts.isSubtype(this, toType);
            }
            return true;
        }
        if (!toInterface && !toFinal) {
            return true;
        }
        if (toFinal) {
            return this.ts.isSubtype(toType, this);
        }
        HashMap<String, MethodInstance> signatureMap = new HashMap<String, MethodInstance>();
        LinkedList<? extends ReferenceType> typeList = new LinkedList<ReferenceType>();
        typeList.add(this);
        typeList.add(toType.toClass());
        while (!typeList.isEmpty()) {
            ReferenceType type = (ReferenceType)typeList.remove(0);
            for (MethodInstance methodInstance : type.methods()) {
                String signature = methodInstance.signature();
                if (signatureMap.containsKey(signature)) {
                    MethodInstance mj = (MethodInstance)signatureMap.get(signature);
                    if (this.ts.typeEquals(methodInstance.returnType(), mj.returnType())) continue;
                    return false;
                }
                signatureMap.put(signature, methodInstance);
            }
            typeList.addAll(type.interfaces());
        }
        return true;
    }

    @Override
    public final boolean isEnclosed(ClassType maybe_outer) {
        return this.ts.isEnclosed(this, maybe_outer);
    }

    @Override
    public final boolean hasEnclosingInstance(ClassType encl) {
        return this.ts.hasEnclosingInstance(this, encl);
    }

    @Override
    public String translate(Resolver c) {
        if (this.isTopLevel()) {
            if (this.package_() == null) {
                return this.name();
            }
            if (c != null && !Options.global.fully_qualified_names) {
                try {
                    Named x = c.find(this.name());
                    if (this.ts.equals(this, x)) {
                        return this.name();
                    }
                }
                catch (SemanticException x) {
                    // empty catch block
                }
            }
            return this.package_().translate(c) + "." + this.name();
        }
        if (this.isMember()) {
            if (this.container().toClass().isAnonymous()) {
                return this.name();
            }
            if (c != null && !Options.global.fully_qualified_names) {
                try {
                    Named x = c.find(this.name());
                    if (this.ts.equals(this, x)) {
                        return this.name();
                    }
                }
                catch (SemanticException semanticException) {
                    // empty catch block
                }
            }
            return this.container().translate(c) + "." + this.name();
        }
        if (this.isLocal()) {
            return this.name();
        }
        throw new InternalCompilerError("Cannot translate an anonymous class: " + this, this.position());
    }

    @Override
    public String toString() {
        if (this.isTopLevel()) {
            if (this.package_() != null) {
                return this.package_() + "." + this.name();
            }
            return this.name();
        }
        if (this.isMember()) {
            return this.container().toString() + "." + this.name();
        }
        if (this.isLocal()) {
            return this.name();
        }
        if (this.isAnonymous()) {
            return "<anonymous class>";
        }
        return "<unknown class>";
    }

    @Override
    public void print(CodeWriter w) {
        if (this.isTopLevel()) {
            if (this.package_() != null) {
                this.package_().print(w);
                w.write(".");
                w.allowBreak(2, 3, "", 0);
            }
            w.write(this.name());
        } else if (this.isMember()) {
            this.container().print(w);
            w.write(".");
            w.allowBreak(2, 3, "", 0);
            w.write(this.name());
        } else if (this.isLocal()) {
            w.write(this.name());
        } else if (this.isAnonymous()) {
            w.write("<anonymous class>");
        } else {
            w.write("<unknown class>");
        }
    }

    @Override
    public boolean isEnclosedImpl(ClassType maybe_outer) {
        if (this.isTopLevel()) {
            return false;
        }
        if (this.outer() != null) {
            return this.outer().equals(maybe_outer) || this.outer().isEnclosed(maybe_outer);
        }
        throw new InternalCompilerError("Non top-level classes must have outer classes.");
    }

    @Override
    public boolean hasEnclosingInstanceImpl(ClassType encl) {
        if (this.equals(encl)) {
            return true;
        }
        if (!this.isInnerClass() || this.inStaticContext()) {
            return false;
        }
        return this.outer().hasEnclosingInstance(encl);
    }
}

