/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import polyglot.main.Report;
import polyglot.types.AbstractAccessControlResolver;
import polyglot.types.ClassType;
import polyglot.types.MemberInstance;
import polyglot.types.Named;
import polyglot.types.NoClassException;
import polyglot.types.ParsedTypeObject;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.StringUtil;

public class ClassContextResolver
extends AbstractAccessControlResolver {
    protected ClassType type;
    private static final Collection<String> TOPICS = CollectionUtil.list("types", "resolver");

    public ClassContextResolver(TypeSystem ts, ClassType type) {
        super(ts);
        this.type = type;
    }

    public String toString() {
        return "(class-context " + this.type + ")";
    }

    @Override
    public Named find(String name, ClassType accessor) throws SemanticException {
        if (Report.should_report(TOPICS, 2)) {
            Report.report(2, "Looking for " + name + " in " + this);
        }
        if (!StringUtil.isNameShort(name)) {
            throw new InternalCompilerError("Cannot lookup qualified name " + name);
        }
        LinkedList<ClassType> typeQueue = new LinkedList<ClassType>();
        typeQueue.addLast(this.type);
        HashSet<MemberInstance> acceptable = new HashSet<MemberInstance>();
        SemanticException error = null;
        while (!typeQueue.isEmpty()) {
            Type sup;
            ClassType type = (ClassType)typeQueue.removeFirst();
            Object m = type.memberClassNamed(name);
            String fullName = type.fullName() + "." + name;
            String rawName = this.ts.getTransformedClassName(type) + "$" + name;
            if (m == null) {
                m = this.ts.systemResolver().check(fullName);
            }
            if (m == null) {
                m = this.ts.systemResolver().check(rawName);
            }
            if (m == null) {
                ParsedTypeObject parsedTypeObject;
                boolean useLoadedResolver = true;
                if (type instanceof ParsedTypeObject && (parsedTypeObject = (ParsedTypeObject)((Object)type)).job() != null) {
                    useLoadedResolver = false;
                }
                if (useLoadedResolver) {
                    try {
                        m = this.ts.systemResolver().find(rawName);
                    }
                    catch (SemanticException semanticException) {
                        // empty catch block
                    }
                }
            }
            if (m instanceof MemberInstance) {
                MemberInstance mi = (MemberInstance)m;
                if (!this.ts.isMember(mi, this.type)) {
                    if (error != null) continue;
                    error = new SemanticException("Member class " + m + " is not visible in class " + this.type);
                    continue;
                }
                if (!this.canAccess(mi, accessor)) {
                    if (error != null) continue;
                    error = new SemanticException("Cannot access member type \"" + m + "\" from class " + accessor + ".");
                    continue;
                }
                acceptable.add(mi);
                continue;
            }
            if (type.superType() != null && (sup = type.superType()) instanceof ClassType) {
                ClassType classType = (ClassType)sup;
                typeQueue.addLast(classType);
            }
            for (Type type2 : type.interfaces()) {
                if (!(type2 instanceof ClassType)) continue;
                ClassType ct = (ClassType)type2;
                typeQueue.addLast(ct);
            }
        }
        if (acceptable.size() == 0) {
            throw error == null ? new NoClassException(name, this.type) : error;
        }
        if (acceptable.size() > 1) {
            HashSet<ReferenceType> containers = new HashSet<ReferenceType>(acceptable.size());
            for (MemberInstance mi : acceptable) {
                containers.add(mi.container());
            }
            if (containers.size() == 2) {
                Iterator i = containers.iterator();
                Type t1 = (Type)i.next();
                Type t2 = (Type)i.next();
                throw new SemanticException("Member \"" + name + "\" of " + this.type + " is ambiguous; it is defined in both " + t1 + " and " + t2 + ".");
            }
            throw new SemanticException("Member \"" + name + "\" of " + this.type + " is ambiguous; it is defined in " + containers + ".");
        }
        MemberInstance mi = (MemberInstance)acceptable.iterator().next();
        if (Report.should_report(TOPICS, 2)) {
            Report.report(2, "Found member class " + mi);
        }
        return (Named)((Object)mi);
    }

    protected boolean canAccess(MemberInstance n, ClassType accessor) {
        return accessor == null || this.ts.isAccessible(n, (ReferenceType)this.type, accessor);
    }

    public ClassType classType() {
        return this.type;
    }
}

