/*
 * Decompiled with CFR 0.152.
 */
package polyglot.translate;

import java.util.Collections;
import java.util.List;
import polyglot.frontend.EmptyPass;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.JLExtensionInfo;
import polyglot.frontend.JLScheduler;
import polyglot.frontend.Job;
import polyglot.frontend.Pass;
import polyglot.frontend.Scheduler;
import polyglot.frontend.goals.Goal;
import polyglot.frontend.goals.SourceFileGoal;
import polyglot.main.OptFlag;
import polyglot.main.Options;
import polyglot.main.UsageError;
import polyglot.util.InternalCompilerError;

public class JLOutputExtensionInfo
extends JLExtensionInfo {
    protected final ExtensionInfo parent;

    public JLOutputExtensionInfo(ExtensionInfo parent) {
        this.parent = parent;
    }

    @Override
    public Scheduler createScheduler() {
        return new JLOutputScheduler(this);
    }

    @Override
    protected Options createOptions() {
        Options parentOpts = this.parent.getOptions();
        JLOutputOptions opt = new JLOutputOptions(this);
        List<OptFlag.Arg<?>> arguments = parentOpts.filterArgs(opt.flags());
        try {
            opt.processArguments(arguments, Collections.emptySet());
        }
        catch (UsageError e) {
            throw new InternalCompilerError("Got usage error while configuring output extension", e);
        }
        return opt;
    }

    protected static class JLOutputScheduler
    extends JLScheduler {
        public JLOutputScheduler(ExtensionInfo extInfo) {
            super(extInfo);
        }

        @Override
        public Goal Parsed(Job job) {
            return this.internGoal(new SourceFileGoal(job){

                @Override
                public Pass createPass(ExtensionInfo extInfo) {
                    return new EmptyPass(this);
                }
            });
        }
    }

    protected static class JLOutputOptions
    extends Options {
        public JLOutputOptions(ExtensionInfo extension) {
            super(extension);
        }

        @Override
        protected void validateArgs() throws UsageError {
        }
    }
}

